"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TextEditorContext = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _atom = require("atom");

var _eventKit = require("event-kit");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const editorUpdateProps = {
  mini: _propTypes.default.bool,
  readOnly: _propTypes.default.bool,
  placeholderText: _propTypes.default.string,
  lineNumberGutterVisible: _propTypes.default.bool,
  autoHeight: _propTypes.default.bool,
  autoWidth: _propTypes.default.bool,
  softWrapped: _propTypes.default.bool
};

const editorCreationProps = _objectSpread2({
  buffer: _propTypes.default.object
}, editorUpdateProps);

const EMPTY_CLASS = 'github-AtomTextEditor-empty';

const TextEditorContext = _react.default.createContext();

exports.TextEditorContext = TextEditorContext;

class AtomTextEditor extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "observeSelections", selection => {
      const selectionSubs = new _eventKit.CompositeDisposable(selection.onDidChangeRange(this.props.didChangeSelectionRange), selection.onDidDestroy(() => {
        selectionSubs.dispose();
        this.subs.remove(selectionSubs);
        this.props.didDestroySelection(selection);
      }));
      this.subs.add(selectionSubs);
      this.props.didAddSelection(selection);
    });

    _defineProperty(this, "observeEmptiness", () => {
      this.getRefModel().map(editor => {
        if (editor.isEmpty() && this.props.hideEmptiness) {
          this.getRefElement().map(element => element.classList.add(EMPTY_CLASS));
        } else {
          this.getRefElement().map(element => element.classList.remove(EMPTY_CLASS));
        }

        return null;
      });
    });

    this.subs = new _eventKit.CompositeDisposable();
    this.refParent = new _refHolder.default();
    this.refElement = null;
    this.refModel = null;
  }

  render() {
    return _react.default.createElement(_react.Fragment, null, _react.default.createElement("div", {
      className: "github-AtomTextEditor-container",
      ref: this.refParent.setter
    }), _react.default.createElement(TextEditorContext.Provider, {
      value: this.getRefModel()
    }, this.props.children));
  }

  componentDidMount() {
    const modelProps = (0, _helpers.extractProps)(this.props, editorCreationProps);
    this.refParent.map(element => {
      const editor = new _atom.TextEditor(modelProps);
      editor.getElement().tabIndex = this.props.tabIndex;

      if (this.props.className) {
        editor.getElement().classList.add(this.props.className);
      }

      if (this.props.preselect) {
        editor.selectAll();
      }

      element.appendChild(editor.getElement());
      this.getRefModel().setter(editor);
      this.getRefElement().setter(editor.getElement());
      this.subs.add(editor.onDidChangeCursorPosition(this.props.didChangeCursorPosition), editor.observeSelections(this.observeSelections), editor.onDidChange(this.observeEmptiness));

      if (editor.isEmpty() && this.props.hideEmptiness) {
        editor.getElement().classList.add(EMPTY_CLASS);
      }

      return null;
    });
  }

  componentDidUpdate() {
    const modelProps = (0, _helpers.extractProps)(this.props, editorUpdateProps);
    this.getRefModel().map(editor => editor.update(modelProps)); // When you look into the abyss, the abyss also looks into you

    this.observeEmptiness();
  }

  componentWillUnmount() {
    this.getRefModel().map(editor => editor.destroy());
    this.subs.dispose();
  }

  contains(element) {
    return this.getRefElement().map(e => e.contains(element)).getOr(false);
  }

  focus() {
    this.getRefElement().map(e => e.focus());
  }

  getRefModel() {
    if (this.props.refModel) {
      return this.props.refModel;
    }

    if (!this.refModel) {
      this.refModel = new _refHolder.default();
    }

    return this.refModel;
  }

  getRefElement() {
    if (this.props.refElement) {
      return this.props.refElement;
    }

    if (!this.refElement) {
      this.refElement = new _refHolder.default();
    }

    return this.refElement;
  }

  getModel() {
    return this.getRefModel().getOr(undefined);
  }

}

exports.default = AtomTextEditor;

_defineProperty(AtomTextEditor, "propTypes", _objectSpread2({}, editorCreationProps, {
  didChangeCursorPosition: _propTypes.default.func,
  didAddSelection: _propTypes.default.func,
  didChangeSelectionRange: _propTypes.default.func,
  didDestroySelection: _propTypes.default.func,
  hideEmptiness: _propTypes.default.bool,
  preselect: _propTypes.default.bool,
  className: _propTypes.default.string,
  tabIndex: _propTypes.default.number,
  refModel: _propTypes2.RefHolderPropType,
  refElement: _propTypes2.RefHolderPropType,
  children: _propTypes.default.node
}));

_defineProperty(AtomTextEditor, "defaultProps", {
  didChangeCursorPosition: () => {},
  didAddSelection: () => {},
  didChangeSelectionRange: () => {},
  didDestroySelection: () => {},
  hideEmptiness: false,
  preselect: false,
  tabIndex: 0
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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