"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DecorableContext = exports.MarkerContext = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _atomTextEditor = require("./atom-text-editor");

var _markerLayer = require("./marker-layer");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const MarkablePropType = _propTypes.default.shape({
  markBufferRange: _propTypes.default.func.isRequired
});

const markerProps = {
  exclusive: _propTypes.default.bool,
  reversed: _propTypes.default.bool,
  invalidate: _propTypes.default.oneOf(['never', 'surround', 'overlap', 'inside', 'touch'])
};

const MarkerContext = _react.default.createContext();

exports.MarkerContext = MarkerContext;

const DecorableContext = _react.default.createContext();

exports.DecorableContext = DecorableContext;

class BareMarker extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'createMarker', 'didChange');
    this.markerSubs = new _eventKit.CompositeDisposable();
    this.subs = new _eventKit.CompositeDisposable();
    this.markerHolder = new _refHolder.default();
    this.markerHolder.observe(marker => {
      this.props.handleMarker(marker);
    });
    this.decorable = {
      holder: this.markerHolder,
      decorateMethod: 'decorateMarker'
    };
  }

  componentDidMount() {
    this.observeMarkable();
  }

  render() {
    return _react.default.createElement(MarkerContext.Provider, {
      value: this.markerHolder
    }, _react.default.createElement(DecorableContext.Provider, {
      value: this.decorable
    }, this.props.children));
  }

  componentDidUpdate(prevProps) {
    if (prevProps.markableHolder !== this.props.markableHolder) {
      this.observeMarkable();
    }

    if (Object.keys(markerProps).some(key => prevProps[key] !== this.props[key])) {
      this.markerHolder.map(marker => marker.setProperties((0, _helpers.extractProps)(this.props, markerProps)));
    }

    this.updateMarkerPosition();
  }

  componentWillUnmount() {
    this.subs.dispose();
  }

  observeMarkable() {
    this.subs.dispose();
    this.subs = new _eventKit.CompositeDisposable();
    this.subs.add(this.props.markableHolder.observe(this.createMarker));
  }

  createMarker() {
    this.markerSubs.dispose();
    this.markerSubs = new _eventKit.CompositeDisposable();
    this.subs.add(this.markerSubs);
    const options = (0, _helpers.extractProps)(this.props, markerProps);
    this.props.markableHolder.map(markable => {
      let marker;

      if (this.props.id !== undefined) {
        marker = markable.getMarker(this.props.id);

        if (!marker) {
          throw new Error(`Invalid marker ID: ${this.props.id}`);
        }

        marker.setProperties(options);
      } else {
        marker = markable.markBufferRange(this.props.bufferRange, options);
        this.markerSubs.add(new _eventKit.Disposable(() => marker.destroy()));
      }

      this.markerSubs.add(marker.onDidChange(this.didChange));
      this.markerHolder.setter(marker);
      this.props.handleID(marker.id);
      return null;
    });
  }

  updateMarkerPosition() {
    this.markerHolder.map(marker => marker.setBufferRange(this.props.bufferRange));
  }

  didChange(event) {
    const reversed = this.markerHolder.map(marker => marker.isReversed()).getOr(false);
    const oldBufferStartPosition = reversed ? event.oldHeadBufferPosition : event.oldTailBufferPosition;
    const oldBufferEndPosition = reversed ? event.oldTailBufferPosition : event.oldHeadBufferPosition;
    const newBufferStartPosition = reversed ? event.newHeadBufferPosition : event.newTailBufferPosition;
    const newBufferEndPosition = reversed ? event.newTailBufferPosition : event.newHeadBufferPosition;
    this.props.onDidChange(_objectSpread2({
      oldRange: new Range(oldBufferStartPosition, oldBufferEndPosition),
      newRange: new Range(newBufferStartPosition, newBufferEndPosition)
    }, event));
  }

}

_defineProperty(BareMarker, "propTypes", _objectSpread2({}, markerProps, {
  id: _propTypes.default.number,
  bufferRange: _propTypes2.RangePropType,
  markableHolder: _propTypes2.RefHolderPropType,
  children: _propTypes.default.node,
  onDidChange: _propTypes.default.func,
  handleID: _propTypes.default.func,
  handleMarker: _propTypes.default.func
}));

_defineProperty(BareMarker, "defaultProps", {
  onDidChange: () => {},
  handleID: () => {},
  handleMarker: () => {}
});

class Marker extends _react.default.Component {
  constructor(props) {
    super(props);
    this.state = {
      markableHolder: _refHolder.default.on(props.layer || props.editor)
    };
  }

  static getDerivedStateFromProps(props, state) {
    const markable = props.layer || props.editor;

    if (state.markableHolder.map(m => m === markable).getOr(markable === undefined)) {
      return {};
    }

    return {
      markableHolder: _refHolder.default.on(markable)
    };
  }

  render() {
    if (!this.state.markableHolder.isEmpty()) {
      return _react.default.createElement(BareMarker, _extends({}, this.props, {
        markableHolder: this.state.markableHolder
      }));
    }

    return _react.default.createElement(_markerLayer.MarkerLayerContext.Consumer, null, layerHolder => {
      if (layerHolder) {
        return _react.default.createElement(BareMarker, _extends({}, this.props, {
          markableHolder: layerHolder
        }));
      } else {
        return _react.default.createElement(_atomTextEditor.TextEditorContext.Consumer, null, editorHolder => _react.default.createElement(BareMarker, _extends({}, this.props, {
          markableHolder: editorHolder
        })));
      }
    });
  }

}

exports.default = Marker;

_defineProperty(Marker, "propTypes", {
  editor: MarkablePropType,
  layer: MarkablePropType
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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