"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _underscorePlus = require("underscore-plus");

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Keystroke extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'didChangeTarget');
    this.sub = new _eventKit.Disposable();
    this.state = {
      keybinding: null
    };
  }

  componentDidMount() {
    this.observeTarget();
  }

  componentDidUpdate(prevProps, prevState) {
    if (this.props.refTarget !== prevProps.refTarget) {
      this.observeTarget();
    } else if (this.props.command !== prevProps.command) {
      this.didChangeTarget(this.props.refTarget.getOr(null));
    }
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

  render() {
    if (!this.state.keybinding) {
      return null;
    }

    return _react.default.createElement("span", {
      className: "keystroke"
    }, (0, _underscorePlus.humanizeKeystroke)(this.state.keybinding.keystrokes));
  }

  observeTarget() {
    this.sub.dispose();

    if (this.props.refTarget) {
      this.sub = this.props.refTarget.observe(this.didChangeTarget);
    } else {
      this.didChangeTarget(null);
    }
  }

  didChangeTarget(target) {
    const [keybinding] = this.props.keymaps.findKeyBindings({
      command: this.props.command,
      target
    });
    this.setState({
      keybinding
    });
  }

}

exports.default = Keystroke;

_defineProperty(Keystroke, "propTypes", {
  keymaps: _propTypes.default.shape({
    findKeyBindings: _propTypes.default.func.isRequired
  }).isRequired,
  command: _propTypes.default.string.isRequired,
  refTarget: _propTypes2.RefHolderPropType
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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