/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import flash.minechess.client.gui.widget.SquareWidget;
import flash.minechess.main.Main;
import flash.minechess.network.PacketDispatcher;
import flash.minechess.network.receive_server.PacketUpdateMatch;
import flash.minechess.util.Match;
import flash.minechess.util.chess.Board;
import flash.minechess.util.chess.BoardRepresentation;
import flash.minechess.util.chess.Coord;
import flash.minechess.util.chess.Move;
import flash.minechess.util.chess.MoveGenerator;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BoardScreen
extends Screen {
    public static int whiteColor = -1;
    public static int blackColor = -16777216;
    public static int highlightedColor = -3190;
    public static final int squareSize = 20;
    public boolean isWhitePlayer;
    private Match match;
    public Board board;
    public MoveGenerator moveGenerator;
    public Coord selectedSquare;
    public SquareWidget[] squares = new SquareWidget[64];

    public BoardScreen(Match match) {
        super((ITextComponent)new TranslationTextComponent(Main.getScreenName("board")));
        this.match = match;
        this.board = match.getBoard();
        if (this.board.lastMadeMove != null) {
            this.highlightMove(this.board.lastMadeMove);
        }
        this.moveGenerator = new MoveGenerator();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(this.field_230708_k_ / 2 - 80), (double)(this.field_230709_l_ / 2 - 80), 0.0);
        matrixStack.func_227861_a_(10.0, -12.0, 0.0);
        for (int file = 0; file < 8; ++file) {
            int cFile = this.isWhitePlayer ? file : 7 - file;
            BoardScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)String.valueOf("abcdefgh".charAt(cFile)), (int)(20 * file), (int)0, (int)whiteColor);
        }
        matrixStack.func_227861_a_(-22.0, 18.0, 0.0);
        for (int rank = 7; rank >= 0; --rank) {
            int cRank = this.isWhitePlayer ? 8 - rank : rank + 1;
            BoardScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)String.valueOf(cRank), (int)0, (int)(20 * rank), (int)whiteColor);
        }
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(this.field_230708_k_ / 2), (double)(this.field_230709_l_ / 2 - 80 - 30), 0.0);
        BoardScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent(Main.getScreenName("result." + this.match.getGameState().name().toLowerCase())), (int)0, (int)0, (int)whiteColor);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(this.field_230708_k_ / 2 + 80 + 8), (double)(this.field_230709_l_ / 2), 0.0);
        String turn = this.board.whiteToMove && this.isWhitePlayer || !this.board.whiteToMove && !this.isWhitePlayer ? "self" : "opponent";
        BoardScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent(Main.getScreenName("turn." + turn)), (int)0, (int)0, (int)whiteColor);
        matrixStack.func_227865_b_();
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void func_231160_c_() {
        if (this.match != null) {
            this.isWhitePlayer = this.field_230706_i_.field_71439_g.func_110124_au().equals(this.match.getWhitePlayer());
            int x = this.field_230708_k_ / 2 - 80;
            int y = this.field_230709_l_ / 2 - 80;
            for (int squareIndex = 0; squareIndex < 64; ++squareIndex) {
                int file = this.isWhitePlayer ? 7 - BoardRepresentation.fileIndex(squareIndex) : BoardRepresentation.fileIndex(squareIndex);
                int rank = this.isWhitePlayer ? 7 - BoardRepresentation.rankIndex(squareIndex) : BoardRepresentation.rankIndex(squareIndex);
                boolean lightSquare = BoardRepresentation.lightSquare(file, rank);
                this.squares[squareIndex] = (SquareWidget)this.func_230480_a_((Widget)new SquareWidget(this, x + file * 20, y + rank * 20, lightSquare, file, rank));
                this.squares[squareIndex].setPiece(this.board.square[squareIndex]);
            }
        }
    }

    public void func_231023_e_() {
    }

    public void highlightLegalMoves(Coord fromSquare) {
        List<Move> moves = this.moveGenerator.generateMoves(this.board);
        for (int i = 0; i < moves.size(); ++i) {
            int startSquare;
            Move move = moves.get(i);
            int n = startSquare = this.isWhitePlayer ? 63 - move.getStartSquare() : move.getStartSquare();
            if (startSquare != BoardRepresentation.indexFromCoord(fromSquare)) continue;
            int targetSquare = this.isWhitePlayer ? 63 - move.getTargetSquare() : move.getTargetSquare();
            Coord coord = BoardRepresentation.coordFromIndex(targetSquare);
            this.setSquareColor(coord, true);
        }
    }

    private void setSquareColor(Coord coord, boolean highlighted) {
        int squareIndex = this.indexFromCoord(coord);
        this.squares[squareIndex].setHighlighted(highlighted);
    }

    private void resetSquareColors() {
        this.resetSquareColors(true);
    }

    private void resetSquareColors(boolean highlight) {
        for (int rank = 0; rank < 8; ++rank) {
            for (int file = 0; file < 8; ++file) {
                this.setSquareColor(new Coord(file, rank), false);
            }
        }
    }

    public void selectSquare(Coord coord) {
        this.selectedSquare = coord;
        this.setSquareColor(coord, true);
    }

    public void deselectSquare() {
        this.selectedSquare = null;
        this.resetSquareColors();
    }

    private void highlightMove(Move move) {
        int startSquare = this.isWhitePlayer ? 63 - move.getStartSquare() : move.getStartSquare();
        int targetSquare = this.isWhitePlayer ? 63 - move.getTargetSquare() : move.getTargetSquare();
        this.setSquareColor(BoardRepresentation.coordFromIndex(startSquare), true);
        this.setSquareColor(BoardRepresentation.coordFromIndex(targetSquare), true);
    }

    private void updatePosition() {
        for (int rank = 0; rank < 8; ++rank) {
            for (int file = 0; file < 8; ++file) {
                Coord coord = new Coord(file, rank);
                int squareIndex = this.indexFromCoord(coord);
                int piece = this.board.square[squareIndex];
                this.squares[squareIndex].setPiece(piece);
            }
        }
    }

    public void onMoveMade(Board board, Move move) {
        this.board = board;
        this.updatePosition();
        this.resetSquareColors();
        this.highlightMove(move);
    }

    private int indexFromCoord(int file, int rank) {
        int index = BoardRepresentation.indexFromCoord(file, rank);
        return this.isWhitePlayer ? 63 - index : index;
    }

    private int indexFromCoord(Coord coord) {
        return this.indexFromCoord(coord.fileIndex, coord.rankIndex);
    }

    public void tryMakeMove(Coord targetSquare) {
        int startIndex = this.indexFromCoord(this.selectedSquare);
        int targetIndex = this.indexFromCoord(targetSquare);
        boolean moveIsLegal = false;
        Move chosenMove = null;
        List<Move> legalMoves = this.moveGenerator.generateMoves(this.board);
        for (int i = 0; i < legalMoves.size(); ++i) {
            Move legalMove = legalMoves.get(i);
            if (legalMove.getStartSquare() != startIndex || legalMove.getTargetSquare() != targetIndex) continue;
            moveIsLegal = true;
            chosenMove = legalMove;
            break;
        }
        if (moveIsLegal) {
            this.choseMove(chosenMove);
        } else {
            this.cancelPieceSelection();
        }
    }

    private void choseMove(Move move) {
        this.deselectSquare();
        PacketDispatcher.sendToServer(new PacketUpdateMatch(this.match.getWhitePlayer(), this.match.getBlackPlayer(), move));
    }

    private void cancelPieceSelection() {
        if (this.selectedSquare != null) {
            this.deselectSquare();
        }
    }
}

