/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import flash.minechess.util.ScreenHelper;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColorPickerWidget
extends Button {
    private int hueColor;
    private int selectedColor;
    private float markerPosX;
    private float markerPosY;

    public ColorPickerWidget(int x, int y, int width, int height) {
        super(x, y, width, height, StringTextComponent.field_240750_d_, press -> {});
        this.selectedColor = this.hueColor = -65536;
        this.markerPosX = width;
        this.markerPosY = 0.0f;
    }

    public int getHueColor() {
        return this.hueColor;
    }

    public void setHueColor(int hueColor) {
        this.hueColor = hueColor;
    }

    public int getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(int selectedColor) {
        this.selectedColor = selectedColor;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ColorPickerWidget.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ - 1), (int)(this.field_230691_m_ - 1), (int)(this.field_230690_l_ + this.field_230688_j_ + 1), (int)(this.field_230691_m_ + this.field_230689_k_ + 1), (int)-16777216);
        ScreenHelper.fillGradient(matrixStack, this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, this.hueColor);
        this.renderMarker(matrixStack);
    }

    private void renderMarker(MatrixStack matrixStack) {
        int markerLineLength = 2;
        float hX = (float)this.field_230690_l_ + this.markerPosX - (float)(markerLineLength / 2);
        float hY = (float)this.field_230691_m_ + this.markerPosY - (float)(markerLineLength / 2);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)hX - (double)markerLineLength / 4.0, (double)hY - (double)markerLineLength / 4.0, 0.0);
        this.func_238465_a_(matrixStack, 0, markerLineLength, -1, -16777216);
        this.func_238465_a_(matrixStack, 0, markerLineLength, markerLineLength + 1, -16777216);
        this.func_238473_b_(matrixStack, -1, -1, markerLineLength + 1, -16777216);
        this.func_238473_b_(matrixStack, markerLineLength + 1, -1, markerLineLength + 1, -16777216);
        matrixStack.func_227865_b_();
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        this.getColor(mouseX, mouseY);
    }

    protected void func_230983_a_(double mouseX, double mouseY, double dragX, double dragY) {
        this.getColor(mouseX, mouseY);
    }

    public void getColorAtMarker() {
        this.getColor((float)this.field_230690_l_ + this.markerPosX, (float)this.field_230691_m_ + this.markerPosY);
    }

    private void getColor(double mouseX, double mouseY) {
        double mX = mouseX;
        double mY = mouseY;
        if (mX < (double)this.field_230690_l_) {
            mX = this.field_230690_l_;
        } else if (mX > (double)(this.field_230690_l_ + this.field_230688_j_)) {
            mX = this.field_230690_l_ + this.field_230688_j_;
        }
        if (mY < (double)this.field_230691_m_) {
            mY = this.field_230691_m_;
        } else if (mY > (double)(this.field_230691_m_ + this.field_230689_k_)) {
            mY = this.field_230691_m_ + this.field_230689_k_;
        }
        float colorX = (float)((mX - (double)this.field_230690_l_) / (double)this.field_230688_j_);
        float colorY = (float)((mY - (double)this.field_230691_m_) / (double)this.field_230689_k_);
        int whiteness = (int)(255.0f * (1.0f - colorX));
        int blackness = (int)(255.0f * colorY);
        int newColor = ScreenHelper.colorLightness(this.hueColor, whiteness);
        this.selectedColor = newColor = ScreenHelper.colorLightness(newColor, -blackness);
        this.markerPosX = (float)this.field_230688_j_ * colorX;
        this.markerPosY = (float)this.field_230689_k_ * colorY;
    }
}

