/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HueSliderWidget
extends Button {
    public static int[] colors = new int[]{-65536, -256, -16711936, -16711681, -16776961, -65281, -65536};
    private int hueColor = -65536;
    private float markerPosY = 0.0f;

    public HueSliderWidget(int x, int y, int width, int height) {
        super(x, y, width, height, StringTextComponent.field_240750_d_, press -> {});
    }

    public int getHueColor() {
        return this.hueColor;
    }

    public void setHueColor(int hueColor) {
        this.hueColor = hueColor;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        HueSliderWidget.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ - 1), (int)(this.field_230691_m_ - 1), (int)(this.field_230690_l_ + this.field_230688_j_ + 1), (int)(this.field_230691_m_ + this.field_230689_k_ + 1), (int)-16777216);
        int sectionHeight = this.field_230689_k_ / 6;
        for (int i = 0; i < 6; ++i) {
            this.func_238468_a_(matrixStack, this.field_230690_l_, this.field_230691_m_ + sectionHeight * i, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + sectionHeight * (i + 1), colors[i], colors[i + 1]);
        }
        this.renderMarker(matrixStack);
    }

    private void renderMarker(MatrixStack matrixStack) {
        float hY = (float)this.field_230691_m_ + this.markerPosY;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, (double)hY - 0.5, 0.0);
        this.func_238465_a_(matrixStack, this.field_230690_l_, this.field_230690_l_ + this.field_230688_j_, 0, -16777216);
        matrixStack.func_227865_b_();
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        this.getHue(mouseY);
    }

    protected void func_230983_a_(double mouseX, double mouseY, double dragX, double dragY) {
        this.getHue(mouseY);
    }

    private void getHue(double mouseY) {
        double mY = mouseY;
        if (mouseY < (double)this.field_230691_m_) {
            mY = this.field_230691_m_;
        } else if (mouseY > (double)(this.field_230691_m_ + this.field_230689_k_)) {
            mY = this.field_230691_m_ + this.field_230689_k_;
        }
        float colorY = (float)((mY - (double)this.field_230691_m_) / (double)this.field_230689_k_ * 6.0);
        int hueIndex = (int)Math.floor(colorY);
        float hue = colorY - (float)hueIndex;
        int color = colors[hueIndex];
        int color2 = -65536;
        if (hueIndex + 1 < 7) {
            color2 = colors[hueIndex + 1];
        }
        int r1 = (color & 0xFF0000) >> 16;
        int g1 = (color & 0xFF00) >> 8;
        int b1 = color & 0xFF;
        int r2 = (color2 & 0xFF0000) >> 16;
        int g2 = (color2 & 0xFF00) >> 8;
        int b2 = color2 & 0xFF;
        if (hueIndex % 2 != 0) {
            hue = 1.0f - hue;
        }
        if (r1 != r2) {
            r1 = (int)(255.0f * hue);
        }
        if (g1 != g2) {
            g1 = (int)(255.0f * hue);
        }
        if (b1 != b2) {
            b1 = (int)(255.0f * hue);
        }
        this.hueColor = 0xFF000000 | r1 << 16 | g1 << 8 | b1;
        this.markerPosY = (float)mY - (float)this.field_230691_m_;
    }
}

