/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.util.chess;

import flash.minechess.util.chess.Coord;

public class BoardRepresentation {
    public static final String fileNames = "abcdefgh";
    public static final String rankNames = "12345678";
    public static final int a1 = 0;
    public static final int b1 = 1;
    public static final int c1 = 2;
    public static final int d1 = 3;
    public static final int e1 = 4;
    public static final int f1 = 5;
    public static final int g1 = 6;
    public static final int h1 = 7;
    public static final int a8 = 56;
    public static final int b8 = 57;
    public static final int c8 = 58;
    public static final int d8 = 59;
    public static final int e8 = 60;
    public static final int f8 = 61;
    public static final int g8 = 62;
    public static final int h8 = 63;

    public static int rankIndex(int squareIndex) {
        return squareIndex >> 3;
    }

    public static int fileIndex(int squareIndex) {
        return squareIndex & 7;
    }

    public static int indexFromCoord(int fileIndex, int rankIndex) {
        return rankIndex * 8 + fileIndex;
    }

    public static int indexFromCoord(Coord coord) {
        return BoardRepresentation.indexFromCoord(coord.fileIndex, coord.rankIndex);
    }

    public static Coord coordFromIndex(int squareIndex) {
        return new Coord(BoardRepresentation.fileIndex(squareIndex), BoardRepresentation.rankIndex(squareIndex));
    }

    public static boolean lightSquare(int fileIndex, int rankIndex) {
        return (fileIndex + rankIndex) % 2 == 0;
    }

    public static String squareNameFromCoordinate(int fileIndex, int rankIndex) {
        return String.valueOf(fileNames.charAt(fileIndex)) + "" + (rankIndex + 1);
    }

    public static String squareNameFromIndex(int squareIndex) {
        return BoardRepresentation.squareNameFromCoordinate(BoardRepresentation.coordFromIndex(squareIndex));
    }

    public static String squareNameFromCoordinate(Coord coord) {
        return BoardRepresentation.squareNameFromCoordinate(coord.fileIndex, coord.rankIndex);
    }
}

