/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.util.chess;

import flash.minechess.main.Main;
import flash.minechess.util.chess.Board;
import flash.minechess.util.chess.BoardRepresentation;
import flash.minechess.util.chess.Piece;
import java.util.HashMap;

public class FenUtility {
    static HashMap<Character, Integer> pieceTypeFromSymbol = new HashMap(){
        {
            this.put(Character.valueOf('k'), 1);
            this.put(Character.valueOf('p'), 2);
            this.put(Character.valueOf('n'), 3);
            this.put(Character.valueOf('b'), 5);
            this.put(Character.valueOf('r'), 6);
            this.put(Character.valueOf('q'), 7);
        }
    };
    public static final String startFen = "rnbkqbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBKQBNR w KQkq - 0 1";

    public static LoadedPositionInfo positionFromFen(String fen) {
        String enPassantFileName;
        LoadedPositionInfo loadedPositionInfo = new LoadedPositionInfo();
        String[] sections = fen.split(" ");
        int file = 0;
        int rank = 7;
        for (char symbol : sections[0].toCharArray()) {
            if (symbol == '/') {
                file = 0;
                --rank;
                continue;
            }
            if (Character.isDigit(symbol)) {
                file += Character.getNumericValue(symbol);
                continue;
            }
            int pieceColour = Character.isUpperCase(symbol) ? 8 : 16;
            int pieceType = pieceTypeFromSymbol.get(Character.valueOf(Character.toLowerCase(symbol)));
            int squareIndex = BoardRepresentation.indexFromCoord(file, rank);
            loadedPositionInfo.squares[squareIndex] = pieceType | pieceColour;
            ++file;
        }
        loadedPositionInfo.whiteToMove = sections[1].equals("w");
        String castlingRights = sections.length > 2 ? sections[2] : "KQkq";
        loadedPositionInfo.whiteCastleKingside = castlingRights.contains("K");
        loadedPositionInfo.whiteCastleQueenside = castlingRights.contains("Q");
        loadedPositionInfo.blackCastleKingside = castlingRights.contains("k");
        loadedPositionInfo.blackCastleQueenside = castlingRights.contains("q");
        if (sections.length > 3 && "abcdefgh".contains(enPassantFileName = String.valueOf(sections[3].charAt(0)))) {
            loadedPositionInfo.epFile = "abcdefgh".indexOf(enPassantFileName) + 1;
        }
        if (sections.length > 4) {
            try {
                loadedPositionInfo.plyCount = Integer.parseInt(sections[4]);
            }
            catch (Exception e) {
                Main.LOGGER.debug(e.getMessage());
            }
        }
        return loadedPositionInfo;
    }

    public static String currentFen(Board board) {
        String fen = "";
        for (int rank = 7; rank >= 0; --rank) {
            int numEmptyFiles = 0;
            for (int file = 0; file < 8; ++file) {
                int i = rank * 8 + file;
                int piece = board.square[i];
                if (piece != 0) {
                    if (numEmptyFiles != 0) {
                        fen = fen + numEmptyFiles;
                        numEmptyFiles = 0;
                    }
                    boolean isBlack = Piece.isColour(piece, 16);
                    int pieceType = Piece.pieceType(piece);
                    char pieceChar = ' ';
                    switch (pieceType) {
                        case 6: {
                            pieceChar = 'R';
                            break;
                        }
                        case 3: {
                            pieceChar = 'N';
                            break;
                        }
                        case 5: {
                            pieceChar = 'B';
                            break;
                        }
                        case 7: {
                            pieceChar = 'Q';
                            break;
                        }
                        case 1: {
                            pieceChar = 'K';
                            break;
                        }
                        case 2: {
                            pieceChar = 'P';
                        }
                    }
                    fen = fen + (isBlack ? String.valueOf(pieceChar).toLowerCase() : String.valueOf(pieceChar));
                    continue;
                }
                ++numEmptyFiles;
            }
            if (numEmptyFiles != 0) {
                fen = fen + numEmptyFiles;
            }
            if (rank == 0) continue;
            fen = fen + '/';
        }
        fen = fen + ' ';
        fen = fen + (board.whiteToMove ? (char)'w' : 'b');
        boolean whiteKingside = (board.currentGameState & 1L) == 1L;
        boolean whiteQueenside = (board.currentGameState >> 1 & 1L) == 1L;
        boolean blackKingside = (board.currentGameState >> 2 & 1L) == 1L;
        boolean blackQueenside = (board.currentGameState >> 3 & 1L) == 1L;
        fen = fen + ' ';
        fen = fen + (whiteKingside ? "K" : "");
        fen = fen + (whiteQueenside ? "Q" : "");
        fen = fen + (blackKingside ? "k" : "");
        fen = fen + (blackQueenside ? "q" : "");
        fen = fen + ((board.currentGameState & 0xFL) == 0L ? "-" : "");
        fen = fen + ' ';
        int epFile = (int)(board.currentGameState >> 4) & 0xF;
        if (epFile == 0) {
            fen = fen + '-';
        } else {
            String fileName = String.valueOf("abcdefgh".charAt(epFile - 1));
            int epRank = board.whiteToMove ? 6 : 3;
            fen = fen + fileName + epRank;
        }
        fen = fen + ' ';
        fen = fen + board.fiftyMoveCounter;
        fen = fen + ' ';
        fen = fen + (board.plyCount / 2 + 1);
        return fen;
    }

    public static class LoadedPositionInfo {
        public int[] squares = new int[64];
        public boolean whiteCastleKingside;
        public boolean whiteCastleQueenside;
        public boolean blackCastleKingside;
        public boolean blackCastleQueenside;
        public int epFile;
        public boolean whiteToMove;
        public int plyCount;
    }
}

