/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.util.chess;

public class PieceList {
    public int[] occupiedSquares;
    int[] map;
    int numPieces;

    public PieceList() {
        this(16);
    }

    public PieceList(int maxPieceCount) {
        this.occupiedSquares = new int[maxPieceCount];
        this.map = new int[64];
        this.numPieces = 0;
    }

    public int getCount() {
        return this.numPieces;
    }

    public void addPieceAtSquare(int square) {
        this.occupiedSquares[this.numPieces] = square;
        this.map[square] = this.numPieces++;
    }

    public void removePieceAtSquare(int square) {
        int pieceIndex = this.map[square];
        this.occupiedSquares[pieceIndex] = this.occupiedSquares[this.numPieces - 1];
        this.map[this.occupiedSquares[pieceIndex]] = pieceIndex;
        --this.numPieces;
    }

    public void movePiece(int startSquare, int targetSquare) {
        int pieceIndex = this.map[startSquare];
        this.occupiedSquares[pieceIndex] = targetSquare;
        this.map[targetSquare] = pieceIndex;
    }

    public int getOccupiedSquare(int index) {
        return this.occupiedSquares[index];
    }
}

