/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.world.generator.multichunk;

import java.util.Random;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.base.world.generator.Generator;

public abstract class MultiChunkFeatureGenerator
extends Generator {
    private final long seedXor;

    public MultiChunkFeatureGenerator(DimensionConfig dimConfig, BooleanSupplier condition, long seedXor) {
        super(dimConfig, condition);
        this.seedXor = seedXor;
    }

    @Override
    public final void generateChunk(WorldGenRegion world, ChunkGenerator generator, Random rand, BlockPos pos) {
        int radius = this.getFeatureRadius();
        if (radius <= 0) {
            return;
        }
        int chunkRadius = (int)Math.ceil((double)radius / 16.0);
        long worldSeed = world.func_72905_C();
        Random worldRandom = new Random(worldSeed);
        long xSeed = worldRandom.nextLong();
        long zSeed = worldRandom.nextLong();
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed ^ this.seedXor;
        Random ourRandom = new Random(chunkSeed);
        for (int x = chunkX - chunkRadius; x <= chunkX + chunkRadius; ++x) {
            for (int z = chunkZ - chunkRadius; z <= chunkZ + chunkRadius; ++z) {
                BlockPos[] sources;
                chunkSeed = xSeed * (long)x + zSeed * (long)z ^ worldSeed ^ this.seedXor;
                Random chunkRandom = new Random(chunkSeed);
                BlockPos chunkCorner = new BlockPos(x << 4, 0, z << 4);
                for (BlockPos source : sources = this.getSourcesInChunk(world, chunkRandom, generator, chunkCorner)) {
                    if (source == null || !this.isSourceValid(world, generator, source)) continue;
                    this.generateChunkPart(source, generator, ourRandom, pos, world);
                }
            }
        }
    }

    public boolean isSourceValid(WorldGenRegion world, ChunkGenerator generator, BlockPos pos) {
        return true;
    }

    public abstract int getFeatureRadius();

    public abstract void generateChunkPart(BlockPos var1, ChunkGenerator var2, Random var3, BlockPos var4, WorldGenRegion var5);

    public abstract BlockPos[] getSourcesInChunk(WorldGenRegion var1, Random var2, ChunkGenerator var3, BlockPos var4);

    public void forEachChunkBlock(BlockPos chunkCorner, int minY, int maxY, Consumer<BlockPos> func) {
        minY = Math.max(1, minY);
        maxY = Math.min(255, maxY);
        BlockPos.Mutable mutable = new BlockPos.Mutable(chunkCorner.func_177958_n(), chunkCorner.func_177956_o(), chunkCorner.func_177952_p());
        for (int x = 0; x < 16; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = 0; z < 16; ++z) {
                    mutable.func_181079_c(chunkCorner.func_177958_n() + x, chunkCorner.func_177956_o() + y, chunkCorner.func_177952_p() + z);
                    func.accept((BlockPos)mutable);
                }
            }
        }
    }

    public boolean isInsideChunk(BlockPos pos, int chunkX, int chunkZ) {
        int x = chunkX * 16;
        int z = chunkZ * 16;
        return pos.func_177958_n() > x && pos.func_177952_p() > z && pos.func_177958_n() < x + 16 && pos.func_177952_p() < z + 16;
    }
}

