/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.automation.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.automation.tile.WeatherSensorTileEntity;

public class WeatherSensorBlock
extends QuarkBlock {
    public static final IntegerProperty POWER = IntegerProperty.func_177719_a((String)"power", (int)0, (int)2);
    public static final BooleanProperty INVERTED = BlockStateProperties.field_208188_o;
    public static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);

    public WeatherSensorBlock(String regname, QuarkModule module, ItemGroup creativeTab, AbstractBlock.Properties properties) {
        super(regname, module, creativeTab, properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(0))).func_206870_a((Property)INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWER, INVERTED});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new WeatherSensorTileEntity();
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selection) {
        return SHAPE;
    }

    public boolean func_220074_n(BlockState p_220074_1_) {
        return true;
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return (int)((float)((Integer)state.func_177229_b((Property)POWER)).intValue() * 7.5f);
    }

    public static void updatePower(BlockState state, World world, BlockPos pos) {
        if (world.func_230315_m_().func_218272_d()) {
            boolean inverted = (Boolean)state.func_177229_b((Property)INVERTED);
            if (world.func_72911_I()) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(inverted ? 0 : 2)));
            } else if (world.func_72896_J() && world.func_226691_t_(pos).func_201851_b() != Biome.RainType.NONE) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(1)));
            } else {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(inverted ? 2 : 0)));
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (player.func_175142_cm()) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            BlockState inverted = (BlockState)state.func_235896_a_((Property)INVERTED);
            world.func_180501_a(pos, inverted, 4);
            WeatherSensorBlock.updatePower(inverted, world, pos);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, ray);
    }
}

