/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.building.block.RopeBlock;

@LoadModule(category=ModuleCategory.BUILDING)
public class RopeModule
extends QuarkModule {
    public static Block rope;
    @Config(description="Set to true to allow ropes to move Tile Entities even if Pistons Push TEs is disabled.\nNote that ropes will still use the same blacklist.")
    public static boolean forceEnableMoveTileEntities;
    @Config
    public static boolean enableDispenserBehavior;

    @Override
    public void construct() {
        rope = new RopeBlock("rope", this, ItemGroup.field_78031_c, AbstractBlock.Properties.func_200949_a((Material)Material.field_151580_n, (MaterialColor)MaterialColor.field_151650_B).func_200943_b(0.5f).func_200947_a(SoundType.field_185854_g));
    }

    @Override
    public void configChanged() {
        if (enableDispenserBehavior) {
            DispenserBlock.field_149943_a.put(rope.func_199767_j(), new BehaviourRope());
        } else {
            DispenserBlock.field_149943_a.remove(rope.func_199767_j());
        }
    }

    static {
        forceEnableMoveTileEntities = false;
        enableDispenserBehavior = true;
    }

    public static class BehaviourRope
    extends OptionalDispenseBehavior {
        @Nonnull
        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            Direction facing = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            BlockPos pos = source.func_180699_d().func_177972_a(facing);
            ServerWorld world = source.func_197524_h();
            this.field_218407_b = false;
            BlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() == rope) {
                if (((RopeBlock)rope).pullDown((World)world, pos)) {
                    this.field_218407_b = true;
                    stack.func_190918_g(1);
                    return stack;
                }
            } else if (world.func_175623_d(pos) && rope.func_176223_P().func_196955_c((IWorldReader)world, pos)) {
                SoundType soundtype = rope.getSoundType(state, (IWorldReader)world, pos, null);
                world.func_175656_a(pos, rope.func_176223_P());
                world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                this.field_218407_b = true;
                stack.func_190918_g(1);
                return stack;
            }
            return stack;
        }
    }
}

