/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.gen.underground;

import it.unimi.dsi.fastutil.ints.Int2ByteArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ByteMap;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.WorldGenRegion;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.content.world.block.CaveCrystalBlock;
import vazkii.quark.content.world.block.CaveCrystalClusterBlock;
import vazkii.quark.content.world.gen.UndergroundBiomeGenerator;
import vazkii.quark.content.world.gen.underground.BasicUndergroundBiome;
import vazkii.quark.content.world.module.underground.CaveCrystalUndergroundBiomeModule;

public class CaveCrystalUndergroundBiome
extends BasicUndergroundBiome {
    private static final Int2ByteMap CRYSTAL_DATA = new Int2ByteArrayMap();

    public CaveCrystalUndergroundBiome() {
        super(Blocks.field_150350_a.func_176223_P(), Blocks.field_150348_b.func_176223_P(), Blocks.field_150348_b.func_176223_P());
    }

    @Override
    public void fillCeiling(UndergroundBiomeGenerator.Context context, BlockPos pos, BlockState state) {
        int floorIdx;
        byte raw = CaveCrystalUndergroundBiome.calculateRawColorData(context.source);
        int ceilIdx = raw >> 4 & 0xF;
        if (ceilIdx >= (floorIdx = raw & 0xF)) {
            ++ceilIdx;
        }
        if (context.random.nextDouble() < CaveCrystalUndergroundBiomeModule.crystalChance) {
            CaveCrystalUndergroundBiome.makeCrystalIfApt(context, pos, Direction.DOWN, ceilIdx);
        }
    }

    @Override
    public void fillFloor(UndergroundBiomeGenerator.Context context, BlockPos pos, BlockState state) {
        byte raw = CaveCrystalUndergroundBiome.calculateRawColorData(context.source);
        int floorIdx = raw & 0xF;
        if (context.random.nextDouble() < CaveCrystalUndergroundBiomeModule.crystalChance) {
            CaveCrystalUndergroundBiome.makeCrystalIfApt(context, pos, Direction.UP, floorIdx);
        }
    }

    private static void makeCrystalIfApt(UndergroundBiomeGenerator.Context context, BlockPos pos, Direction offset, int color) {
        BlockPos crystalPos = pos.func_177972_a(offset);
        boolean hasHorizontal = false;
        WorldGenRegion world = context.world;
        for (Direction dir : MiscUtil.HORIZONTALS) {
            BlockPos testPos = crystalPos.func_177972_a(dir);
            if (!world.func_180495_p(testPos).func_200132_m()) continue;
            hasHorizontal = true;
            break;
        }
        if (!hasHorizontal) {
            return;
        }
        CaveCrystalUndergroundBiome.makeCrystalAt(context, crystalPos, offset, color, CaveCrystalUndergroundBiomeModule.crystalClusterChance);
        if (context.random.nextDouble() < CaveCrystalUndergroundBiomeModule.doubleCrystalChance && world.func_175623_d(crystalPos = crystalPos.func_177972_a(offset))) {
            CaveCrystalUndergroundBiome.makeCrystalAt(context, crystalPos, offset, color, 0.0);
        }
    }

    private static void makeCrystalAt(UndergroundBiomeGenerator.Context context, BlockPos crystalPos, Direction offset, int color, double clusterChance) {
        CaveCrystalBlock crystal = CaveCrystalUndergroundBiomeModule.crystals.get(color);
        CaveCrystalClusterBlock cluster = crystal.cluster;
        WorldGenRegion world = context.world;
        if (context.random.nextDouble() < clusterChance) {
            world.func_180501_a(crystalPos, (BlockState)cluster.func_176223_P().func_206870_a(CaveCrystalClusterBlock.FACING, (Comparable)offset), 0);
        } else {
            world.func_180501_a(crystalPos, crystal.func_176223_P(), 0);
            for (Direction dir : Direction.values()) {
                BlockPos clusterPos = crystalPos.func_177972_a(dir);
                if (!world.func_175623_d(clusterPos) || !(context.random.nextDouble() < CaveCrystalUndergroundBiomeModule.crystalClusterOnSidesChance)) continue;
                world.func_180501_a(clusterPos, (BlockState)cluster.func_176223_P().func_206870_a(CaveCrystalClusterBlock.FACING, (Comparable)dir), 0);
            }
        }
    }

    private static byte calculateRawColorData(BlockPos source) {
        return CRYSTAL_DATA.computeIfAbsent(source.hashCode(), src -> {
            Random rand = new Random(src);
            return (byte)(rand.nextInt(8) << 4 | rand.nextInt(9));
        });
    }
}

