/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraftforge.common.BiomeDictionary;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.quark.base.world.config.BiomeConfig;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.content.world.config.AirStoneClusterConfig;
import vazkii.quark.content.world.config.BigStoneClusterConfig;
import vazkii.quark.content.world.gen.BigStoneClusterGenerator;
import vazkii.quark.content.world.module.NewStoneTypesModule;

@LoadModule(category=ModuleCategory.WORLD)
public class BigStoneClustersModule
extends QuarkModule {
    @Config
    public static BigStoneClusterConfig granite = new BigStoneClusterConfig(BiomeDictionary.Type.MOUNTAIN);
    @Config
    public static BigStoneClusterConfig diorite = new BigStoneClusterConfig(BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.MUSHROOM);
    @Config
    public static BigStoneClusterConfig andesite = new BigStoneClusterConfig(BiomeDictionary.Type.FOREST);
    @Config
    public static BigStoneClusterConfig marble = new BigStoneClusterConfig(BiomeDictionary.Type.PLAINS);
    @Config
    public static BigStoneClusterConfig limestone = new BigStoneClusterConfig(BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.OCEAN);
    @Config
    public static BigStoneClusterConfig jasper = new BigStoneClusterConfig(BiomeDictionary.Type.MESA, BiomeDictionary.Type.SANDY);
    @Config
    public static BigStoneClusterConfig slate = new BigStoneClusterConfig(BiomeDictionary.Type.SNOWY);
    @Config
    public static BigStoneClusterConfig voidstone = new BigStoneClusterConfig(DimensionConfig.end(false), 19, 6, 20, 0, 40, BiomeConfig.fromBiomeReslocs(false, "minecraft:end_highlands", "minecraft:end_midlands", "minecraft:end_barrens"));
    @Config
    public static BigStoneClusterConfig myalite = new AirStoneClusterConfig(DimensionConfig.end(false), 20, 6, 100, 58, 62, BiomeConfig.fromBiomeReslocs(false, "minecraft:end_highlands")).setVertical(40, 10);
    @Config(description="Blocks that stone clusters can replace. If you want to make it so it only replaces in one dimension,\ndo \"block|dimension\", as we do for netherrack and end stone by default.")
    public static List<String> blocksToReplace = Lists.newArrayList((Object[])new String[]{"minecraft:stone", "minecraft:andesite", "minecraft:diorite", "minecraft:granite", "minecraft:netherrack|minecraft:the_nether", "minecraft:end_stone|minecraft:the_end", "quark:marble", "quark:limestone", "quark:jasper", "quark:slate", "quark:basalt"});
    public static BiPredicate<World, Block> blockReplacePredicate = (w, b) -> false;

    @Override
    public void setup() {
        BooleanSupplier alwaysTrue = () -> true;
        this.add(granite, Blocks.field_196650_c, alwaysTrue);
        this.add(diorite, Blocks.field_196654_e, alwaysTrue);
        this.add(andesite, Blocks.field_196656_g, alwaysTrue);
        this.add(marble, NewStoneTypesModule.marbleBlock, () -> NewStoneTypesModule.enabledWithMarble);
        this.add(limestone, NewStoneTypesModule.limestoneBlock, () -> NewStoneTypesModule.enabledWithLimestone);
        this.add(jasper, NewStoneTypesModule.jasperBlock, () -> NewStoneTypesModule.enabledWithJasper);
        this.add(slate, NewStoneTypesModule.slateBlock, () -> NewStoneTypesModule.enabledWithSlate);
        this.add(voidstone, NewStoneTypesModule.basaltBlock, () -> NewStoneTypesModule.enabledWithVoidstone);
        this.add(myalite, NewStoneTypesModule.myaliteBlock, () -> NewStoneTypesModule.enabledWithMyalite);
        this.conditionalize(Blocks.field_196650_c, () -> !this.enabled || !BigStoneClustersModule.granite.enabled);
        this.conditionalize(Blocks.field_196654_e, () -> !this.enabled || !BigStoneClustersModule.diorite.enabled);
        this.conditionalize(Blocks.field_196656_g, () -> !this.enabled || !BigStoneClustersModule.andesite.enabled);
    }

    private void add(BigStoneClusterConfig config, Block block, BooleanSupplier condition) {
        WorldGenHandler.addGenerator(this, new BigStoneClusterGenerator(config, block.func_176223_P(), condition), GenerationStage.Decoration.UNDERGROUND_DECORATION, 0);
    }

    private void conditionalize(Block block, BooleanSupplier condition) {
        BiPredicate<Feature<? extends IFeatureConfig>, IFeatureConfig> pred = (feature, config) -> {
            if (config instanceof OreFeatureConfig) {
                OreFeatureConfig oconfig = (OreFeatureConfig)config;
                return oconfig.field_202444_d.func_177230_c() == block;
            }
            return false;
        };
        WorldGenHandler.conditionalizeFeatures(GenerationStage.Decoration.UNDERGROUND_ORES, pred, condition);
    }

    @Override
    public void configChanged() {
        blockReplacePredicate = (b, w) -> false;
        Iterator<String> iterator = blocksToReplace.iterator();
        while (iterator.hasNext()) {
            String s;
            String bname = s = iterator.next();
            String dimension = null;
            if (bname.contains("|")) {
                String[] toks = bname.split("\\|");
                bname = toks[0];
                dimension = toks[1];
            }
            String dimFinal = dimension;
            Registry.field_212618_g.func_241873_b(new ResourceLocation(bname)).ifPresent(blockObj -> {
                if (blockObj != Blocks.field_150350_a) {
                    blockReplacePredicate = dimFinal == null ? blockReplacePredicate.or((w, b) -> blockObj == b) : blockReplacePredicate.or((w, b) -> {
                        if (blockObj != b) {
                            return false;
                        }
                        if (w == null) {
                            return false;
                        }
                        return w.func_234923_W_().func_240901_a_().toString().equals(dimFinal);
                    });
                }
            });
        }
    }
}

