/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module;

import com.google.common.collect.Maps;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.function.BooleanSupplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.ToolType;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.base.world.generator.OreGenerator;
import vazkii.quark.content.world.block.MyaliteBlock;
import vazkii.quark.content.world.config.BigStoneClusterConfig;
import vazkii.quark.content.world.config.StoneTypeConfig;
import vazkii.quark.content.world.module.BigStoneClustersModule;

@LoadModule(category=ModuleCategory.WORLD, hasSubscriptions=true)
public class NewStoneTypesModule
extends QuarkModule {
    @Config(flag="marble")
    private static boolean enableMarble = true;
    @Config(flag="limestone")
    private static boolean enableLimestone = true;
    @Config(flag="jasper")
    private static boolean enableJasper = true;
    @Config(flag="slate")
    private static boolean enableSlate = true;
    @Config(flag="basalt")
    private static boolean enableVoidstone = true;
    @Config(flag="myalite")
    private static boolean enableMyalite = true;
    public static boolean enabledWithMarble;
    public static boolean enabledWithLimestone;
    public static boolean enabledWithJasper;
    public static boolean enabledWithSlate;
    public static boolean enabledWithVoidstone;
    public static boolean enabledWithMyalite;
    @Config
    public static StoneTypeConfig marble;
    @Config
    public static StoneTypeConfig limestone;
    @Config
    public static StoneTypeConfig jasper;
    @Config
    public static StoneTypeConfig slate;
    @Config
    public static StoneTypeConfig voidstone;
    @Config
    public static StoneTypeConfig myalite;
    public static Block marbleBlock;
    public static Block limestoneBlock;
    public static Block jasperBlock;
    public static Block slateBlock;
    public static Block basaltBlock;
    public static Block myaliteBlock;
    public static Map<Block, Block> polishedBlocks;
    private Queue<Runnable> defers = new ArrayDeque<Runnable>();

    @Override
    public void construct() {
        marbleBlock = this.makeStone("marble", marble, BigStoneClustersModule.marble, () -> enableMarble, MaterialColor.field_151677_p);
        limestoneBlock = this.makeStone("limestone", limestone, BigStoneClustersModule.limestone, () -> enableLimestone, MaterialColor.field_151665_m);
        jasperBlock = this.makeStone("jasper", jasper, BigStoneClustersModule.jasper, () -> enableJasper, MaterialColor.field_193559_aa);
        slateBlock = this.makeStone("slate", slate, BigStoneClustersModule.slate, () -> enableSlate, MaterialColor.field_151657_g);
        basaltBlock = this.makeStone("basalt", voidstone, BigStoneClustersModule.voidstone, () -> enableVoidstone, MaterialColor.field_151646_E);
        myaliteBlock = this.makeStone("myalite", myalite, BigStoneClustersModule.myalite, () -> enableMyalite, MaterialColor.field_151678_z, MyaliteBlock::new);
    }

    private Block makeStone(String name, StoneTypeConfig config, BigStoneClusterConfig bigConfig, BooleanSupplier enabledCond, MaterialColor color) {
        return this.makeStone(name, config, bigConfig, enabledCond, color, QuarkBlock::new);
    }

    private Block makeStone(String name, StoneTypeConfig config, BigStoneClusterConfig bigConfig, BooleanSupplier enabledCond, MaterialColor color, QuarkBlock.Constructor<QuarkBlock> constr) {
        BooleanSupplier trueEnabledCond = () -> (!ModuleLoader.INSTANCE.isModuleEnabled(BigStoneClustersModule.class) || !bigConfig.enabled) && enabledCond.getAsBoolean();
        AbstractBlock.Properties props = AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)color).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200948_a(1.5f, 6.0f);
        QuarkBlock normal = constr.make(name, this, ItemGroup.field_78030_b, props).setCondition(enabledCond);
        QuarkBlock polished = constr.make("polished_" + name, this, ItemGroup.field_78030_b, props).setCondition(enabledCond);
        polishedBlocks.put((Block)normal, (Block)polished);
        VariantHandler.addSlabStairsWall(normal);
        VariantHandler.addSlabAndStairs(polished);
        this.defers.add(() -> WorldGenHandler.addGenerator(this, new OreGenerator(config.dimensions, config.oregen, normal.func_176223_P(), OreGenerator.ALL_DIMS_STONE_MATCHER, trueEnabledCond), GenerationStage.Decoration.UNDERGROUND_ORES, 1));
        return normal;
    }

    @Override
    public void configChanged() {
        enabledWithMarble = enableMarble && this.enabled;
        enabledWithLimestone = enableLimestone && this.enabled;
        enabledWithJasper = enableJasper && this.enabled;
        enabledWithSlate = enableSlate && this.enabled;
        enabledWithVoidstone = enableVoidstone && this.enabled;
        enabledWithMyalite = enableMyalite && this.enabled;
    }

    @Override
    public void setup() {
        while (!this.defers.isEmpty()) {
            this.defers.poll().run();
        }
    }

    static {
        marble = new StoneTypeConfig();
        limestone = new StoneTypeConfig();
        jasper = new StoneTypeConfig();
        slate = new StoneTypeConfig();
        voidstone = new StoneTypeConfig(DimensionConfig.end(false));
        myalite = new StoneTypeConfig(DimensionConfig.end(false));
        polishedBlocks = Maps.newHashMap();
    }
}

