/*
 * Decompiled with CFR 0.152.
 */
package vazkii.arl.network;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.Pair;

public final class MessageSerializer {
    private static final HashMap<Class<?>, Pair<Reader, Writer>> handlers = new HashMap();
    private static final HashMap<Class<?>, Field[]> fieldCache = new HashMap();

    public static void readObject(Object obj, PacketBuffer buf) {
        try {
            Field[] clFields;
            Class<?> clazz = obj.getClass();
            for (Field f : clFields = MessageSerializer.getClassFields(clazz)) {
                Class<?> type = f.getType();
                if (!MessageSerializer.acceptField(f, type)) continue;
                MessageSerializer.readField(obj, f, type, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at reading message " + obj, e);
        }
    }

    public static void writeObject(Object obj, PacketBuffer buf) {
        try {
            Field[] clFields;
            Class<?> clazz = obj.getClass();
            for (Field f : clFields = MessageSerializer.getClassFields(clazz)) {
                Class<?> type = f.getType();
                if (!MessageSerializer.acceptField(f, type)) continue;
                MessageSerializer.writeField(obj, f, type, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at writing message " + obj, e);
        }
    }

    private static Field[] getClassFields(Class<?> clazz) {
        if (fieldCache.containsKey(clazz)) {
            return fieldCache.get(clazz);
        }
        Field[] fields = clazz.getFields();
        Arrays.sort(fields, Comparator.comparing(Field::getName));
        fieldCache.put(clazz, fields);
        return fields;
    }

    private static void writeField(Object obj, Field f, Class<?> clazz, PacketBuffer buf) throws IllegalArgumentException, IllegalAccessException {
        Pair<Reader, Writer> handler = MessageSerializer.getHandler(clazz);
        ((Writer)handler.getRight()).write(buf, f, f.get(obj));
    }

    private static void readField(Object obj, Field f, Class<?> clazz, PacketBuffer buf) throws IllegalArgumentException, IllegalAccessException {
        Pair<Reader, Writer> handler = MessageSerializer.getHandler(clazz);
        f.set(obj, ((Reader)handler.getLeft()).read(buf, f));
    }

    private static Pair<Reader, Writer> getHandler(Class<?> clazz) {
        Pair<Reader, Writer> pair = handlers.get(clazz);
        if (pair == null) {
            throw new RuntimeException("No R/W handler for  " + clazz);
        }
        return pair;
    }

    private static boolean acceptField(Field f, Class<?> type) {
        int mods = f.getModifiers();
        if (Modifier.isFinal(mods) || Modifier.isStatic(mods) || Modifier.isTransient(mods)) {
            return false;
        }
        return handlers.containsKey(type);
    }

    private static <T> void mapHandler(Class<T> type, Function<PacketBuffer, T> readerLower, BiConsumer<PacketBuffer, T> writerLower) {
        Reader<Object> reader = (buf, field) -> readerLower.apply(buf);
        Writer<Object> writer = (buf, field, t) -> writerLower.accept(buf, t);
        MessageSerializer.mapHandler(type, reader, writer);
    }

    private static <T> void mapHandler(Class<T> type, Reader<T> reader, BiConsumer<PacketBuffer, T> writerLower) {
        Writer<Object> writer = (buf, field, t) -> writerLower.accept(buf, t);
        MessageSerializer.mapHandler(type, reader, writer);
    }

    private static <T> void mapHandler(Class<T> type, Function<PacketBuffer, T> readerLower, Writer<T> writer) {
        Reader<Object> reader = (buf, field) -> readerLower.apply(buf);
        MessageSerializer.mapHandler(type, reader, writer);
    }

    public static <T> void mapHandler(Class<T> type, Reader<T> reader, Writer<T> writer) {
        Class<?> arrayType = Array.newInstance(type, 0).getClass();
        Reader<Object[]> arrayReader = (buf, field) -> {
            int count = buf.readInt();
            Object[] arr = (Object[])Array.newInstance(type, count);
            for (int i = 0; i < count; ++i) {
                arr[i] = reader.read(buf, field);
            }
            return arr;
        };
        Writer<Object[]> arrayWriter = (buf, field, t) -> {
            int count = ((Object[])t).length;
            buf.writeInt(count);
            for (int i = 0; i < count; ++i) {
                writer.write(buf, field, t[i]);
            }
        };
        handlers.put(type, (Pair<Reader, Writer>)Pair.of(reader, writer));
        handlers.put(arrayType, (Pair<Reader, Writer>)Pair.of(arrayReader, arrayWriter));
    }

    private static void writeItemStack(PacketBuffer buf, ItemStack stack) {
        buf.func_150788_a(stack);
    }

    private static String readString(PacketBuffer buf) {
        return buf.func_150789_c(Short.MAX_VALUE);
    }

    private static void writeString(PacketBuffer buf, String string) {
        buf.func_180714_a(string);
    }

    static {
        MessageSerializer.mapHandler(Byte.TYPE, PacketBuffer::readByte, PacketBuffer::writeByte);
        MessageSerializer.mapHandler(Short.TYPE, PacketBuffer::readShort, PacketBuffer::writeShort);
        MessageSerializer.mapHandler(Integer.TYPE, PacketBuffer::readInt, PacketBuffer::writeInt);
        MessageSerializer.mapHandler(Long.TYPE, PacketBuffer::readLong, PacketBuffer::writeLong);
        MessageSerializer.mapHandler(Float.TYPE, PacketBuffer::readFloat, PacketBuffer::writeFloat);
        MessageSerializer.mapHandler(Double.TYPE, PacketBuffer::readDouble, PacketBuffer::writeDouble);
        MessageSerializer.mapHandler(Boolean.TYPE, PacketBuffer::readBoolean, PacketBuffer::writeBoolean);
        MessageSerializer.mapHandler(Character.TYPE, PacketBuffer::readChar, PacketBuffer::writeChar);
        MessageSerializer.mapHandler(BlockPos.class, PacketBuffer::func_179259_c, PacketBuffer::func_179255_a);
        MessageSerializer.mapHandler(ITextComponent.class, PacketBuffer::func_179258_d, PacketBuffer::func_179256_a);
        MessageSerializer.mapHandler(UUID.class, PacketBuffer::func_179253_g, PacketBuffer::func_179252_a);
        MessageSerializer.mapHandler(CompoundNBT.class, PacketBuffer::func_150793_b, PacketBuffer::func_150786_a);
        MessageSerializer.mapHandler(ItemStack.class, PacketBuffer::func_150791_c, MessageSerializer::writeItemStack);
        MessageSerializer.mapHandler(String.class, MessageSerializer::readString, MessageSerializer::writeString);
        MessageSerializer.mapHandler(ResourceLocation.class, PacketBuffer::func_192575_l, PacketBuffer::func_192572_a);
        MessageSerializer.mapHandler(Date.class, PacketBuffer::func_192573_m, PacketBuffer::func_192574_a);
        MessageSerializer.mapHandler(BlockRayTraceResult.class, PacketBuffer::func_218669_q, PacketBuffer::func_218668_a);
    }

    public static interface Writer<T> {
        public void write(PacketBuffer var1, Field var2, T var3);
    }

    public static interface Reader<T> {
        public T read(PacketBuffer var1, Field var2);
    }
}

