/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.KineticDebugger;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.foundation.render.Compartment;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.backend.FastRenderDispatcher;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.ColorHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class KineticTileEntityRenderer
extends SafeTileEntityRenderer<KineticTileEntity> {
    public static final Compartment<BlockState> KINETIC_TILE = new Compartment();
    public static boolean rainbowMode = false;

    public KineticTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (FastRenderDispatcher.available(te.func_145831_w())) {
            return;
        }
        for (RenderType type : RenderType.func_228661_n_()) {
            if (!RenderTypeLookup.canRenderInLayer((BlockState)te.func_195044_w(), (RenderType)type)) continue;
            KineticTileEntityRenderer.renderRotatingBuffer(te, this.getRotatedModel(te), ms, buffer.getBuffer(type), light);
        }
    }

    public static void renderRotatingKineticBlock(KineticTileEntity te, BlockState renderedState, MatrixStack ms, IVertexBuilder buffer, int light) {
        SuperByteBuffer superByteBuffer = CreateClient.bufferCache.renderBlockIn(KINETIC_TILE, renderedState);
        KineticTileEntityRenderer.renderRotatingBuffer(te, superByteBuffer, ms, buffer, light);
    }

    public static void renderRotatingBuffer(KineticTileEntity te, SuperByteBuffer superBuffer, MatrixStack ms, IVertexBuilder buffer, int light) {
        KineticTileEntityRenderer.standardKineticRotationTransform(superBuffer, te, light).renderInto(ms, buffer);
    }

    public static float getAngleForTe(KineticTileEntity te, BlockPos pos, Direction.Axis axis) {
        float time = AnimationTickHolder.getRenderTime((IWorld)te.func_145831_w());
        float offset = KineticTileEntityRenderer.getRotationOffsetForPosition(te, pos, axis);
        float angle = (time * te.getSpeed() * 3.0f / 10.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
        return angle;
    }

    public static SuperByteBuffer standardKineticRotationTransform(SuperByteBuffer buffer, KineticTileEntity te, int light) {
        BlockPos pos = te.func_174877_v();
        Direction.Axis axis = ((IRotate)te.func_195044_w().func_177230_c()).getRotationAxis(te.func_195044_w());
        return KineticTileEntityRenderer.kineticRotationTransform(buffer, te, axis, KineticTileEntityRenderer.getAngleForTe(te, pos, axis), light);
    }

    public static SuperByteBuffer kineticRotationTransform(SuperByteBuffer buffer, KineticTileEntity te, Direction.Axis axis, float angle, int light) {
        buffer.light(light);
        buffer.rotateCentered(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis), angle);
        int white = 0xFFFFFF;
        if (KineticDebugger.isActive()) {
            rainbowMode = true;
            buffer.color(te.hasNetwork() ? ColorHelper.colorFromLong(te.network) : white);
        } else {
            float overStressedEffect = te.effects.overStressedEffect;
            if (overStressedEffect != 0.0f) {
                if (overStressedEffect > 0.0f) {
                    buffer.color(ColorHelper.mixColors(white, 0xFF0000, overStressedEffect));
                } else {
                    buffer.color(ColorHelper.mixColors(white, 65467, -overStressedEffect));
                }
            } else {
                buffer.color(white);
            }
        }
        return buffer;
    }

    protected static float getRotationOffsetForPosition(KineticTileEntity te, BlockPos pos, Direction.Axis axis) {
        float offset = ICogWheel.isLargeCog(te.func_195044_w()) ? 11.25f : 0.0f;
        double d = ((axis == Direction.Axis.X ? 0 : pos.func_177958_n()) + (axis == Direction.Axis.Y ? 0 : pos.func_177956_o()) + (axis == Direction.Axis.Z ? 0 : pos.func_177952_p())) % 2;
        if (d == 0.0) {
            offset = 22.5f;
        }
        return offset;
    }

    public static BlockState shaft(Direction.Axis axis) {
        return (BlockState)AllBlocks.SHAFT.getDefaultState().func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)axis);
    }

    public static Direction.Axis getRotationAxisOf(KineticTileEntity te) {
        return ((IRotate)te.func_195044_w().func_177230_c()).getRotationAxis(te.func_195044_w());
    }

    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return te.func_195044_w();
    }

    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        return CreateClient.bufferCache.renderBlockIn(KINETIC_TILE, this.getRenderedBlockState(te));
    }
}

