/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ActorInstance;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionKineticRenderer;
import com.simibubi.create.foundation.render.backend.core.ModelData;
import com.simibubi.create.foundation.render.backend.instancing.RenderMaterial;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class HarvesterActorInstance
extends ActorInstance {
    static double oneOverRadius = 2.4615384615384617;
    static float originOffset = 0.0625f;
    static Vector3d rotOffset = new Vector3d(0.5, (double)(-2.0f * originOffset + 0.5f), (double)(originOffset + 0.5f));
    ModelData harvester;
    private Direction facing;
    private float horizontalAngle;
    private double rotation;
    private double previousRotation;

    public HarvesterActorInstance(ContraptionKineticRenderer modelManager, MovementContext context) {
        super(modelManager, context);
        RenderMaterial renderMaterial = modelManager.getTransformMaterial();
        BlockState state = context.state;
        this.facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        this.harvester = renderMaterial.getModel(AllBlockPartials.HARVESTER_BLADE, state).createInstance();
        this.horizontalAngle = this.facing.func_185119_l() + (float)(this.facing.func_176740_k() == Direction.Axis.X ? 180 : 0);
        this.harvester.setBlockLight(this.localBlockLight());
    }

    @Override
    public void tick() {
        super.tick();
        this.previousRotation = this.rotation;
        if (this.context.contraption.stalled || VecHelper.isVecPointingTowards(this.context.relativeMotion, this.facing.func_176734_d())) {
            return;
        }
        double arcLength = this.context.motion.func_72433_c();
        double radians = arcLength * oneOverRadius;
        float deg = AngleHelper.deg(radians);
        deg = (int)(deg * 3000.0f) / 3000;
        this.rotation += (double)deg * 1.25;
        this.rotation %= 360.0;
    }

    @Override
    public void beginFrame() {
        MatrixStack ms = new MatrixStack();
        MatrixStacker msr = MatrixStacker.of(ms);
        msr.translate((Vector3i)this.context.localPos).centre().rotateY(this.horizontalAngle).unCentre().translate(rotOffset).rotateX(this.getRotation()).translateBack(rotOffset);
        this.harvester.setTransform(ms);
    }

    private double getRotation() {
        return AngleHelper.angleLerp(AnimationTickHolder.getPartialTicks(), this.previousRotation, this.rotation);
    }
}

