/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors.dispenser;

import com.simibubi.create.content.contraptions.components.actors.dispenser.DispenserMovementBehaviour;
import com.simibubi.create.content.contraptions.components.actors.dispenser.MovedDefaultDispenseItemBehaviour;
import com.simibubi.create.content.contraptions.components.actors.dispenser.MovedOptionalDispenseBehaviour;
import com.simibubi.create.content.contraptions.components.actors.dispenser.MovedProjectileDispenserBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import java.util.Random;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public interface IMovedDispenseItemBehaviour {
    public static void initSpawneggs() {
        MovedDefaultDispenseItemBehaviour spawnEggDispenseBehaviour = new MovedDefaultDispenseItemBehaviour(){

            @Override
            protected ItemStack dispenseStack(ItemStack itemStack, MovementContext context, BlockPos pos, Vector3d facing) {
                EntityType entityType;
                Entity spawnedEntity;
                if (!(itemStack.func_77973_b() instanceof SpawnEggItem)) {
                    return super.dispenseStack(itemStack, context, pos, facing);
                }
                if (context.world instanceof ServerWorld && (spawnedEntity = (entityType = ((SpawnEggItem)itemStack.func_77973_b()).func_208076_b(itemStack.func_77978_p())).func_220331_a((ServerWorld)context.world, itemStack, null, pos.func_177963_a(facing.field_72450_a + 0.7, facing.field_72448_b + 0.7, facing.field_72449_c + 0.7), SpawnReason.DISPENSER, facing.field_72448_b < 0.5, false)) != null) {
                    spawnedEntity.func_213317_d(context.motion.func_186678_a(2.0));
                }
                itemStack.func_190918_g(1);
                return itemStack;
            }
        };
        for (SpawnEggItem spawneggitem : SpawnEggItem.func_195985_g()) {
            DispenserMovementBehaviour.registerMovedDispenseItemBehaviour((Item)spawneggitem, spawnEggDispenseBehaviour);
        }
    }

    public static void init() {
        MovedProjectileDispenserBehaviour movedPotionDispenseItemBehaviour = new MovedProjectileDispenserBehaviour(){

            @Override
            protected ProjectileEntity getProjectileEntity(World world, double x, double y, double z, ItemStack itemStack) {
                return (ProjectileEntity)Util.func_200696_a((Object)new PotionEntity(world, x, y, z), p_218411_1_ -> p_218411_1_.func_213884_b(itemStack));
            }

            @Override
            protected float getProjectileInaccuracy() {
                return super.getProjectileInaccuracy() * 0.5f;
            }

            @Override
            protected float getProjectileVelocity() {
                return super.getProjectileVelocity() * 0.5f;
            }
        };
        DispenserMovementBehaviour.registerMovedDispenseItemBehaviour(Items.field_185155_bH, movedPotionDispenseItemBehaviour);
        DispenserMovementBehaviour.registerMovedDispenseItemBehaviour(Items.field_185156_bI, movedPotionDispenseItemBehaviour);
        DispenserMovementBehaviour.registerMovedDispenseItemBehaviour(Items.field_221649_bM, new MovedDefaultDispenseItemBehaviour(){

            @Override
            protected ItemStack dispenseStack(ItemStack itemStack, MovementContext context, BlockPos pos, Vector3d facing) {
                double x = (double)pos.func_177958_n() + facing.field_72450_a * 0.7 + 0.5;
                double y = (double)pos.func_177956_o() + facing.field_72448_b * 0.7 + 0.5;
                double z = (double)pos.func_177952_p() + facing.field_72449_c * 0.7 + 0.5;
                TNTEntity tntentity = new TNTEntity(context.world, x, y, z, null);
                tntentity.func_70024_g(context.motion.field_72450_a, context.motion.field_72448_b, context.motion.field_72449_c);
                context.world.func_217376_c((Entity)tntentity);
                context.world.func_184148_a(null, tntentity.func_226277_ct_(), tntentity.func_226278_cu_(), tntentity.func_226281_cx_(), SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
                itemStack.func_190918_g(1);
                return itemStack;
            }
        });
        DispenserMovementBehaviour.registerMovedDispenseItemBehaviour(Items.field_196152_dE, new MovedDefaultDispenseItemBehaviour(){

            @Override
            protected ItemStack dispenseStack(ItemStack itemStack, MovementContext context, BlockPos pos, Vector3d facing) {
                double x = (double)pos.func_177958_n() + facing.field_72450_a * 0.7 + 0.5;
                double y = (double)pos.func_177956_o() + facing.field_72448_b * 0.7 + 0.5;
                double z = (double)pos.func_177952_p() + facing.field_72449_c * 0.7 + 0.5;
                FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(context.world, itemStack, x, y, z, true);
                fireworkrocketentity.func_70186_c(facing.field_72450_a, facing.field_72448_b, facing.field_72449_c, 0.5f, 1.0f);
                context.world.func_217376_c((Entity)fireworkrocketentity);
                itemStack.func_190918_g(1);
                return itemStack;
            }

            @Override
            protected void playDispenseSound(IWorld world, BlockPos pos) {
                world.func_217379_c(1004, pos, 0);
            }
        });
        DispenserMovementBehaviour.registerMovedDispenseItemBehaviour(Items.field_151059_bz, new MovedDefaultDispenseItemBehaviour(){

            @Override
            protected void playDispenseSound(IWorld world, BlockPos pos) {
                world.func_217379_c(1018, pos, 0);
            }

            @Override
            protected ItemStack dispenseStack(ItemStack itemStack, MovementContext context, BlockPos pos, Vector3d facing) {
                Random random = context.world.field_73012_v;
                double x = (double)pos.func_177958_n() + facing.field_72450_a * 0.7 + 0.5;
                double y = (double)pos.func_177956_o() + facing.field_72448_b * 0.7 + 0.5;
                double z = (double)pos.func_177952_p() + facing.field_72449_c * 0.7 + 0.5;
                context.world.func_217376_c((Entity)Util.func_200696_a((Object)new SmallFireballEntity(context.world, x, y, z, random.nextGaussian() * 0.05 + facing.field_72450_a + context.motion.field_72450_a, random.nextGaussian() * 0.05 + facing.field_72448_b + context.motion.field_72448_b, random.nextGaussian() * 0.05 + facing.field_72449_c + context.motion.field_72449_c), p_229425_1_ -> p_229425_1_.func_213898_b(itemStack)));
                itemStack.func_190918_g(1);
                return itemStack;
            }
        });
        DispenserMovementBehaviour.registerMovedDispenseItemBehaviour(Items.field_151069_bo, new MovedOptionalDispenseBehaviour(){

            @Override
            protected ItemStack dispenseStack(ItemStack itemStack, MovementContext context, BlockPos pos, Vector3d facing) {
                this.successful = false;
                BlockPos interactAt = pos.func_177972_a(this.getClosestFacingDirection(facing));
                BlockState state = context.world.func_180495_p(interactAt);
                Block block = state.func_177230_c();
                if (block.func_203417_a((ITag)BlockTags.field_226151_aa_) && (Integer)state.func_177229_b((Property)BeehiveBlock.field_226873_c_) >= 5) {
                    ((BeehiveBlock)block).func_226877_a_(context.world, state, interactAt, null, BeehiveTileEntity.State.BEE_RELEASED);
                    this.successful = true;
                    return this.placeItemInInventory(itemStack, new ItemStack((IItemProvider)Items.field_226638_pX_), context, pos, facing);
                }
                if (context.world.func_204610_c(interactAt).func_206884_a((ITag)FluidTags.field_206959_a)) {
                    this.successful = true;
                    return this.placeItemInInventory(itemStack, PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b), context, pos, facing);
                }
                return super.dispenseStack(itemStack, context, pos, facing);
            }
        });
        DispenserMovementBehaviour.registerMovedDispenseItemBehaviour(Items.field_151133_ar, new MovedDefaultDispenseItemBehaviour(){

            @Override
            protected ItemStack dispenseStack(ItemStack itemStack, MovementContext context, BlockPos pos, Vector3d facing) {
                Fluid fluid;
                BlockPos interactAt = pos.func_177972_a(this.getClosestFacingDirection(facing));
                BlockState state = context.world.func_180495_p(interactAt);
                Block block = state.func_177230_c();
                if (block instanceof IBucketPickupHandler && (fluid = ((IBucketPickupHandler)block).func_204508_a((IWorld)context.world, interactAt, state)) instanceof FlowingFluid) {
                    return this.placeItemInInventory(itemStack, new ItemStack((IItemProvider)fluid.func_204524_b()), context, pos, facing);
                }
                return super.dispenseStack(itemStack, context, pos, facing);
            }
        });
    }

    public ItemStack dispense(ItemStack var1, MovementContext var2, BlockPos var3);
}

