/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.fan;

import com.simibubi.create.content.contraptions.components.fan.EncasedFanTileEntity;
import com.simibubi.create.content.contraptions.components.fan.IAirCurrentSource;
import com.simibubi.create.content.contraptions.components.fan.NozzleBlock;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;

public class NozzleTileEntity
extends SmartTileEntity {
    private List<Entity> pushingEntities = new ArrayList<Entity>();
    private float range;
    private boolean pushing;
    private BlockPos fanPos;

    public NozzleTileEntity(TileEntityType<? extends NozzleTileEntity> type) {
        super(type);
        this.setLazyTickRate(5);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    protected void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        compound.func_74776_a("Range", this.range);
        compound.func_74757_a("Pushing", this.pushing);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        this.range = compound.func_74760_g("Range");
        this.pushing = compound.func_74767_n("Pushing");
    }

    @Override
    public void initialize() {
        this.fanPos = this.field_174879_c.func_177972_a(((Direction)this.func_195044_w().func_177229_b((Property)NozzleBlock.field_176387_N)).func_176734_d());
        super.initialize();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        float range = this.calcRange();
        if (this.range != range) {
            this.setRange(range);
        }
        Vector3d center = VecHelper.getCenterOf((Vector3i)this.field_174879_c);
        if (this.field_145850_b.field_72995_K && range != 0.0f && this.field_145850_b.field_73012_v.nextInt(MathHelper.func_76125_a((int)((Integer)AllConfigs.SERVER.kinetics.fanPushDistance.get() - (int)range), (int)1, (int)10)) == 0) {
            Vector3d start = VecHelper.offsetRandomly(center, this.field_145850_b.field_73012_v, this.pushing ? 1.0f : range / 2.0f);
            Vector3d motion = center.func_178788_d(start).func_72432_b().func_186678_a((double)(MathHelper.func_76131_a((float)(range * (this.pushing ? 0.025f : 1.0f)), (float)0.0f, (float)0.5f) * (float)(this.pushing ? -1 : 1)));
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197598_I, start.field_72450_a, start.field_72448_b, start.field_72449_c, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
        }
        Iterator<Entity> iterator = this.pushingEntities.iterator();
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            Vector3d diff = entity.func_213303_ch().func_178788_d(center);
            if (!(entity instanceof PlayerEntity) && this.field_145850_b.field_72995_K) continue;
            double distance = diff.func_72433_c();
            if (distance > (double)range || entity.func_225608_bj_() || entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_()) {
                iterator.remove();
                continue;
            }
            if (!this.pushing && distance < 1.5) continue;
            float factor = entity instanceof ItemEntity ? 0.0078125f : 0.03125f;
            Vector3d pushVec = diff.func_72432_b().func_186678_a(((double)range - distance) * (double)(this.pushing ? 1 : -1));
            entity.func_213317_d(entity.func_213322_ci().func_178787_e(pushVec.func_186678_a((double)factor)));
            entity.field_70143_R = 0.0f;
            entity.field_70133_I = true;
        }
    }

    public void setRange(float range) {
        this.range = range;
        if (range == 0.0f) {
            this.pushingEntities.clear();
        }
        this.sendData();
    }

    private float calcRange() {
        TileEntity te = this.field_145850_b.func_175625_s(this.fanPos);
        if (!(te instanceof IAirCurrentSource)) {
            return 0.0f;
        }
        IAirCurrentSource source = (IAirCurrentSource)te;
        if (source instanceof EncasedFanTileEntity && ((EncasedFanTileEntity)source).isGenerator) {
            return 0.0f;
        }
        if (source.getAirCurrent() == null) {
            return 0.0f;
        }
        if (source.getSpeed() == 0.0f) {
            return 0.0f;
        }
        this.pushing = source.getAirFlowDirection() == source.getAirflowOriginSide();
        return source.getMaxDistance();
    }

    @Override
    public void lazyTick() {
        Entity entity2;
        super.lazyTick();
        if (this.range == 0.0f) {
            return;
        }
        Vector3d center = VecHelper.getCenterOf((Vector3i)this.field_174879_c);
        AxisAlignedBB bb = new AxisAlignedBB(center, center).func_186662_g((double)(this.range / 2.0f));
        for (Entity entity2 : this.field_145850_b.func_217357_a(Entity.class, bb)) {
            Vector3d diff = entity2.func_213303_ch().func_178788_d(center);
            double distance = diff.func_72433_c();
            if (distance > (double)this.range || entity2.func_225608_bj_() || entity2 instanceof PlayerEntity && ((PlayerEntity)entity2).func_184812_l_()) continue;
            boolean canSee = this.canSee(entity2);
            if (!canSee) {
                this.pushingEntities.remove(entity2);
                continue;
            }
            if (this.pushingEntities.contains(entity2)) continue;
            this.pushingEntities.add(entity2);
        }
        Iterator<Entity> iterator = this.pushingEntities.iterator();
        while (iterator.hasNext()) {
            entity2 = iterator.next();
            if (entity2.func_70089_S()) continue;
            iterator.remove();
        }
        if (!this.pushing && this.pushingEntities.size() > 256 && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_217385_a(null, center.field_72450_a, center.field_72448_b, center.field_72449_c, 2.0f, Explosion.Mode.NONE);
            iterator = this.pushingEntities.iterator();
            while (iterator.hasNext()) {
                entity2 = iterator.next();
                entity2.func_70106_y();
                iterator.remove();
            }
        }
    }

    private boolean canSee(Entity entity) {
        RayTraceContext context = new RayTraceContext(entity.func_213303_ch(), VecHelper.getCenterOf((Vector3i)this.field_174879_c), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity);
        return this.field_174879_c.equals((Object)this.field_145850_b.func_217299_a(context).func_216350_a());
    }
}

