/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.press;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.press.MechanicalPressTileEntity;
import com.simibubi.create.content.contraptions.components.press.PressingRecipe;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.InWorldProcessing;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.BeltProcessingBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.items.ItemHandlerHelper;

public class BeltPressingCallbacks {
    static BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler, MechanicalPressTileEntity press) {
        if (press.getSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (press.running) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (!press.getRecipe(transported.stack).isPresent()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        press.start(MechanicalPressTileEntity.Mode.BELT);
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    static BeltProcessingBehaviour.ProcessingResult whenItemHeld(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler, MechanicalPressTileEntity pressTe) {
        if (pressTe.getSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (!pressTe.running) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (pressTe.runningTicks != 120) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        Optional<PressingRecipe> recipe = pressTe.getRecipe(transported.stack);
        pressTe.pressedItems.clear();
        pressTe.pressedItems.add(transported.stack);
        if (!recipe.isPresent()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        boolean bulk = MechanicalPressTileEntity.canProcessInBulk() || transported.stack.func_190916_E() == 1;
        List<TransportedItemStack> collect = InWorldProcessing.applyRecipeOn(bulk ? transported.stack : ItemHandlerHelper.copyStackWithSize((ItemStack)transported.stack, (int)1), (IRecipe)recipe.get()).stream().map(stack -> {
            TransportedItemStack copy = transported.copy();
            boolean centered = BeltHelper.isItemUpright(stack);
            copy.stack = stack;
            copy.locked = true;
            copy.angle = centered ? 180 : Create.random.nextInt(360);
            return copy;
        }).collect(Collectors.toList());
        if (bulk) {
            if (collect.isEmpty()) {
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.removeItem());
            } else {
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(collect));
            }
        } else {
            TransportedItemStack left = transported.copy();
            left.stack.func_190918_g(1);
            if (collect.isEmpty()) {
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(left));
            } else {
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(collect, left));
            }
        }
        pressTe.sendData();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }
}

