/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.saw;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.saw.SawBlock;
import com.simibubi.create.content.contraptions.components.saw.SawTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.backend.FastRenderDispatcher;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;

public class SawRenderer
extends SafeTileEntityRenderer<SawTileEntity> {
    public SawRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(SawTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        this.renderBlade(te, ms, buffer, light);
        this.renderItems(te, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnTileEntity(te, partialTicks, ms, buffer, light, overlay);
        if (FastRenderDispatcher.available(te.func_145831_w())) {
            return;
        }
        this.renderShaft(te, ms, buffer, light, overlay);
    }

    protected void renderBlade(SawTileEntity te, MatrixStack ms, IRenderTypeBuffer buffer, int light) {
        AllBlockPartials partial;
        BlockState blockState = te.func_195044_w();
        float speed = te.getSpeed();
        ms.func_227860_a_();
        if (SawBlock.isHorizontal(blockState)) {
            partial = speed > 0.0f ? AllBlockPartials.SAW_BLADE_HORIZONTAL_ACTIVE : (speed < 0.0f ? AllBlockPartials.SAW_BLADE_HORIZONTAL_REVERSED : AllBlockPartials.SAW_BLADE_HORIZONTAL_INACTIVE);
        } else {
            partial = te.getSpeed() > 0.0f ? AllBlockPartials.SAW_BLADE_VERTICAL_ACTIVE : (speed < 0.0f ? AllBlockPartials.SAW_BLADE_VERTICAL_REVERSED : AllBlockPartials.SAW_BLADE_VERTICAL_INACTIVE);
            if (!((Boolean)blockState.func_177229_b((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE)).booleanValue()) {
                MatrixStacker.of(ms).centre().rotateY(90.0).unCentre();
            }
        }
        SuperByteBuffer superBuffer = partial.renderOnDirectionalSouth(blockState);
        superBuffer.light(light).renderInto(ms, buffer.getBuffer(RenderType.func_228641_d_()));
        ms.func_227865_b_();
    }

    protected void renderShaft(SawTileEntity te, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        KineticTileEntityRenderer.renderRotatingBuffer(te, this.getRotatedModel(te), ms, buffer.getBuffer(RenderType.func_228639_c_()), light);
    }

    protected void renderItems(SawTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        boolean processingMode;
        boolean bl = processingMode = te.func_195044_w().func_177229_b((Property)SawBlock.FACING) == Direction.UP;
        if (processingMode && !te.inventory.isEmpty()) {
            boolean alongZ = (Boolean)te.func_195044_w().func_177229_b((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
            ms.func_227860_a_();
            boolean moving = te.inventory.recipeDuration != 0.0f;
            float offset = moving ? te.inventory.remainingTime / te.inventory.recipeDuration : 0.0f;
            float processingSpeed = MathHelper.func_76131_a((float)(Math.abs(te.getSpeed()) / 32.0f), (float)1.0f, (float)128.0f);
            if (moving) {
                offset = MathHelper.func_76131_a((float)(offset + (-partialTicks + 0.5f) * processingSpeed / te.inventory.recipeDuration), (float)0.0f, (float)1.0f);
            }
            if (te.getSpeed() == 0.0f) {
                offset = 0.5f;
            }
            if (te.getSpeed() < 0.0f ^ alongZ) {
                offset = 1.0f - offset;
            }
            for (int i = 0; i < te.inventory.getSlots(); ++i) {
                ItemStack stack = te.inventory.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
                IBakedModel modelWithOverrides = itemRenderer.func_184393_a(stack, te.func_145831_w(), null);
                boolean blockItem = modelWithOverrides.func_177556_c();
                ms.func_227861_a_(alongZ ? (double)offset : 0.5, blockItem ? (double)0.925f : 0.8125, alongZ ? 0.5 : (double)offset);
                ms.func_227862_a_(0.5f, 0.5f, 0.5f);
                if (alongZ) {
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                }
                ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                itemRenderer.func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, light, overlay, ms, buffer);
                break;
            }
            ms.func_227865_b_();
        }
    }

    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        BlockState state = te.func_195044_w();
        if (((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)).func_176740_k().func_176722_c()) {
            return AllBlockPartials.SHAFT_HALF.renderOnDirectionalSouth(state.rotate((IWorld)te.func_145831_w(), te.func_174877_v(), Rotation.CLOCKWISE_180));
        }
        return CreateClient.bufferCache.renderBlockIn(KineticTileEntityRenderer.KINETIC_TILE, this.getRenderedBlockState(te));
    }

    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return KineticTileEntityRenderer.shaft(KineticTileEntityRenderer.getRotationAxisOf(te));
    }

    public static void renderInContraption(MovementContext context, MatrixStack ms, MatrixStack msLocal, IRenderTypeBuffer buffer) {
        boolean shouldAnimate;
        MatrixStack[] matrixStacks = new MatrixStack[]{ms, msLocal};
        BlockState state = context.state;
        Direction facing = (Direction)state.func_177229_b((Property)SawBlock.FACING);
        Vector3d facingVec = Vector3d.func_237491_b_((Vector3i)((Direction)context.state.func_177229_b((Property)SawBlock.FACING)).func_176730_m());
        facingVec = (Vector3d)context.rotation.apply(facingVec);
        Direction closestToFacing = Direction.func_210769_a((double)facingVec.field_72450_a, (double)facingVec.field_72448_b, (double)facingVec.field_72449_c);
        boolean horizontal = closestToFacing.func_176740_k().func_176722_c();
        boolean backwards = VecHelper.isVecPointingTowards(context.relativeMotion, facing.func_176734_d());
        boolean moving = context.getAnimationSpeed() != 0.0f;
        boolean bl = shouldAnimate = context.contraption.stalled && horizontal || !context.contraption.stalled && !backwards && moving;
        SuperByteBuffer superBuffer = SawBlock.isHorizontal(state) ? (shouldAnimate ? AllBlockPartials.SAW_BLADE_HORIZONTAL_ACTIVE.renderOn(state) : AllBlockPartials.SAW_BLADE_HORIZONTAL_INACTIVE.renderOn(state)) : (shouldAnimate ? AllBlockPartials.SAW_BLADE_VERTICAL_ACTIVE.renderOn(state) : AllBlockPartials.SAW_BLADE_VERTICAL_INACTIVE.renderOn(state));
        for (MatrixStack m : matrixStacks) {
            MatrixStacker.of(m).centre().rotateY(AngleHelper.horizontalAngle(facing)).rotateX(AngleHelper.verticalAngle(facing));
            if (!SawBlock.isHorizontal(state)) {
                MatrixStacker.of(m).rotateZ((Boolean)state.func_177229_b((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE) != false ? 0.0 : 90.0);
            }
            MatrixStacker.of(m).unCentre();
        }
        superBuffer.light(msLocal.func_227866_c_().func_227870_a_(), ContraptionRenderDispatcher.getLightOnContraption(context)).renderInto(ms, buffer.getBuffer(RenderType.func_228641_d_()));
    }
}

