/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.StabilizedContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.MountedContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartController;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class OrientedContraptionEntity
extends AbstractContraptionEntity {
    private static final Ingredient FUEL_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151044_h, Items.field_196155_l});
    private static final DataParameter<Optional<UUID>> COUPLING = EntityDataManager.func_187226_a(OrientedContraptionEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Direction> INITIAL_ORIENTATION = EntityDataManager.func_187226_a(OrientedContraptionEntity.class, (IDataSerializer)DataSerializers.field_187202_l);
    protected Vector3d motionBeforeStall = Vector3d.field_186680_a;
    protected boolean forceAngle;
    private boolean isSerializingFurnaceCart = false;
    private boolean attachedExtraInventories = false;
    private boolean manuallyPlaced;
    public float prevYaw;
    public float yaw;
    public float targetYaw;
    public float prevPitch;
    public float pitch;
    public float targetPitch;
    private float initialYawOffset = -1.0f;

    public OrientedContraptionEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    public static OrientedContraptionEntity create(World world, Contraption contraption, Optional<Direction> initialOrientation) {
        OrientedContraptionEntity entity = new OrientedContraptionEntity(AllEntityTypes.ORIENTED_CONTRAPTION.get(), world);
        entity.setContraption(contraption);
        initialOrientation.ifPresent(entity::setInitialOrientation);
        entity.startAtInitialYaw();
        return entity;
    }

    public static OrientedContraptionEntity createAtYaw(World world, Contraption contraption, Optional<Direction> initialOrientation, float initialYaw) {
        OrientedContraptionEntity entity = OrientedContraptionEntity.create(world, contraption, initialOrientation);
        entity.startAtYaw(initialYaw);
        entity.manuallyPlaced = true;
        return entity;
    }

    public void setInitialOrientation(Direction direction) {
        this.field_70180_af.func_187227_b(INITIAL_ORIENTATION, (Object)direction);
    }

    public Direction getInitialOrientation() {
        return (Direction)this.field_70180_af.func_187225_a(INITIAL_ORIENTATION);
    }

    public void deferOrientation(Direction newInitialAngle) {
        this.field_70180_af.func_187227_b(INITIAL_ORIENTATION, (Object)Direction.UP);
        this.yaw = this.initialYawOffset = newInitialAngle.func_185119_l();
    }

    @Override
    public float getYawOffset() {
        return this.getInitialYaw();
    }

    public float getInitialYaw() {
        return (this.isInitialOrientationPresent() ? (Direction)this.field_70180_af.func_187225_a(INITIAL_ORIENTATION) : Direction.SOUTH).func_185119_l();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COUPLING, Optional.empty());
        this.field_70180_af.func_187214_a(INITIAL_ORIENTATION, (Object)Direction.UP);
    }

    @Override
    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        AbstractContraptionEntity.ContraptionRotationState crs = new AbstractContraptionEntity.ContraptionRotationState();
        float yawOffset = this.getYawOffset();
        crs.zRotation = this.pitch;
        crs.yRotation = -this.yaw + yawOffset;
        if (this.pitch != 0.0f && this.yaw != 0.0f) {
            crs.secondYRotation = -this.yaw;
            crs.yRotation = yawOffset;
        }
        return crs;
    }

    public void func_184210_p() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.disassemble();
        }
        super.func_184210_p();
    }

    @Override
    protected void readAdditional(CompoundNBT compound, boolean spawnPacket) {
        ListNBT vecNBT;
        super.readAdditional(compound, spawnPacket);
        if (compound.func_74764_b("InitialOrientation")) {
            this.setInitialOrientation(NBTHelper.readEnum(compound, "InitialOrientation", Direction.class));
        }
        this.yaw = compound.func_74760_g("Yaw");
        this.pitch = compound.func_74760_g("Pitch");
        this.manuallyPlaced = compound.func_74767_n("Placed");
        if (compound.func_74764_b("ForceYaw")) {
            this.startAtYaw(compound.func_74760_g("ForceYaw"));
        }
        if (!(vecNBT = compound.func_150295_c("CachedMotion", 6)).isEmpty()) {
            this.motionBeforeStall = new Vector3d(vecNBT.func_150309_d(0), vecNBT.func_150309_d(1), vecNBT.func_150309_d(2));
            if (!this.motionBeforeStall.equals((Object)Vector3d.field_186680_a)) {
                this.prevYaw = this.yaw += OrientedContraptionEntity.yawFromVector(this.motionBeforeStall);
                this.targetYaw = this.yaw;
            }
            this.func_213317_d(Vector3d.field_186680_a);
        }
        this.setCouplingId(compound.func_74764_b("OnCoupling") ? compound.func_186857_a("OnCoupling") : null);
    }

    @Override
    protected void writeAdditional(CompoundNBT compound, boolean spawnPacket) {
        Direction optional;
        super.writeAdditional(compound, spawnPacket);
        if (this.motionBeforeStall != null) {
            compound.func_218657_a("CachedMotion", (INBT)this.func_70087_a(new double[]{this.motionBeforeStall.field_72450_a, this.motionBeforeStall.field_72448_b, this.motionBeforeStall.field_72449_c}));
        }
        if ((optional = (Direction)this.field_70180_af.func_187225_a(INITIAL_ORIENTATION)).func_176740_k().func_176722_c()) {
            NBTHelper.writeEnum(compound, "InitialOrientation", optional);
        }
        if (this.forceAngle) {
            compound.func_74776_a("ForceYaw", this.yaw);
            this.forceAngle = false;
        }
        compound.func_74757_a("Placed", this.manuallyPlaced);
        compound.func_74776_a("Yaw", this.yaw);
        compound.func_74776_a("Pitch", this.pitch);
        if (this.getCouplingId() != null) {
            compound.func_186854_a("OnCoupling", this.getCouplingId());
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key == INITIAL_ORIENTATION && this.isInitialOrientationPresent() && !this.manuallyPlaced) {
            this.startAtInitialYaw();
        }
    }

    public boolean isInitialOrientationPresent() {
        return ((Direction)this.field_70180_af.func_187225_a(INITIAL_ORIENTATION)).func_176740_k().func_176722_c();
    }

    public void startAtInitialYaw() {
        this.startAtYaw(this.getInitialYaw());
    }

    public void startAtYaw(float yaw) {
        this.yaw = this.prevYaw = yaw;
        this.targetYaw = this.prevYaw;
        this.forceAngle = true;
    }

    @Override
    public Vector3d applyRotation(Vector3d localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, this.getInitialYaw(), Direction.Axis.Y);
        localPos = VecHelper.rotate(localPos, this.func_195050_f(partialTicks), Direction.Axis.Z);
        localPos = VecHelper.rotate(localPos, this.func_195046_g(partialTicks), Direction.Axis.Y);
        return localPos;
    }

    @Override
    public Vector3d reverseRotation(Vector3d localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, -this.func_195046_g(partialTicks), Direction.Axis.Y);
        localPos = VecHelper.rotate(localPos, -this.func_195050_f(partialTicks), Direction.Axis.Z);
        localPos = VecHelper.rotate(localPos, -this.getInitialYaw(), Direction.Axis.Y);
        return localPos;
    }

    public float func_195046_g(float partialTicks) {
        return -(partialTicks == 1.0f ? this.yaw : AngleHelper.angleLerp(partialTicks, this.prevYaw, this.yaw));
    }

    public float func_195050_f(float partialTicks) {
        return partialTicks == 1.0f ? this.pitch : AngleHelper.angleLerp(partialTicks, this.prevPitch, this.pitch);
    }

    @Override
    protected void tickContraption() {
        boolean rotating;
        Entity e = this.func_184187_bx();
        if (e == null) {
            return;
        }
        boolean rotationLock = false;
        boolean pauseWhileRotating = false;
        boolean wasStalled = this.isStalled();
        if (this.contraption instanceof MountedContraption) {
            MountedContraption mountedContraption = (MountedContraption)this.contraption;
            rotationLock = mountedContraption.rotationMode == CartAssemblerTileEntity.CartMovementMode.ROTATION_LOCKED;
            pauseWhileRotating = mountedContraption.rotationMode == CartAssemblerTileEntity.CartMovementMode.ROTATE_PAUSED;
        }
        Entity riding = e;
        while (riding.func_184187_bx() != null && !(this.contraption instanceof StabilizedContraption)) {
            riding = riding.func_184187_bx();
        }
        boolean isOnCoupling = false;
        UUID couplingId = this.getCouplingId();
        boolean bl = isOnCoupling = couplingId != null && riding instanceof AbstractMinecartEntity;
        if (!this.attachedExtraInventories) {
            this.attachInventoriesFromRidingCarts(riding, isOnCoupling, couplingId);
            this.attachedExtraInventories = true;
        }
        if (!(rotating = this.updateOrientation(rotationLock, wasStalled, riding, isOnCoupling)) || !pauseWhileRotating) {
            this.tickActors();
        }
        boolean isStalled = this.isStalled();
        LazyOptional capability = riding.getCapability(CapabilityMinecartController.MINECART_CONTROLLER_CAPABILITY);
        if (capability.isPresent()) {
            if (!this.field_70170_p.func_201670_d()) {
                ((MinecartController)capability.orElse(null)).setStalledExternally(isStalled);
            }
        } else {
            if (isStalled) {
                if (!wasStalled) {
                    this.motionBeforeStall = riding.func_213322_ci();
                }
                riding.func_213293_j(0.0, 0.0, 0.0);
            }
            if (wasStalled && !isStalled) {
                riding.func_213317_d(this.motionBeforeStall);
                this.motionBeforeStall = Vector3d.field_186680_a;
            }
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isStalled()) {
            if (isOnCoupling) {
                Couple<MinecartController> coupledCarts = this.getCoupledCartsIfPresent();
                if (coupledCarts == null) {
                    return;
                }
                coupledCarts.map(MinecartController::cart).forEach(this::powerFurnaceCartWithFuelFromStorage);
                return;
            }
            this.powerFurnaceCartWithFuelFromStorage(riding);
        }
    }

    protected boolean updateOrientation(boolean rotationLock, boolean wasStalled, Entity riding, boolean isOnCoupling) {
        if (isOnCoupling) {
            Couple<MinecartController> coupledCarts = this.getCoupledCartsIfPresent();
            if (coupledCarts == null) {
                return false;
            }
            Vector3d positionVec = ((MinecartController)coupledCarts.getFirst()).cart().func_213303_ch();
            Vector3d coupledVec = ((MinecartController)coupledCarts.getSecond()).cart().func_213303_ch();
            double diffX = positionVec.field_72450_a - coupledVec.field_72450_a;
            double diffY = positionVec.field_72448_b - coupledVec.field_72448_b;
            double diffZ = positionVec.field_72449_c - coupledVec.field_72449_c;
            this.prevYaw = this.yaw;
            this.prevPitch = this.pitch;
            this.yaw = (float)(MathHelper.func_181159_b((double)diffZ, (double)diffX) * 180.0 / Math.PI);
            this.pitch = (float)(Math.atan2(diffY, Math.sqrt(diffX * diffX + diffZ * diffZ)) * 180.0 / Math.PI);
            if (this.getCouplingId().equals(riding.func_110124_au())) {
                this.pitch *= -1.0f;
                this.yaw += 180.0f;
            }
            return false;
        }
        if (this.contraption instanceof StabilizedContraption) {
            if (!(riding instanceof OrientedContraptionEntity)) {
                return false;
            }
            StabilizedContraption stabilized = (StabilizedContraption)this.contraption;
            Direction facing = stabilized.getFacing();
            if (facing.func_176740_k().func_200128_b()) {
                return false;
            }
            OrientedContraptionEntity parent = (OrientedContraptionEntity)riding;
            this.prevYaw = this.yaw;
            this.yaw = -parent.func_195046_g(1.0f);
            return false;
        }
        this.prevYaw = this.yaw;
        if (wasStalled) {
            return false;
        }
        boolean rotating = false;
        Vector3d movementVector = riding.func_213322_ci();
        Vector3d locationDiff = riding.func_213303_ch().func_178786_a(riding.field_70169_q, riding.field_70167_r, riding.field_70166_s);
        if (!(riding instanceof AbstractMinecartEntity)) {
            movementVector = locationDiff;
        }
        Vector3d motion = movementVector.func_72432_b();
        if (!this.isInitialOrientationPresent() && !this.field_70170_p.field_72995_K && locationDiff.func_72433_c() > 0.0) {
            Direction facingFromVector = Direction.func_210769_a((double)locationDiff.field_72450_a, (double)locationDiff.field_72448_b, (double)locationDiff.field_72449_c);
            if (this.initialYawOffset != -1.0f) {
                facingFromVector = Direction.func_176733_a((double)(facingFromVector.func_185119_l() - this.initialYawOffset));
            }
            if (facingFromVector.func_176740_k().func_176722_c()) {
                this.setInitialOrientation(facingFromVector);
            }
        }
        if (!rotationLock) {
            if (motion.func_72433_c() > 0.0) {
                this.targetYaw = OrientedContraptionEntity.yawFromVector(motion);
                if (this.targetYaw < 0.0f) {
                    this.targetYaw += 360.0f;
                }
                if (this.yaw < 0.0f) {
                    this.yaw += 360.0f;
                }
            }
            this.prevYaw = this.yaw;
            this.yaw = AngleHelper.angleLerp(0.4f, this.yaw, this.targetYaw);
            if (Math.abs(AngleHelper.getShortestAngleDiff(this.yaw, this.targetYaw)) < 1.0f) {
                this.yaw = this.targetYaw;
            } else {
                rotating = true;
            }
        }
        return rotating;
    }

    protected void powerFurnaceCartWithFuelFromStorage(Entity riding) {
        ItemStack coal;
        int k;
        int j;
        int fuel;
        if (!(riding instanceof FurnaceMinecartEntity)) {
            return;
        }
        FurnaceMinecartEntity furnaceCart = (FurnaceMinecartEntity)riding;
        this.isSerializingFurnaceCart = true;
        CompoundNBT nbt = furnaceCart.serializeNBT();
        this.isSerializingFurnaceCart = false;
        int fuelBefore = fuel = nbt.func_74762_e("Fuel");
        double pushX = nbt.func_74769_h("PushX");
        double pushZ = nbt.func_74769_h("PushZ");
        int i = MathHelper.func_76128_c((double)furnaceCart.func_226277_ct_());
        if (furnaceCart.field_70170_p.func_180495_p(new BlockPos(i, (j = MathHelper.func_76128_c((double)furnaceCart.func_226278_cu_())) - 1, k = MathHelper.func_76128_c((double)furnaceCart.func_226281_cx_()))).func_235714_a_((ITag)BlockTags.field_203437_y)) {
            --j;
        }
        BlockPos blockpos = new BlockPos(i, j, k);
        BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
        if (furnaceCart.canUseRail() && blockstate.func_235714_a_((ITag)BlockTags.field_203437_y) && fuel > 1) {
            riding.func_213317_d(riding.func_213322_ci().func_72432_b().func_186678_a(1.0));
        }
        if (fuel < 5 && this.contraption != null && !(coal = ItemHelper.extract((IItemHandler)this.contraption.inventory, (Predicate<ItemStack>)FUEL_ITEMS, 1, false)).func_190926_b()) {
            fuel += 3600;
        }
        if (fuel != fuelBefore || pushX != 0.0 || pushZ != 0.0) {
            nbt.func_74768_a("Fuel", fuel);
            nbt.func_74780_a("PushX", 0.0);
            nbt.func_74780_a("PushZ", 0.0);
            furnaceCart.deserializeNBT(nbt);
        }
    }

    @Nullable
    public Couple<MinecartController> getCoupledCartsIfPresent() {
        UUID couplingId = this.getCouplingId();
        if (couplingId == null) {
            return null;
        }
        MinecartController controller = CapabilityMinecartController.getIfPresent(this.field_70170_p, couplingId);
        if (controller == null || !controller.isPresent()) {
            return null;
        }
        UUID coupledCart = controller.getCoupledCart(true);
        MinecartController coupledController = CapabilityMinecartController.getIfPresent(this.field_70170_p, coupledCart);
        if (coupledController == null || !coupledController.isPresent()) {
            return null;
        }
        return Couple.create(controller, coupledController);
    }

    protected void attachInventoriesFromRidingCarts(Entity riding, boolean isOnCoupling, UUID couplingId) {
        if (isOnCoupling) {
            Couple<MinecartController> coupledCarts = this.getCoupledCartsIfPresent();
            if (coupledCarts == null) {
                return;
            }
            coupledCarts.map(MinecartController::cart).forEach(this.contraption::addExtraInventories);
            return;
        }
        this.contraption.addExtraInventories(riding);
    }

    @Override
    public CompoundNBT func_189511_e(CompoundNBT nbt) {
        return this.isSerializingFurnaceCart ? nbt : super.func_189511_e(nbt);
    }

    @Nullable
    public UUID getCouplingId() {
        Optional uuid = (Optional)this.field_70180_af.func_187225_a(COUPLING);
        return uuid == null ? null : (uuid.isPresent() ? (UUID)uuid.get() : null);
    }

    public void setCouplingId(UUID id) {
        this.field_70180_af.func_187227_b(COUPLING, Optional.ofNullable(id));
    }

    @Override
    public Vector3d getAnchorVec() {
        return new Vector3d(this.func_226277_ct_() - 0.5, this.func_226278_cu_(), this.func_226281_cx_() - 0.5);
    }

    @Override
    protected StructureTransform makeStructureTransform() {
        BlockPos offset = new BlockPos(this.getAnchorVec().func_72441_c(0.5, 0.5, 0.5));
        return new StructureTransform(offset, 0.0f, -this.yaw + this.getInitialYaw(), 0.0f);
    }

    @Override
    protected float getStalledAngle() {
        return this.yaw;
    }

    @Override
    protected void handleStallInformation(float x, float y, float z, float angle) {
        this.yaw = angle;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doLocalTransforms(float partialTicks, MatrixStack[] matrixStacks) {
        float angleInitialYaw = this.getInitialYaw();
        float angleYaw = this.func_195046_g(partialTicks);
        float anglePitch = this.func_195050_f(partialTicks);
        for (MatrixStack stack : matrixStacks) {
            stack.func_227861_a_(-0.5, 0.0, -0.5);
        }
        Entity ridingEntity = this.func_184187_bx();
        if (ridingEntity instanceof AbstractMinecartEntity) {
            this.repositionOnCart(partialTicks, matrixStacks, ridingEntity);
        } else if (ridingEntity instanceof AbstractContraptionEntity) {
            if (ridingEntity.func_184187_bx() instanceof AbstractMinecartEntity) {
                this.repositionOnCart(partialTicks, matrixStacks, ridingEntity.func_184187_bx());
            } else {
                this.repositionOnContraption(partialTicks, matrixStacks, ridingEntity);
            }
        }
        for (MatrixStack stack : matrixStacks) {
            MatrixStacker.of(stack).nudge(this.func_145782_y()).centre().rotateY(angleYaw).rotateZ(anglePitch).rotateY(angleInitialYaw).unCentre();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void repositionOnContraption(float partialTicks, MatrixStack[] matrixStacks, Entity ridingEntity) {
        Vector3d pos = this.getContraptionOffset(partialTicks, ridingEntity);
        for (MatrixStack stack : matrixStacks) {
            stack.func_227861_a_(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void repositionOnCart(float partialTicks, MatrixStack[] matrixStacks, Entity ridingEntity) {
        Vector3d cartPos = this.getCartOffset(partialTicks, ridingEntity);
        if (cartPos == Vector3d.field_186680_a) {
            return;
        }
        for (MatrixStack stack : matrixStacks) {
            stack.func_227861_a_(cartPos.field_72450_a, cartPos.field_72448_b, cartPos.field_72449_c);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private Vector3d getContraptionOffset(float partialTicks, Entity ridingEntity) {
        AbstractContraptionEntity parent = (AbstractContraptionEntity)ridingEntity;
        Vector3d passengerPosition = parent.getPassengerPosition(this, partialTicks);
        double x = passengerPosition.field_72450_a - MathHelper.func_219803_d((double)partialTicks, (double)this.field_70142_S, (double)this.func_226277_ct_());
        double y = passengerPosition.field_72448_b - MathHelper.func_219803_d((double)partialTicks, (double)this.field_70137_T, (double)this.func_226278_cu_());
        double z = passengerPosition.field_72449_c - MathHelper.func_219803_d((double)partialTicks, (double)this.field_70136_U, (double)this.func_226281_cx_());
        return new Vector3d(x, y, z);
    }

    @OnlyIn(value=Dist.CLIENT)
    private Vector3d getCartOffset(float partialTicks, Entity ridingEntity) {
        double cartZ;
        double cartY;
        AbstractMinecartEntity cart = (AbstractMinecartEntity)ridingEntity;
        double cartX = MathHelper.func_219803_d((double)partialTicks, (double)cart.field_70142_S, (double)cart.func_226277_ct_());
        Vector3d cartPos = cart.func_70489_a(cartX, cartY = MathHelper.func_219803_d((double)partialTicks, (double)cart.field_70137_T, (double)cart.func_226278_cu_()), cartZ = MathHelper.func_219803_d((double)partialTicks, (double)cart.field_70136_U, (double)cart.func_226281_cx_()));
        if (cartPos != null) {
            Vector3d cartPosFront = cart.func_70495_a(cartX, cartY, cartZ, (double)0.3f);
            Vector3d cartPosBack = cart.func_70495_a(cartX, cartY, cartZ, (double)-0.3f);
            if (cartPosFront == null) {
                cartPosFront = cartPos;
            }
            if (cartPosBack == null) {
                cartPosBack = cartPos;
            }
            cartX = cartPos.field_72450_a - cartX;
            cartY = (cartPosFront.field_72448_b + cartPosBack.field_72448_b) / 2.0 - cartY;
            cartZ = cartPos.field_72449_c - cartZ;
            return new Vector3d(cartX, cartY, cartZ);
        }
        return Vector3d.field_186680_a;
    }
}

