/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.chassis;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.BlockMovementTraits;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.AbstractChassisBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.ChassisRangeDisplay;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.LinearChassisBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.RadialChassisBlock;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.BulkScrollValueBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class ChassisTileEntity
extends SmartTileEntity {
    ScrollValueBehaviour range;

    public ChassisTileEntity(TileEntityType<? extends ChassisTileEntity> type) {
        super(type);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        int max = (Integer)AllConfigs.SERVER.kinetics.maxChassisRange.get();
        this.range = new BulkScrollValueBehaviour((ITextComponent)Lang.translate("generic.range", new Object[0]), this, new CenteredSideValueBoxTransform(), te -> ((ChassisTileEntity)((Object)te)).collectChassisGroup());
        this.range.requiresWrench();
        this.range.between(1, max);
        this.range.withClientCallback(i -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ChassisRangeDisplay.display(this)));
        this.range.value = max / 2;
        behaviours.add(this.range);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.func_195044_w().func_177230_c() instanceof RadialChassisBlock) {
            this.range.setLabel((ITextComponent)Lang.translate("generic.radius", new Object[0]));
        }
    }

    public int getRange() {
        return this.range.getValue();
    }

    public List<BlockPos> getIncludedBlockPositions(Direction forcedMovement, boolean visualize) {
        if (!(this.func_195044_w().func_177230_c() instanceof AbstractChassisBlock)) {
            return Collections.emptyList();
        }
        return this.isRadial() ? this.getIncludedBlockPositionsRadial(forcedMovement, visualize) : this.getIncludedBlockPositionsLinear(forcedMovement, visualize);
    }

    protected boolean isRadial() {
        return this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof RadialChassisBlock;
    }

    public List<ChassisTileEntity> collectChassisGroup() {
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        ArrayList<ChassisTileEntity> collected = new ArrayList<ChassisTileEntity>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        frontier.add(this.field_174879_c);
        while (!frontier.isEmpty()) {
            BlockPos current = (BlockPos)frontier.poll();
            if (visited.contains(current)) continue;
            visited.add(current);
            TileEntity tileEntity = this.field_145850_b.func_175625_s(current);
            if (!(tileEntity instanceof ChassisTileEntity)) continue;
            ChassisTileEntity chassis = (ChassisTileEntity)tileEntity;
            collected.add(chassis);
            visited.add(current);
            chassis.addAttachedChasses(frontier, visited);
        }
        return collected;
    }

    public boolean addAttachedChasses(Queue<BlockPos> frontier, Set<BlockPos> visited) {
        BlockState state = this.func_195044_w();
        if (!(state.func_177230_c() instanceof AbstractChassisBlock)) {
            return false;
        }
        Direction.Axis axis = (Direction.Axis)state.func_177229_b((Property)AbstractChassisBlock.field_176298_M);
        if (this.isRadial()) {
            for (int offset : new int[]{-1, 1}) {
                Direction direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
                BlockPos currentPos = this.field_174879_c.func_177967_a(direction, offset);
                if (!this.field_145850_b.func_195588_v(currentPos)) {
                    return false;
                }
                BlockState neighbourState = this.field_145850_b.func_180495_p(currentPos);
                if (!AllBlocks.RADIAL_CHASSIS.has(neighbourState) || axis != neighbourState.func_177229_b((Property)BlockStateProperties.field_208148_A) || visited.contains(currentPos)) continue;
                frontier.add(currentPos);
            }
            return true;
        }
        for (Direction offset : Iterate.directions) {
            BlockPos current = this.field_174879_c.func_177972_a(offset);
            if (visited.contains(current)) continue;
            if (!this.field_145850_b.func_195588_v(current)) {
                return false;
            }
            BlockState neighbourState = this.field_145850_b.func_180495_p(current);
            if (!LinearChassisBlock.isChassis(neighbourState) || !LinearChassisBlock.sameKind(state, neighbourState) || neighbourState.func_177229_b((Property)BlockStateProperties.field_208148_A) != axis) continue;
            frontier.add(current);
        }
        return true;
    }

    private List<BlockPos> getIncludedBlockPositionsLinear(Direction forcedMovement, boolean visualize) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockState state = this.func_195044_w();
        AbstractChassisBlock block = (AbstractChassisBlock)state.func_177230_c();
        Direction.Axis axis = (Direction.Axis)state.func_177229_b((Property)AbstractChassisBlock.field_176298_M);
        Direction facing = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        int chassisRange = visualize ? this.range.scrollableValue : this.getRange();
        block0: for (int offset : new int[]{1, -1}) {
            if (offset == -1) {
                facing = facing.func_176734_d();
            }
            boolean sticky = (Boolean)state.func_177229_b((Property)block.getGlueableSide(state, facing));
            for (int i = 1; i <= chassisRange; ++i) {
                BlockPos current = this.field_174879_c.func_177967_a(facing, i);
                BlockState currentState = this.field_145850_b.func_180495_p(current);
                if (forcedMovement != facing && !sticky || !BlockMovementTraits.movementNecessary(currentState, this.field_145850_b, current) || BlockMovementTraits.isBrittle(currentState)) continue block0;
                positions.add(current);
                if (BlockMovementTraits.notSupportive(currentState, facing)) continue block0;
            }
        }
        return positions;
    }

    private List<BlockPos> getIncludedBlockPositionsRadial(Direction forcedMovement, boolean visualize) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Direction.Axis axis = (Direction.Axis)state.func_177229_b((Property)AbstractChassisBlock.field_176298_M);
        AbstractChassisBlock block = (AbstractChassisBlock)state.func_177230_c();
        int chassisRange = visualize ? this.range.scrollableValue : this.getRange();
        for (Direction facing : Iterate.directions) {
            if (facing.func_176740_k() == axis || !((Boolean)state.func_177229_b((Property)block.getGlueableSide(state, facing))).booleanValue()) continue;
            BlockPos startPos = this.field_174879_c.func_177972_a(facing);
            LinkedList<BlockPos> localFrontier = new LinkedList<BlockPos>();
            HashSet<BlockPos> localVisited = new HashSet<BlockPos>();
            localFrontier.add(startPos);
            while (!localFrontier.isEmpty()) {
                BlockPos searchPos = (BlockPos)localFrontier.remove(0);
                BlockState searchedState = this.field_145850_b.func_180495_p(searchPos);
                if (localVisited.contains(searchPos) || !searchPos.func_218141_a((Vector3i)this.field_174879_c, (double)((float)chassisRange + 0.5f)) || !BlockMovementTraits.movementNecessary(searchedState, this.field_145850_b, searchPos) || BlockMovementTraits.isBrittle(searchedState)) continue;
                localVisited.add(searchPos);
                if (!searchPos.equals((Object)this.field_174879_c)) {
                    positions.add(searchPos);
                }
                for (Direction offset : Iterate.directions) {
                    if (offset.func_176740_k() == axis || searchPos.equals((Object)this.field_174879_c) && offset != facing || BlockMovementTraits.notSupportive(searchedState, offset)) continue;
                    localFrontier.add(searchPos.func_177972_a(offset));
                }
            }
        }
        return positions;
    }
}

