/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.gantry;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryContraptionUpdatePacket;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftBlock;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftTileEntity;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class GantryContraptionEntity
extends AbstractContraptionEntity {
    Direction movementAxis;
    double clientOffsetDiff;
    double axisMotion;

    public GantryContraptionEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public static GantryContraptionEntity create(World world, Contraption contraption, Direction movementAxis) {
        GantryContraptionEntity entity = new GantryContraptionEntity(AllEntityTypes.GANTRY_CONTRAPTION.get(), world);
        entity.setContraption(contraption);
        entity.movementAxis = movementAxis;
        return entity;
    }

    @Override
    protected void tickContraption() {
        if (!(this.contraption instanceof GantryContraption)) {
            return;
        }
        double prevAxisMotion = this.axisMotion;
        if (this.field_70170_p.field_72995_K) {
            this.clientOffsetDiff *= 0.75;
            this.updateClientMotion();
        }
        this.checkPinionShaft();
        this.tickActors();
        Vector3d movementVec = this.func_213322_ci();
        if (ContraptionCollider.collideBlocks(this)) {
            if (!this.field_70170_p.field_72995_K) {
                this.disassemble();
            }
            return;
        }
        if (!this.isStalled() && this.field_70173_aa > 2) {
            this.move(movementVec.field_72450_a, movementVec.field_72448_b, movementVec.field_72449_c);
        }
        if (Math.signum(prevAxisMotion) != Math.signum(this.axisMotion) && prevAxisMotion != 0.0) {
            this.contraption.stop(this.field_70170_p);
        }
        if (!(this.field_70170_p.field_72995_K || prevAxisMotion == this.axisMotion && this.field_70173_aa % 3 != 0)) {
            this.sendPacket();
        }
    }

    protected void checkPinionShaft() {
        Direction facing = ((GantryContraption)this.contraption).getFacing();
        Vector3d currentPosition = this.getAnchorVec().func_72441_c(0.5, 0.5, 0.5);
        BlockPos gantryShaftPos = new BlockPos(currentPosition).func_177972_a(facing.func_176734_d());
        TileEntity te = this.field_70170_p.func_175625_s(gantryShaftPos);
        if (!(te instanceof GantryShaftTileEntity) || !AllBlocks.GANTRY_SHAFT.has(te.func_195044_w())) {
            if (!this.field_70170_p.field_72995_K) {
                this.setContraptionMotion(Vector3d.field_186680_a);
                this.disassemble();
            }
            return;
        }
        BlockState blockState = te.func_195044_w();
        Direction direction = (Direction)blockState.func_177229_b((Property)GantryShaftBlock.FACING);
        GantryShaftTileEntity gantryShaftTileEntity = (GantryShaftTileEntity)te;
        float pinionMovementSpeed = gantryShaftTileEntity.getPinionMovementSpeed();
        Vector3d movementVec = Vector3d.func_237491_b_((Vector3i)direction.func_176730_m()).func_186678_a((double)pinionMovementSpeed);
        if (((Boolean)blockState.func_177229_b((Property)GantryShaftBlock.POWERED)).booleanValue() || pinionMovementSpeed == 0.0f) {
            this.setContraptionMotion(Vector3d.field_186680_a);
            if (!this.field_70170_p.field_72995_K) {
                this.disassemble();
            }
            return;
        }
        Vector3d nextPosition = currentPosition.func_178787_e(movementVec);
        double currentCoord = direction.func_176740_k().func_196051_a(currentPosition.field_72450_a, currentPosition.field_72448_b, currentPosition.field_72449_c);
        double nextCoord = direction.func_176740_k().func_196051_a(nextPosition.field_72450_a, nextPosition.field_72448_b, nextPosition.field_72449_c);
        if ((double)((float)MathHelper.func_76128_c((double)currentCoord) + 0.5f) < nextCoord != pinionMovementSpeed * (float)direction.func_176743_c().func_179524_a() < 0.0f && !gantryShaftTileEntity.canAssembleOn()) {
            this.setContraptionMotion(Vector3d.field_186680_a);
            if (!this.field_70170_p.field_72995_K) {
                this.disassemble();
            }
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.axisMotion = pinionMovementSpeed;
        this.setContraptionMotion(movementVec);
    }

    @Override
    protected void writeAdditional(CompoundNBT compound, boolean spawnPacket) {
        NBTHelper.writeEnum(compound, "GantryAxis", this.movementAxis);
        super.writeAdditional(compound, spawnPacket);
    }

    @Override
    protected void readAdditional(CompoundNBT compound, boolean spawnData) {
        this.movementAxis = NBTHelper.readEnum(compound, "GantryAxis", Direction.class);
        super.readAdditional(compound, spawnData);
    }

    @Override
    public Vector3d applyRotation(Vector3d localPos, float partialTicks) {
        return localPos;
    }

    @Override
    public Vector3d reverseRotation(Vector3d localPos, float partialTicks) {
        return localPos;
    }

    @Override
    protected StructureTransform makeStructureTransform() {
        return new StructureTransform(new BlockPos(this.getAnchorVec().func_72441_c(0.5, 0.5, 0.5)), 0.0f, 0.0f, 0.0f);
    }

    @Override
    protected float getStalledAngle() {
        return 0.0f;
    }

    public void func_70634_a(double p_70634_1_, double p_70634_3_, double p_70634_5_) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yw, float pt, int inc, boolean t) {
    }

    @Override
    protected void handleStallInformation(float x, float y, float z, float angle) {
        this.func_226288_n_(x, y, z);
        this.clientOffsetDiff = 0.0;
    }

    @Override
    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        return AbstractContraptionEntity.ContraptionRotationState.NONE;
    }

    @Override
    public void doLocalTransforms(float partialTicks, MatrixStack[] matrixStacks) {
    }

    public void updateClientMotion() {
        float modifier = this.movementAxis.func_176743_c().func_179524_a();
        this.setContraptionMotion(Vector3d.func_237491_b_((Vector3i)this.movementAxis.func_176730_m()).func_186678_a((this.axisMotion + this.clientOffsetDiff * (double)modifier / 2.0) * (double)ServerSpeedProvider.get()));
    }

    public double getAxisCoord() {
        Vector3d anchorVec = this.getAnchorVec();
        return this.movementAxis.func_176740_k().func_196051_a(anchorVec.field_72450_a, anchorVec.field_72448_b, anchorVec.field_72449_c);
    }

    public void sendPacket() {
        AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new GantryContraptionUpdatePacket(this.func_145782_y(), this.getAxisCoord(), this.axisMotion));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handlePacket(GantryContraptionUpdatePacket packet) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(packet.entityID);
        if (!(entity instanceof GantryContraptionEntity)) {
            return;
        }
        GantryContraptionEntity ce = (GantryContraptionEntity)entity;
        ce.axisMotion = packet.motion;
        ce.clientOffsetDiff = packet.coord - ce.getAxisCoord();
    }
}

