/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.mounted;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionType;
import com.simibubi.create.content.contraptions.components.structureMovement.NonStationaryLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerTileEntity;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Iterator;
import java.util.Queue;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class MountedContraption
extends Contraption {
    public CartAssemblerTileEntity.CartMovementMode rotationMode;
    public AbstractMinecartEntity connectedCart;

    public MountedContraption() {
        this(CartAssemblerTileEntity.CartMovementMode.ROTATE);
    }

    public MountedContraption(CartAssemblerTileEntity.CartMovementMode mode) {
        this.rotationMode = mode;
    }

    @Override
    protected ContraptionType getType() {
        return ContraptionType.MOUNTED;
    }

    @Override
    public boolean assemble(World world, BlockPos pos) throws AssemblyException {
        BlockState state = world.func_180495_p(pos);
        if (!state.func_235901_b_(CartAssemblerBlock.RAIL_SHAPE)) {
            return false;
        }
        if (!this.searchMovedStructure(world, pos, null)) {
            return false;
        }
        Direction.Axis axis = state.func_177229_b(CartAssemblerBlock.RAIL_SHAPE) == RailShape.EAST_WEST ? Direction.Axis.X : Direction.Axis.Z;
        this.addBlock(pos, (Pair<Template.BlockInfo, TileEntity>)Pair.of((Object)new Template.BlockInfo(pos, (BlockState)AllBlocks.MINECART_ANCHOR.getDefaultState().func_206870_a((Property)BlockStateProperties.field_208199_z, (Comparable)axis), null), null));
        return this.blocks.size() != 1;
    }

    @Override
    protected boolean addToInitialFrontier(World world, BlockPos pos, Direction direction, Queue<BlockPos> frontier) {
        frontier.clear();
        frontier.add(pos.func_177984_a());
        return true;
    }

    @Override
    protected Pair<Template.BlockInfo, TileEntity> capture(World world, BlockPos pos) {
        Pair<Template.BlockInfo, TileEntity> pair = super.capture(world, pos);
        Template.BlockInfo capture = (Template.BlockInfo)pair.getKey();
        if (!AllBlocks.CART_ASSEMBLER.has(capture.field_186243_b)) {
            return pair;
        }
        Pair anchorSwap = Pair.of((Object)new Template.BlockInfo(pos, CartAssemblerBlock.createAnchor(capture.field_186243_b), null), (Object)pair.getValue());
        if (pos.equals((Object)this.anchor) || this.connectedCart != null) {
            return anchorSwap;
        }
        for (Direction.Axis axis : Iterate.axes) {
            AbstractMinecartEntity abstractMinecartEntity;
            if (axis.func_200128_b() || !VecHelper.onSameAxis(this.anchor, pos, axis)) continue;
            Iterator iterator = world.func_217357_a(AbstractMinecartEntity.class, new AxisAlignedBB(pos)).iterator();
            while (iterator.hasNext() && CartAssemblerBlock.canAssembleTo(abstractMinecartEntity = (AbstractMinecartEntity)iterator.next())) {
                this.connectedCart = abstractMinecartEntity;
                this.connectedCart.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
            }
        }
        return anchorSwap;
    }

    @Override
    protected boolean movementAllowed(BlockState state, World world, BlockPos pos) {
        if (!pos.equals((Object)this.anchor) && AllBlocks.CART_ASSEMBLER.has(state)) {
            return this.testSecondaryCartAssembler(world, state, pos);
        }
        return super.movementAllowed(state, world, pos);
    }

    protected boolean testSecondaryCartAssembler(World world, BlockState state, BlockPos pos) {
        for (Direction.Axis axis : Iterate.axes) {
            AbstractMinecartEntity abstractMinecartEntity;
            Iterator iterator;
            if (axis.func_200128_b() || !VecHelper.onSameAxis(this.anchor, pos, axis) || !(iterator = world.func_217357_a(AbstractMinecartEntity.class, new AxisAlignedBB(pos)).iterator()).hasNext() || !CartAssemblerBlock.canAssembleTo(abstractMinecartEntity = (AbstractMinecartEntity)iterator.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompoundNBT writeNBT(boolean spawnPacket) {
        CompoundNBT tag = super.writeNBT(spawnPacket);
        NBTHelper.writeEnum(tag, "RotationMode", this.rotationMode);
        return tag;
    }

    @Override
    public void readNBT(World world, CompoundNBT nbt, boolean spawnData) {
        this.rotationMode = NBTHelper.readEnum(nbt, "RotationMode", CartAssemblerTileEntity.CartMovementMode.class);
        super.readNBT(world, nbt, spawnData);
    }

    @Override
    protected boolean customBlockPlacement(IWorld world, BlockPos pos, BlockState state) {
        return AllBlocks.MINECART_ANCHOR.has(state);
    }

    @Override
    protected boolean customBlockRemoval(IWorld world, BlockPos pos, BlockState state) {
        return AllBlocks.MINECART_ANCHOR.has(state);
    }

    @Override
    public boolean canBeStabilized(Direction facing, BlockPos localPos) {
        return true;
    }

    @Override
    public void addExtraInventories(Entity cart) {
        if (!(cart instanceof IInventory)) {
            return;
        }
        InvWrapper handlerFromInv = new InvWrapper((IInventory)cart);
        this.inventory = new CombinedInvWrapper(new IItemHandlerModifiable[]{handlerFromInv, this.inventory});
    }

    @Override
    public ContraptionLighter<?> makeLighter() {
        return new NonStationaryLighter<MountedContraption>(this);
    }
}

