/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionProgram;
import com.simibubi.create.content.contraptions.components.structureMovement.render.RenderedContraption;
import com.simibubi.create.foundation.render.AllProgramSpecs;
import com.simibubi.create.foundation.render.Compartment;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.SuperByteBufferCache;
import com.simibubi.create.foundation.render.TileEntityRenderHelper;
import com.simibubi.create.foundation.render.backend.Backend;
import com.simibubi.create.foundation.render.backend.FastRenderDispatcher;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;

public class ContraptionRenderDispatcher {
    public static final Int2ObjectMap<RenderedContraption> renderers = new Int2ObjectOpenHashMap();
    public static final Compartment<Pair<Contraption, Integer>> CONTRAPTION = new Compartment();
    protected static PlacementSimulationWorld renderWorld;

    public static void notifyLightPacket(IBlockDisplayReader world, int chunkX, int chunkZ) {
        for (RenderedContraption renderer : renderers.values()) {
            renderer.getLighter().lightVolume.notifyLightPacket(world, chunkX, chunkZ);
        }
    }

    public static void renderTileEntities(World world, Contraption c, MatrixStack ms, MatrixStack msLocal, IRenderTypeBuffer buffer) {
        PlacementSimulationWorld renderWorld = null;
        if (Backend.canUseVBOs()) {
            RenderedContraption renderer = ContraptionRenderDispatcher.getRenderer(world, c);
            renderWorld = renderer.renderWorld;
        }
        TileEntityRenderHelper.renderTileEntities(world, renderWorld, c.specialRenderedTileEntities, ms, msLocal, buffer);
    }

    public static void tick() {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        for (RenderedContraption contraption : renderers.values()) {
            contraption.getLighter().tick(contraption);
            contraption.kinetics.tick();
        }
    }

    private static RenderedContraption getRenderer(World world, Contraption c) {
        int entityId = c.entity.func_145782_y();
        RenderedContraption contraption = (RenderedContraption)renderers.get(entityId);
        if (contraption == null) {
            contraption = new RenderedContraption(world, c);
            renderers.put(entityId, (Object)contraption);
        }
        return contraption;
    }

    public static void beginFrame(ActiveRenderInfo info, double camX, double camY, double camZ) {
        for (RenderedContraption renderer : renderers.values()) {
            renderer.beginFrame(info, camX, camY, camZ);
        }
    }

    public static void renderLayer(RenderType layer, Matrix4f viewProjection, double camX, double camY, double camZ) {
        ContraptionRenderDispatcher.removeDeadContraptions();
        if (renderers.isEmpty()) {
            return;
        }
        layer.func_228547_a_();
        GL11.glEnable((int)32879);
        GL13.glActiveTexture((int)33988);
        if (Backend.canUseVBOs()) {
            ContraptionProgram structureShader = (ContraptionProgram)Backend.getProgram(AllProgramSpecs.C_STRUCTURE);
            structureShader.bind(viewProjection, camX, camY, camZ, FastRenderDispatcher.getDebugMode());
            for (RenderedContraption renderer : renderers.values()) {
                renderer.doRenderLayer(layer, structureShader);
            }
        }
        if (Backend.canUseInstancing()) {
            for (RenderedContraption renderer : renderers.values()) {
                renderer.kinetics.render(layer, viewProjection, camX, camY, camZ, renderer::setup);
                renderer.teardown();
            }
        }
        layer.func_228549_b_();
        GL11.glDisable((int)32879);
        GL13.glActiveTexture((int)33984);
    }

    public static void removeDeadContraptions() {
        renderers.values().removeIf(renderer -> {
            if (renderer.isDead()) {
                renderer.invalidate();
                return true;
            }
            return false;
        });
    }

    public static void invalidateAll() {
        for (RenderedContraption renderer : renderers.values()) {
            renderer.invalidate();
        }
        renderers.clear();
    }

    public static void render(AbstractContraptionEntity entity, MatrixStack ms, IRenderTypeBuffer buffers, MatrixStack msLocal, Contraption contraption) {
        if (Backend.canUseVBOs()) {
            ContraptionRenderDispatcher.renderDynamic(entity.field_70170_p, contraption, ms, msLocal, buffers);
        } else {
            ContraptionRenderDispatcher.renderDynamic(entity.field_70170_p, contraption, ms, msLocal, buffers);
            ContraptionRenderDispatcher.renderStructure(entity.field_70170_p, contraption, ms, msLocal, buffers);
        }
    }

    public static void renderDynamic(World world, Contraption c, MatrixStack ms, MatrixStack msLocal, IRenderTypeBuffer buffer) {
        ContraptionRenderDispatcher.renderTileEntities(world, c, ms, msLocal, buffer);
        if (buffer instanceof IRenderTypeBuffer.Impl) {
            ((IRenderTypeBuffer.Impl)buffer).func_228461_a_();
        }
        ContraptionRenderDispatcher.renderActors(world, c, ms, msLocal, buffer);
    }

    public static void renderStructure(World world, Contraption c, MatrixStack ms, MatrixStack msLocal, IRenderTypeBuffer buffer) {
        SuperByteBufferCache bufferCache = CreateClient.bufferCache;
        List blockLayers = RenderType.func_228661_n_();
        buffer.getBuffer(RenderType.func_228639_c_());
        for (int i = 0; i < blockLayers.size(); ++i) {
            RenderType layer = (RenderType)blockLayers.get(i);
            Pair key = Pair.of((Object)c, (Object)i);
            SuperByteBuffer contraptionBuffer = bufferCache.get(CONTRAPTION, key, () -> ContraptionRenderDispatcher.buildStructureBuffer(c, layer));
            if (contraptionBuffer.isEmpty()) continue;
            Matrix4f model = msLocal.func_227866_c_().func_227870_a_();
            contraptionBuffer.light(model).renderInto(ms, buffer.getBuffer(layer));
        }
    }

    private static SuperByteBuffer buildStructureBuffer(Contraption c, RenderType layer) {
        BufferBuilder builder = ContraptionRenderDispatcher.buildStructure(c, layer);
        return new SuperByteBuffer(builder);
    }

    public static BufferBuilder buildStructure(Contraption c, RenderType layer) {
        if (renderWorld == null || renderWorld.getWorld() != Minecraft.func_71410_x().field_71441_e) {
            renderWorld = new PlacementSimulationWorld((World)Minecraft.func_71410_x().field_71441_e);
        }
        ForgeHooksClient.setRenderLayer((RenderType)layer);
        MatrixStack ms = new MatrixStack();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        BlockModelRenderer blockRenderer = dispatcher.func_175019_b();
        Random random = new Random();
        BufferBuilder builder = new BufferBuilder(DefaultVertexFormats.field_176600_a.func_181719_f());
        builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        renderWorld.setTileEntities(c.presentTileEntities.values());
        for (Template.BlockInfo info : c.getBlocks().values()) {
            renderWorld.func_175656_a(info.field_186242_a, info.field_186243_b);
        }
        for (Template.BlockInfo info : c.getBlocks().values()) {
            BlockState state = info.field_186243_b;
            if (state.func_185901_i() == BlockRenderType.ENTITYBLOCK_ANIMATED || !RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)layer)) continue;
            IBakedModel originalModel = dispatcher.func_184389_a(state);
            ms.func_227860_a_();
            ms.func_227861_a_((double)info.field_186242_a.func_177958_n(), (double)info.field_186242_a.func_177956_o(), (double)info.field_186242_a.func_177952_p());
            blockRenderer.renderModel((IBlockDisplayReader)renderWorld, originalModel, state, info.field_186242_a, ms, (IVertexBuilder)builder, true, random, 42L, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
            ms.func_227865_b_();
        }
        builder.func_178977_d();
        renderWorld.clear();
        renderWorld = null;
        return builder;
    }

    protected static void renderActors(World world, Contraption c, MatrixStack ms, MatrixStack msLocal, IRenderTypeBuffer buffer) {
        MatrixStack[] matrixStacks = new MatrixStack[]{ms, msLocal};
        for (Pair pair : c.getActors()) {
            MovementContext context = (MovementContext)pair.getRight();
            if (context == null) continue;
            if (context.world == null) {
                context.world = world;
            }
            Template.BlockInfo blockInfo = (Template.BlockInfo)pair.getLeft();
            for (MatrixStack m : matrixStacks) {
                m.func_227860_a_();
                MatrixStacker.of(m).translate((Vector3i)blockInfo.field_186242_a);
            }
            MovementBehaviour movementBehaviour = AllMovementBehaviours.of(blockInfo.field_186243_b);
            if (movementBehaviour != null) {
                movementBehaviour.renderInContraption(context, ms, msLocal, buffer);
            }
            for (MatrixStack m : matrixStacks) {
                m.func_227865_b_();
            }
        }
    }

    public static int getLight(World world, float lx, float ly, float lz) {
        float offset;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        float sky = 0.0f;
        float block = 0.0f;
        for (float zOffset = offset = 0.125f; zOffset >= -offset; zOffset -= 2.0f * offset) {
            for (float yOffset = offset; yOffset >= -offset; yOffset -= 2.0f * offset) {
                for (float xOffset = offset; xOffset >= -offset; xOffset -= 2.0f * offset) {
                    pos.func_189532_c((double)(lx + xOffset), (double)(ly + yOffset), (double)(lz + zOffset));
                    sky += (float)world.func_226658_a_(LightType.SKY, (BlockPos)pos) / 8.0f;
                    block += (float)world.func_226658_a_(LightType.BLOCK, (BlockPos)pos) / 8.0f;
                }
            }
        }
        return (int)sky << 20 | (int)block << 4;
    }

    public static int getLightOnContraption(World world, PlacementSimulationWorld renderWorld, BlockPos pos, BlockPos lightPos) {
        int worldLight = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)lightPos);
        if (renderWorld != null) {
            return ContraptionRenderDispatcher.getMaxBlockLight(worldLight, renderWorld.func_226658_a_(LightType.BLOCK, pos));
        }
        return worldLight;
    }

    public static int getMaxBlockLight(int packedLight, int blockLightValue) {
        int unpackedBlockLight = LightTexture.func_228450_a_((int)packedLight);
        if (blockLightValue > unpackedBlockLight) {
            packedLight = packedLight & 0xFFFF0000 | blockLightValue << 4;
        }
        return packedLight;
    }

    public static int getLightOnContraption(MovementContext context) {
        int entityId = context.contraption.entity.func_145782_y();
        RenderedContraption renderedContraption = (RenderedContraption)renderers.get(entityId);
        if (renderedContraption != null) {
            return renderedContraption.renderWorld.func_226658_a_(LightType.BLOCK, context.localPos);
        }
        return -1;
    }
}

