/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.train.capability;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartControllerUpdatePacket;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class MinecartController
implements INBTSerializable<CompoundNBT> {
    public static MinecartController EMPTY;
    private boolean needsEntryRefresh;
    private WeakReference<AbstractMinecartEntity> weakRef;
    private Couple<Optional<StallData>> stallData;
    private Couple<Optional<CouplingData>> couplings;

    public MinecartController(AbstractMinecartEntity minecart) {
        this.weakRef = new WeakReference<AbstractMinecartEntity>(minecart);
        this.stallData = Couple.create(Optional::empty);
        this.couplings = Couple.create(Optional::empty);
        this.needsEntryRefresh = true;
    }

    public void tick() {
        AbstractMinecartEntity cart = this.cart();
        World world = this.getWorld();
        if (this.needsEntryRefresh) {
            CapabilityMinecartController.queuedAdditions.get((IWorld)world).add(cart);
            this.needsEntryRefresh = false;
        }
        this.stallData.forEach(opt -> opt.ifPresent(sd -> sd.tick(cart)));
        MutableBoolean internalStall = new MutableBoolean(false);
        this.couplings.forEachWithContext((opt, main) -> opt.ifPresent(cd -> {
            UUID idOfOther = cd.idOfCart(main == false);
            MinecartController otherCart = CapabilityMinecartController.getIfPresent(world, idOfOther);
            internalStall.setValue(internalStall.booleanValue() || otherCart == null || !otherCart.isPresent() || otherCart.isStalled(false));
        }));
        if (!world.field_72995_K) {
            this.setStalled(internalStall.booleanValue(), true);
            this.disassemble(cart);
        }
    }

    private void disassemble(AbstractMinecartEntity cart) {
        int k;
        int j;
        if (cart instanceof MinecartEntity) {
            return;
        }
        List passengers = cart.func_184188_bt();
        if (passengers.isEmpty() || !(passengers.get(0) instanceof AbstractContraptionEntity)) {
            return;
        }
        World world = cart.field_70170_p;
        int i = MathHelper.func_76128_c((double)cart.func_226277_ct_());
        if (world.func_180495_p(new BlockPos(i, (j = MathHelper.func_76128_c((double)cart.func_226278_cu_())) - 1, k = MathHelper.func_76128_c((double)cart.func_226281_cx_()))).func_235714_a_((ITag)BlockTags.field_203437_y)) {
            --j;
        }
        BlockPos blockpos = new BlockPos(i, j, k);
        BlockState blockstate = world.func_180495_p(blockpos);
        if (cart.canUseRail() && blockstate.func_235714_a_((ITag)BlockTags.field_203437_y) && blockstate.func_177230_c() instanceof PoweredRailBlock && ((PoweredRailBlock)blockstate.func_177230_c()).isActivatorRail()) {
            if (cart.func_184207_aI()) {
                cart.func_184226_ay();
            }
            if (cart.func_70496_j() == 0) {
                cart.func_70494_i(-cart.func_70493_k());
                cart.func_70497_h(10);
                cart.func_70492_c(50.0f);
                cart.field_70133_I = true;
            }
        }
    }

    public boolean isFullyCoupled() {
        return this.isLeadingCoupling() && this.isConnectedToCoupling();
    }

    public boolean isLeadingCoupling() {
        return this.couplings.get(true).isPresent();
    }

    public boolean isConnectedToCoupling() {
        return this.couplings.get(false).isPresent();
    }

    public boolean isCoupledThroughContraption() {
        for (boolean current : Iterate.trueAndFalse) {
            if (!this.hasContraptionCoupling(current)) continue;
            return true;
        }
        return false;
    }

    public boolean hasContraptionCoupling(boolean current) {
        Optional<CouplingData> optional = this.couplings.get(current);
        return optional.isPresent() && optional.get().contraption;
    }

    public float getCouplingLength(boolean leading) {
        Optional<CouplingData> optional = this.couplings.get(leading);
        if (optional.isPresent()) {
            return optional.get().length;
        }
        return 0.0f;
    }

    public void decouple() {
        this.couplings.forEachWithContext((opt, main) -> opt.ifPresent(cd -> {
            UUID idOfOther = cd.idOfCart(main == false);
            MinecartController otherCart = CapabilityMinecartController.getIfPresent(this.getWorld(), idOfOther);
            if (otherCart == null) {
                return;
            }
            this.removeConnection((boolean)main);
            otherCart.removeConnection(main == false);
        }));
    }

    public void removeConnection(boolean main) {
        Entity entity;
        List passengers;
        if (this.hasContraptionCoupling(main) && !this.getWorld().field_72995_K && !(passengers = this.cart().func_184188_bt()).isEmpty() && (entity = (Entity)passengers.get(0)) instanceof AbstractContraptionEntity) {
            ((AbstractContraptionEntity)entity).disassemble();
        }
        this.couplings.set(main, Optional.empty());
        this.needsEntryRefresh |= main;
        this.sendData();
    }

    public void prepareForCoupling(boolean isLeading) {
        if (isLeading && this.isLeadingCoupling() || !isLeading && this.isConnectedToCoupling()) {
            ArrayList<MinecartController> cartsToFlip = new ArrayList<MinecartController>();
            MinecartController current = this;
            boolean forward = current.isLeadingCoupling();
            int safetyCount = 1000;
            do {
                if (safetyCount-- <= 0) {
                    Create.logger.warn("Infinite loop in coupling iteration");
                    return;
                }
                cartsToFlip.add(current);
            } while ((current = CouplingHandler.getNextInCouplingChain(this.getWorld(), current, forward)) != null && current != EMPTY);
            Iterator iterator = cartsToFlip.iterator();
            while (iterator.hasNext()) {
                MinecartController minecartController;
                MinecartController mc = minecartController = (MinecartController)iterator.next();
                mc.couplings.forEachWithContext((opt, leading) -> opt.ifPresent(cd -> {
                    cd.flip();
                    if (!((CouplingData)cd).contraption) {
                        return;
                    }
                    List passengers = mc.cart().func_184188_bt();
                    if (passengers.isEmpty()) {
                        return;
                    }
                    Entity entity = (Entity)passengers.get(0);
                    if (!(entity instanceof OrientedContraptionEntity)) {
                        return;
                    }
                    OrientedContraptionEntity contraption = (OrientedContraptionEntity)entity;
                    UUID couplingId = contraption.getCouplingId();
                    if (couplingId == ((CouplingData)cd).mainCartID) {
                        contraption.setCouplingId(((CouplingData)cd).connectedCartID);
                        return;
                    }
                    if (couplingId == ((CouplingData)cd).connectedCartID) {
                        contraption.setCouplingId(((CouplingData)cd).mainCartID);
                        return;
                    }
                }));
                mc.couplings = mc.couplings.swap();
                mc.needsEntryRefresh = true;
                if (mc == this) continue;
                mc.sendData();
            }
        }
    }

    public void coupleWith(boolean isLeading, UUID coupled, float length, boolean contraption) {
        UUID mainID = isLeading ? this.cart().func_110124_au() : coupled;
        UUID connectedID = isLeading ? coupled : this.cart().func_110124_au();
        this.couplings.set(isLeading, Optional.of(new CouplingData(mainID, connectedID, length, contraption)));
        this.needsEntryRefresh |= isLeading;
        this.sendData();
    }

    @Nullable
    public UUID getCoupledCart(boolean asMain) {
        Optional<CouplingData> optional = this.couplings.get(asMain);
        if (!optional.isPresent()) {
            return null;
        }
        CouplingData couplingData = optional.get();
        return asMain ? couplingData.connectedCartID : couplingData.mainCartID;
    }

    public boolean isStalled() {
        return this.isStalled(true) || this.isStalled(false);
    }

    private boolean isStalled(boolean internal) {
        return this.stallData.get(internal).isPresent();
    }

    public void setStalledExternally(boolean stall) {
        this.setStalled(stall, false);
    }

    private void setStalled(boolean stall, boolean internal) {
        if (this.isStalled(internal) == stall) {
            return;
        }
        AbstractMinecartEntity cart = this.cart();
        if (stall) {
            this.stallData.set(internal, Optional.of(new StallData(cart)));
            this.sendData();
            return;
        }
        if (!this.isStalled(!internal)) {
            this.stallData.get(internal).get().release(cart);
        }
        this.stallData.set(internal, Optional.empty());
        this.sendData();
    }

    public void sendData() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(this::cart), (Object)new MinecartControllerUpdatePacket(this));
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        this.stallData.forEachWithContext((opt, internal) -> opt.ifPresent(sd -> compoundNBT.func_218657_a(internal != false ? "InternalStallData" : "StallData", (INBT)sd.serialize())));
        this.couplings.forEachWithContext((opt, main) -> opt.ifPresent(cd -> compoundNBT.func_218657_a(main != false ? "MainCoupling" : "ConnectedCoupling", (INBT)cd.serialize())));
        return compoundNBT;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        Optional<Object> internalSD = Optional.empty();
        Optional<Object> externalSD = Optional.empty();
        Optional<Object> mainCD = Optional.empty();
        Optional<Object> connectedCD = Optional.empty();
        if (nbt.func_74764_b("InternalStallData")) {
            internalSD = Optional.of(StallData.read(nbt.func_74775_l("InternalStallData")));
        }
        if (nbt.func_74764_b("StallData")) {
            externalSD = Optional.of(StallData.read(nbt.func_74775_l("StallData")));
        }
        if (nbt.func_74764_b("MainCoupling")) {
            mainCD = Optional.of(CouplingData.read(nbt.func_74775_l("MainCoupling")));
        }
        if (nbt.func_74764_b("ConnectedCoupling")) {
            connectedCD = Optional.of(CouplingData.read(nbt.func_74775_l("ConnectedCoupling")));
        }
        this.stallData = Couple.create(internalSD, externalSD);
        this.couplings = Couple.create(mainCD, connectedCD);
        this.needsEntryRefresh = true;
    }

    public boolean isPresent() {
        return this.weakRef.get() != null && this.cart().func_70089_S();
    }

    public AbstractMinecartEntity cart() {
        return (AbstractMinecartEntity)this.weakRef.get();
    }

    public static MinecartController empty() {
        return EMPTY != null ? EMPTY : (EMPTY = new MinecartController(null));
    }

    private World getWorld() {
        return this.cart().func_130014_f_();
    }

    private static class StallData {
        Vector3d position;
        Vector3d motion;
        float yaw;
        float pitch;

        private StallData() {
        }

        StallData(AbstractMinecartEntity entity) {
            this.position = entity.func_213303_ch();
            this.motion = entity.func_213322_ci();
            this.yaw = entity.field_70177_z;
            this.pitch = entity.field_70125_A;
            this.tick(entity);
        }

        void tick(AbstractMinecartEntity entity) {
            entity.func_70107_b(this.position.field_72450_a, this.position.field_72448_b, this.position.field_72449_c);
            entity.func_213317_d(Vector3d.field_186680_a);
            entity.field_70177_z = this.yaw;
            entity.field_70125_A = this.pitch;
        }

        void release(AbstractMinecartEntity entity) {
            entity.func_213317_d(this.motion);
        }

        CompoundNBT serialize() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a("Pos", (INBT)VecHelper.writeNBT(this.position));
            nbt.func_218657_a("Motion", (INBT)VecHelper.writeNBT(this.motion));
            nbt.func_74776_a("Yaw", this.yaw);
            nbt.func_74776_a("Pitch", this.pitch);
            return nbt;
        }

        static StallData read(CompoundNBT nbt) {
            StallData stallData = new StallData();
            stallData.position = VecHelper.readNBT(nbt.func_150295_c("Pos", 6));
            stallData.motion = VecHelper.readNBT(nbt.func_150295_c("Motion", 6));
            stallData.yaw = nbt.func_74760_g("Yaw");
            stallData.pitch = nbt.func_74760_g("Pitch");
            return stallData;
        }
    }

    private static class CouplingData {
        private UUID mainCartID;
        private UUID connectedCartID;
        private float length;
        private boolean contraption;

        public CouplingData(UUID mainCartID, UUID connectedCartID, float length, boolean contraption) {
            this.mainCartID = mainCartID;
            this.connectedCartID = connectedCartID;
            this.length = length;
            this.contraption = contraption;
        }

        void flip() {
            UUID swap = this.mainCartID;
            this.mainCartID = this.connectedCartID;
            this.connectedCartID = swap;
        }

        CompoundNBT serialize() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a("Main", (INBT)NBTUtil.func_240626_a_((UUID)this.mainCartID));
            nbt.func_218657_a("Connected", (INBT)NBTUtil.func_240626_a_((UUID)this.connectedCartID));
            nbt.func_74776_a("Length", this.length);
            nbt.func_74757_a("Contraption", this.contraption);
            return nbt;
        }

        static CouplingData read(CompoundNBT nbt) {
            UUID mainCartID = NBTUtil.func_186860_b((INBT)NBTHelper.getINBT(nbt, "Main"));
            UUID connectedCartID = NBTUtil.func_186860_b((INBT)NBTHelper.getINBT(nbt, "Connected"));
            float length = nbt.func_74760_g("Length");
            boolean contraption = nbt.func_74767_n("Contraption");
            return new CouplingData(mainCartID, connectedCartID, length, contraption);
        }

        public UUID idOfCart(boolean main) {
            return main ? this.mainCartID : this.connectedCartID;
        }
    }
}

