/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.fluids.FluidReactions;
import com.simibubi.create.content.contraptions.fluids.PipeConnection;
import com.simibubi.create.content.contraptions.fluids.PumpBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public abstract class FluidTransportBehaviour
extends TileEntityBehaviour {
    public static BehaviourType<FluidTransportBehaviour> TYPE = new BehaviourType();
    Map<Direction, PipeConnection> interfaces;
    UpdatePhase phase = UpdatePhase.WAIT_FOR_PUMPS;

    public FluidTransportBehaviour(SmartTileEntity te) {
        super(te);
    }

    public boolean canPullFluidFrom(FluidStack fluid, BlockState state, Direction direction) {
        return true;
    }

    public abstract boolean canHaveFlowToward(BlockState var1, Direction var2);

    @Override
    public void initialize() {
        super.initialize();
        this.createConnectionData();
    }

    @Override
    public void tick() {
        super.tick();
        World world = this.getWorld();
        BlockPos pos = this.getPos();
        boolean onClient = world.field_72995_K;
        if (this.interfaces == null) {
            return;
        }
        Collection<PipeConnection> connections = this.interfaces.values();
        PipeConnection singleSource = null;
        if (this.phase == UpdatePhase.WAIT_FOR_PUMPS) {
            this.phase = UpdatePhase.FLIP_FLOWS;
            return;
        }
        if (!onClient) {
            boolean sendUpdate = false;
            for (PipeConnection pipeConnection : connections) {
                sendUpdate |= pipeConnection.flipFlowsIfPressureReversed();
                pipeConnection.manageSource(world, pos);
            }
            if (sendUpdate) {
                this.tileEntity.notifyUpdate();
            }
        }
        if (this.phase == UpdatePhase.FLIP_FLOWS) {
            this.phase = UpdatePhase.IDLE;
            return;
        }
        if (!onClient) {
            int n;
            FluidStack availableFlow = FluidStack.EMPTY;
            FluidStack collidingFlow = FluidStack.EMPTY;
            for (PipeConnection connection : connections) {
                FluidStack fluidInFlow = connection.getProvidedFluid();
                if (fluidInFlow.isEmpty()) continue;
                if (availableFlow.isEmpty()) {
                    singleSource = connection;
                    availableFlow = fluidInFlow;
                    continue;
                }
                if (availableFlow.isFluidEqual(fluidInFlow)) {
                    singleSource = null;
                    availableFlow = fluidInFlow;
                    continue;
                }
                collidingFlow = fluidInFlow;
                break;
            }
            if (!collidingFlow.isEmpty()) {
                FluidReactions.handlePipeFlowCollision(world, pos, availableFlow, collidingFlow);
                return;
            }
            boolean bl = false;
            for (PipeConnection connection : connections) {
                FluidStack internalFluid = singleSource != connection ? availableFlow : FluidStack.EMPTY;
                Predicate<FluidStack> extractionPredicate = extracted -> this.canPullFluidFrom((FluidStack)extracted, this.tileEntity.func_195044_w(), connection.side);
                n |= connection.manageFlows(world, pos, internalFluid, extractionPredicate);
            }
            if (n != 0) {
                this.tileEntity.notifyUpdate();
            }
        }
        for (PipeConnection connection : connections) {
            connection.tickFlowProgress(world, pos);
        }
    }

    @Override
    public void read(CompoundNBT nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (this.interfaces == null) {
            this.interfaces = new IdentityHashMap<Direction, PipeConnection>();
        }
        for (Direction face : Iterate.directions) {
            if (!nbt.func_74764_b(face.func_176742_j())) continue;
            this.interfaces.computeIfAbsent(face, d -> new PipeConnection((Direction)d));
        }
        if (this.interfaces.isEmpty()) {
            this.interfaces = null;
            return;
        }
        this.interfaces.values().forEach(connection -> connection.deserializeNBT(nbt, clientPacket));
    }

    @Override
    public void write(CompoundNBT nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        if (clientPacket) {
            this.createConnectionData();
        }
        if (this.interfaces == null) {
            return;
        }
        this.interfaces.values().forEach(connection -> connection.serializeNBT(nbt, clientPacket));
    }

    public FluidStack getProvidedOutwardFluid(Direction side) {
        this.createConnectionData();
        if (!this.interfaces.containsKey(side)) {
            return FluidStack.EMPTY;
        }
        return this.interfaces.get(side).provideOutboundFlow();
    }

    @Nullable
    public PipeConnection getConnection(Direction side) {
        this.createConnectionData();
        return this.interfaces.get(side);
    }

    public boolean hasAnyPressure() {
        this.createConnectionData();
        for (PipeConnection pipeConnection : this.interfaces.values()) {
            if (!pipeConnection.hasPressure()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public PipeConnection.Flow getFlow(Direction side) {
        this.createConnectionData();
        if (!this.interfaces.containsKey(side)) {
            return null;
        }
        return this.interfaces.get((Object)side).flow.orElse(null);
    }

    public void addPressure(Direction side, boolean inbound, float pressure) {
        this.createConnectionData();
        if (!this.interfaces.containsKey(side)) {
            return;
        }
        this.interfaces.get(side).addPressure(inbound, pressure);
        this.tileEntity.sendData();
    }

    public void wipePressure() {
        if (this.interfaces != null) {
            for (Direction d : Iterate.directions) {
                if (!this.canHaveFlowToward(this.tileEntity.func_195044_w(), d)) {
                    this.interfaces.remove(d);
                    continue;
                }
                this.interfaces.computeIfAbsent(d, PipeConnection::new);
            }
        }
        this.phase = UpdatePhase.WAIT_FOR_PUMPS;
        this.createConnectionData();
        this.interfaces.values().forEach(PipeConnection::wipePressure);
        this.tileEntity.sendData();
    }

    private void createConnectionData() {
        if (this.interfaces != null) {
            return;
        }
        this.interfaces = new IdentityHashMap<Direction, PipeConnection>();
        for (Direction d : Iterate.directions) {
            if (!this.canHaveFlowToward(this.tileEntity.func_195044_w(), d)) continue;
            this.interfaces.put(d, new PipeConnection(d));
        }
    }

    public AttachmentTypes getRenderedRimAttachment(IBlockDisplayReader world, BlockPos pos, BlockState state, Direction direction) {
        if (!this.canHaveFlowToward(state, direction)) {
            return AttachmentTypes.NONE;
        }
        BlockPos offsetPos = pos.func_177972_a(direction);
        BlockState facingState = world.func_180495_p(offsetPos);
        if (facingState.func_177230_c() instanceof PumpBlock && ((Direction)facingState.func_177229_b((Property)PumpBlock.FACING)).func_176740_k() == direction.func_176740_k()) {
            return AttachmentTypes.NONE;
        }
        if (AllBlocks.ENCASED_FLUID_PIPE.has(facingState) && ((Boolean)facingState.func_177229_b((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(direction.func_176734_d()))).booleanValue()) {
            return AttachmentTypes.NONE;
        }
        if (FluidPropagator.hasFluidCapability((IBlockReader)world, offsetPos, direction.func_176734_d()) && !AllBlocks.HOSE_PULLEY.has(facingState)) {
            return AttachmentTypes.DRAIN;
        }
        return AttachmentTypes.RIM;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public static enum AttachmentTypes {
        NONE,
        RIM,
        DRAIN;


        public boolean hasModel() {
            return this != NONE;
        }
    }

    static enum UpdatePhase {
        WAIT_FOR_PUMPS,
        FLIP_FLOWS,
        IDLE;

    }
}

