/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.contraptions.fluids.PipeConnection;
import com.simibubi.create.content.contraptions.fluids.PumpBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class PumpTileEntity
extends KineticTileEntity {
    LerpedFloat arrowDirection = LerpedFloat.linear().startWithValue(1.0);
    Couple<MutableBoolean> sidesToUpdate = Couple.create(MutableBoolean::new);
    boolean reversed;

    public PumpTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add(new PumpFluidTransferBehaviour(this));
    }

    @Override
    public void initialize() {
        super.initialize();
        this.reversed = this.getSpeed() < 0.0f;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        float speed = this.getSpeed();
        if (this.field_145850_b.field_72995_K) {
            if (speed == 0.0f) {
                return;
            }
            this.arrowDirection.chase(speed >= 0.0f ? 1.0 : -1.0, 0.5, LerpedFloat.Chaser.EXP);
            this.arrowDirection.tickChaser();
            return;
        }
        this.sidesToUpdate.forEachWithContext((update, isFront) -> {
            if (update.isFalse()) {
                return;
            }
            update.setFalse();
            this.distributePressureTo(isFront != false ? this.getFront() : this.getFront().func_176734_d());
        });
        if (speed == 0.0f) {
            return;
        }
        if (speed < 0.0f != this.reversed) {
            this.reversed = speed < 0.0f;
            return;
        }
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (previousSpeed == this.getSpeed()) {
            return;
        }
        if (this.speed != 0.0f) {
            boolean bl = this.reversed = this.speed < 0.0f;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockPos frontPos = this.field_174879_c.func_177972_a(this.getFront());
        BlockPos backPos = this.field_174879_c.func_177972_a(this.getFront().func_176734_d());
        FluidPropagator.propagateChangedPipe((IWorld)this.field_145850_b, frontPos, this.field_145850_b.func_180495_p(frontPos));
        FluidPropagator.propagateChangedPipe((IWorld)this.field_145850_b, backPos, this.field_145850_b.func_180495_p(backPos));
    }

    protected void distributePressureTo(Direction side) {
        if (this.getSpeed() == 0.0f) {
            return;
        }
        BlockFace start = new BlockFace(this.field_174879_c, side);
        boolean pull = this.isPullingOnSide(this.isFront(side));
        HashSet<BlockFace> targets = new HashSet<BlockFace>();
        HashMap<BlockPos, Pair<Integer, Map<Direction, Boolean>>> pipeGraph = new HashMap<BlockPos, Pair<Integer, Map<Direction, Boolean>>>();
        if (!pull) {
            FluidPropagator.resetAffectedFluidNetworks(this.field_145850_b, this.field_174879_c, side.func_176734_d());
        }
        if (!this.hasReachedValidEndpoint((IWorld)this.field_145850_b, start, pull)) {
            ((Map)pipeGraph.computeIfAbsent(this.field_174879_c, $ -> Pair.of(0, new IdentityHashMap())).getSecond()).put(side, pull);
            ((Map)pipeGraph.computeIfAbsent(start.getConnectedPos(), $ -> Pair.of(1, new IdentityHashMap())).getSecond()).put(side.func_176734_d(), !pull);
            ArrayList<Pair<Integer, BlockPos>> frontier = new ArrayList<Pair<Integer, BlockPos>>();
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            int maxDistance = FluidPropagator.getPumpRange();
            frontier.add(Pair.of(1, start.getConnectedPos()));
            while (!frontier.isEmpty()) {
                Pair entry = (Pair)frontier.remove(0);
                int distance = (Integer)entry.getFirst();
                BlockPos currentPos = (BlockPos)entry.getSecond();
                if (!this.field_145850_b.isAreaLoaded(currentPos, 0) || visited.contains(currentPos)) continue;
                visited.add(currentPos);
                BlockState currentState = this.field_145850_b.func_180495_p(currentPos);
                FluidTransportBehaviour pipe = FluidPropagator.getPipe((IBlockReader)this.field_145850_b, currentPos);
                if (pipe == null) continue;
                for (Direction face : FluidPropagator.getPipeConnections(currentState, pipe)) {
                    BlockFace blockFace = new BlockFace(currentPos, face);
                    BlockPos connectedPos = blockFace.getConnectedPos();
                    if (!this.field_145850_b.isAreaLoaded(connectedPos, 0) || blockFace.isEquivalent(start)) continue;
                    if (this.hasReachedValidEndpoint((IWorld)this.field_145850_b, blockFace, pull)) {
                        ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of(distance, new IdentityHashMap())).getSecond()).put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }
                    FluidTransportBehaviour pipeBehaviour = FluidPropagator.getPipe((IBlockReader)this.field_145850_b, connectedPos);
                    if (pipeBehaviour == null || pipeBehaviour instanceof PumpFluidTransferBehaviour || visited.contains(connectedPos)) continue;
                    if (distance + 1 >= maxDistance) {
                        ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of(distance, new IdentityHashMap())).getSecond()).put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }
                    ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of(distance, new IdentityHashMap())).getSecond()).put(face, pull);
                    ((Map)pipeGraph.computeIfAbsent(connectedPos, $ -> Pair.of(distance + 1, new IdentityHashMap())).getSecond()).put(face.func_176734_d(), !pull);
                    frontier.add(Pair.of(distance + 1, connectedPos));
                }
            }
        }
        HashMap<Integer, Set<BlockFace>> validFaces = new HashMap<Integer, Set<BlockFace>>();
        this.searchForEndpointRecursively(pipeGraph, targets, validFaces, new BlockFace(start.getPos(), start.getOppositeFace()), pull);
        float pressure = Math.abs(this.getSpeed());
        for (Set set : validFaces.values()) {
            int parallelBranches = set.size();
            for (BlockFace face : set) {
                BlockPos pipePos = face.getPos();
                Direction pipeSide = face.getFace();
                if (pipePos.equals((Object)this.field_174879_c)) continue;
                boolean inbound = (Boolean)((Map)((Pair)pipeGraph.get(pipePos)).getSecond()).get(pipeSide);
                FluidTransportBehaviour pipeBehaviour = FluidPropagator.getPipe((IBlockReader)this.field_145850_b, pipePos);
                if (pipeBehaviour == null) continue;
                pipeBehaviour.addPressure(pipeSide, inbound, pressure / (float)parallelBranches);
            }
        }
    }

    protected boolean searchForEndpointRecursively(Map<BlockPos, Pair<Integer, Map<Direction, Boolean>>> pipeGraph, Set<BlockFace> targets, Map<Integer, Set<BlockFace>> validFaces, BlockFace currentFace, boolean pull) {
        BlockPos currentPos = currentFace.getPos();
        if (!pipeGraph.containsKey(currentPos)) {
            return false;
        }
        Pair<Integer, Map<Direction, Boolean>> pair = pipeGraph.get(currentPos);
        int distance = pair.getFirst();
        boolean atLeastOneBranchSuccessful = false;
        for (Direction nextFacing : Iterate.directions) {
            Map<Direction, Boolean> map;
            if (nextFacing == currentFace.getFace() || !(map = pair.getSecond()).containsKey(nextFacing)) continue;
            BlockFace localTarget = new BlockFace(currentPos, nextFacing);
            if (targets.contains(localTarget)) {
                validFaces.computeIfAbsent(distance, $ -> new HashSet()).add(localTarget);
                atLeastOneBranchSuccessful = true;
                continue;
            }
            if (map.get(nextFacing) != pull || !this.searchForEndpointRecursively(pipeGraph, targets, validFaces, new BlockFace(currentPos.func_177972_a(nextFacing), nextFacing.func_176734_d()), pull)) continue;
            validFaces.computeIfAbsent(distance, $ -> new HashSet()).add(localTarget);
            atLeastOneBranchSuccessful = true;
        }
        if (atLeastOneBranchSuccessful) {
            validFaces.computeIfAbsent(distance, $ -> new HashSet()).add(currentFace);
        }
        return atLeastOneBranchSuccessful;
    }

    private boolean hasReachedValidEndpoint(IWorld world, BlockFace blockFace, boolean pull) {
        LazyOptional capability;
        BlockPos connectedPos = blockFace.getConnectedPos();
        BlockState connectedState = world.func_180495_p(connectedPos);
        TileEntity tileEntity = world.func_175625_s(connectedPos);
        Direction face = blockFace.getFace();
        if (PumpBlock.isPump(connectedState) && ((Direction)connectedState.func_177229_b((Property)PumpBlock.FACING)).func_176740_k() == face.func_176740_k() && tileEntity instanceof PumpTileEntity) {
            PumpTileEntity pumpTE = (PumpTileEntity)tileEntity;
            return pumpTE.isPullingOnSide(pumpTE.isFront(blockFace.getOppositeFace())) != pull;
        }
        FluidTransportBehaviour pipe = FluidPropagator.getPipe((IBlockReader)world, connectedPos);
        if (pipe != null && pipe.canHaveFlowToward(connectedState, blockFace.getOppositeFace())) {
            return false;
        }
        if (tileEntity != null && (capability = tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d())).isPresent()) {
            return true;
        }
        return FluidPropagator.isOpenEnd((IBlockReader)world, blockFace.getPos(), face);
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74757_a("Reversed", this.reversed);
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        this.reversed = compound.func_74767_n("Reversed");
        super.fromTag(state, compound, clientPacket);
    }

    public void updatePipesOnSide(Direction side) {
        if (!this.isSideAccessible(side)) {
            return;
        }
        this.updatePipeNetwork(this.isFront(side));
        this.getBehaviour(FluidTransportBehaviour.TYPE).wipePressure();
    }

    protected boolean isFront(Direction side) {
        BlockState blockState = this.func_195044_w();
        if (!(blockState.func_177230_c() instanceof PumpBlock)) {
            return false;
        }
        Direction front = (Direction)blockState.func_177229_b((Property)PumpBlock.FACING);
        boolean isFront = side == front;
        return isFront;
    }

    @Nullable
    protected Direction getFront() {
        BlockState blockState = this.func_195044_w();
        if (!(blockState.func_177230_c() instanceof PumpBlock)) {
            return null;
        }
        return (Direction)blockState.func_177229_b((Property)PumpBlock.FACING);
    }

    protected void updatePipeNetwork(boolean front) {
        this.sidesToUpdate.get(front).setTrue();
    }

    public boolean isSideAccessible(Direction side) {
        BlockState blockState = this.func_195044_w();
        if (!(blockState.func_177230_c() instanceof PumpBlock)) {
            return false;
        }
        return ((Direction)blockState.func_177229_b((Property)PumpBlock.FACING)).func_176740_k() == side.func_176740_k();
    }

    public boolean isPullingOnSide(boolean front) {
        return front == this.reversed;
    }

    @Override
    public boolean shouldRenderAsTE() {
        return true;
    }

    class PumpFluidTransferBehaviour
    extends FluidTransportBehaviour {
        public PumpFluidTransferBehaviour(SmartTileEntity te) {
            super(te);
        }

        @Override
        public void tick() {
            super.tick();
            for (Map.Entry entry : this.interfaces.entrySet()) {
                boolean pull = PumpTileEntity.this.isPullingOnSide(PumpTileEntity.this.isFront((Direction)entry.getKey()));
                Couple<Float> pressure = ((PipeConnection)entry.getValue()).pressure;
                pressure.set(pull, Float.valueOf(Math.abs(PumpTileEntity.this.getSpeed())));
                pressure.set(!pull, Float.valueOf(0.0f));
            }
        }

        @Override
        public boolean canHaveFlowToward(BlockState state, Direction direction) {
            return PumpTileEntity.this.isSideAccessible(direction);
        }

        @Override
        public FluidTransportBehaviour.AttachmentTypes getRenderedRimAttachment(IBlockDisplayReader world, BlockPos pos, BlockState state, Direction direction) {
            FluidTransportBehaviour.AttachmentTypes attachment = super.getRenderedRimAttachment(world, pos, state, direction);
            if (attachment == FluidTransportBehaviour.AttachmentTypes.RIM) {
                return FluidTransportBehaviour.AttachmentTypes.NONE;
            }
            return attachment;
        }
    }
}

