/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.content.contraptions.fluids.particle.FluidStackParticle;
import com.simibubi.create.content.contraptions.particle.ICustomParticleData;
import java.util.Optional;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidParticleData
implements IParticleData,
ICustomParticleData<FluidParticleData> {
    private ParticleType<FluidParticleData> type;
    private FluidStack fluid;
    public static final Codec<FluidStack> FLUID_CODEC = RecordCodecBuilder.create(i -> i.group((App)Registry.field_212619_h.fieldOf("FluidName").forGetter(FluidStack::getFluid), (App)Codec.INT.fieldOf("Amount").forGetter(FluidStack::getAmount), (App)CompoundNBT.field_240597_a_.optionalFieldOf("tag").forGetter(fs -> Optional.ofNullable(fs.getTag()))).apply((Applicative)i, (f, a, t) -> new FluidStack(f, a.intValue(), (CompoundNBT)t.orElse(null))));
    public static final Codec<FluidParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)FLUID_CODEC.fieldOf("fluid").forGetter(p -> p.fluid)).apply((Applicative)i, fs -> new FluidParticleData(AllParticleTypes.FLUID_PARTICLE.get(), (FluidStack)fs)));
    public static final Codec<FluidParticleData> BASIN_CODEC = RecordCodecBuilder.create(i -> i.group((App)FLUID_CODEC.fieldOf("fluid").forGetter(p -> p.fluid)).apply((Applicative)i, fs -> new FluidParticleData(AllParticleTypes.BASIN_FLUID.get(), (FluidStack)fs)));
    public static final Codec<FluidParticleData> DRIP_CODEC = RecordCodecBuilder.create(i -> i.group((App)FLUID_CODEC.fieldOf("fluid").forGetter(p -> p.fluid)).apply((Applicative)i, fs -> new FluidParticleData(AllParticleTypes.FLUID_DRIP.get(), (FluidStack)fs)));
    public static final IParticleData.IDeserializer<FluidParticleData> DESERIALIZER = new IParticleData.IDeserializer<FluidParticleData>(){

        public FluidParticleData deserialize(ParticleType<FluidParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            return new FluidParticleData(particleTypeIn, new FluidStack((Fluid)Fluids.field_204546_a, 1));
        }

        public FluidParticleData read(ParticleType<FluidParticleData> particleTypeIn, PacketBuffer buffer) {
            return new FluidParticleData(particleTypeIn, buffer.readFluidStack());
        }
    };

    public FluidParticleData() {
    }

    public FluidParticleData(ParticleType<?> type, FluidStack fluid) {
        this.type = type;
        this.fluid = fluid;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IParticleFactory<FluidParticleData> getFactory() {
        return (data, world, x, y, z, vx, vy, vz) -> FluidStackParticle.create(data.type, world, data.fluid, x, y, z, vx, vy, vz);
    }

    public ParticleType<?> func_197554_b() {
        return this.type;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeFluidStack(this.fluid);
    }

    public String func_197555_a() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.type) + " " + this.fluid.getFluid().getRegistryName();
    }

    @Override
    public IParticleData.IDeserializer<FluidParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    @Override
    public Codec<FluidParticleData> getCodec(ParticleType<FluidParticleData> type) {
        if (type == AllParticleTypes.BASIN_FLUID.get()) {
            return BASIN_CODEC;
        }
        if (type == AllParticleTypes.FLUID_DRIP.get()) {
            return DRIP_CODEC;
        }
        return CODEC;
    }
}

