/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.tank;

import com.simibubi.create.content.contraptions.fluids.tank.CreativeFluidTankTileEntity;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.tuple.Pair;

public class FluidTankConnectivityHandler {
    public static void formTanks(FluidTankTileEntity te) {
        TankSearchCache cache = new TankSearchCache();
        ArrayList<FluidTankTileEntity> frontier = new ArrayList<FluidTankTileEntity>();
        frontier.add(te);
        FluidTankConnectivityHandler.formTanks(te.func_200662_C(), (IBlockReader)te.func_145831_w(), cache, frontier);
    }

    private static void formTanks(TileEntityType<?> type, IBlockReader world, TankSearchCache cache, List<FluidTankTileEntity> frontier) {
        PriorityQueue<Pair<Integer, FluidTankTileEntity>> creationQueue = FluidTankConnectivityHandler.makeCreationQueue();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        int minX = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (FluidTankTileEntity fluidTankTileEntity : frontier) {
            BlockPos pos = fluidTankTileEntity.func_174877_v();
            minX = Math.min(pos.func_177958_n(), minX);
            minZ = Math.min(pos.func_177952_p(), minZ);
        }
        minX -= FluidTankTileEntity.getMaxSize();
        minZ -= FluidTankTileEntity.getMaxSize();
        while (!frontier.isEmpty()) {
            FluidTankTileEntity tank = frontier.remove(0);
            BlockPos tankPos = tank.func_174877_v();
            if (visited.contains(tankPos)) continue;
            visited.add(tankPos);
            int amount = FluidTankConnectivityHandler.tryToFormNewTank(tank, cache, true);
            if (amount > 1) {
                creationQueue.add((Pair<Integer, FluidTankTileEntity>)Pair.of((Object)amount, (Object)tank));
            }
            for (Direction.Axis axis : Iterate.axes) {
                FluidTankTileEntity nextTank;
                Direction d = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis);
                BlockPos next = tankPos.func_177972_a(d);
                if (next.func_177958_n() <= minX || next.func_177952_p() <= minZ || visited.contains(next) || (nextTank = FluidTankConnectivityHandler.tankAt(type, world, next)) == null || nextTank.func_145837_r()) continue;
                frontier.add(nextTank);
            }
        }
        visited.clear();
        while (!creationQueue.isEmpty()) {
            Pair<Integer, FluidTankTileEntity> next = creationQueue.poll();
            FluidTankTileEntity toCreate = (FluidTankTileEntity)next.getValue();
            if (visited.contains(toCreate.func_174877_v())) continue;
            visited.add(toCreate.func_174877_v());
            FluidTankConnectivityHandler.tryToFormNewTank(toCreate, cache, false);
        }
    }

    public static void splitTank(FluidTankTileEntity te) {
        FluidTankConnectivityHandler.splitTankAndInvalidate(te, null, false);
    }

    private static int tryToFormNewTank(FluidTankTileEntity te, TankSearchCache cache, boolean simulate) {
        int bestWidth = 1;
        int bestAmount = -1;
        if (!te.isController()) {
            return 0;
        }
        for (int w = 1; w <= FluidTankTileEntity.getMaxSize(); ++w) {
            int amount = FluidTankConnectivityHandler.tryToFormNewTankOfWidth(te, w, cache, true);
            if (amount < bestAmount) continue;
            bestWidth = w;
            bestAmount = amount;
        }
        if (!simulate) {
            if (te.width == bestWidth && te.width * te.width * te.height == bestAmount) {
                return bestAmount;
            }
            FluidTankConnectivityHandler.splitTankAndInvalidate(te, cache, false);
            te.applyFluidTankSize(bestAmount);
            FluidTankConnectivityHandler.tryToFormNewTankOfWidth(te, bestWidth, cache, simulate);
            te.updateConnectivity = false;
            te.width = bestWidth;
            te.height = bestAmount / bestWidth / bestWidth;
            BlockState state = te.func_195044_w();
            if (FluidTankBlock.isTank(state)) {
                state = (BlockState)state.func_206870_a((Property)FluidTankBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
                state = (BlockState)state.func_206870_a((Property)FluidTankBlock.TOP, (Comparable)Boolean.valueOf(te.height == 1));
                te.func_145831_w().func_180501_a(te.func_174877_v(), state, 22);
            }
            te.setWindows(te.window);
            te.onFluidStackChanged(te.tankInventory.getFluid());
            te.func_70296_d();
        }
        return bestAmount;
    }

    private static int tryToFormNewTankOfWidth(FluidTankTileEntity te, int width, TankSearchCache cache, boolean simulate) {
        int amount = 0;
        int height = 0;
        TileEntityType type = te.func_200662_C();
        World world = te.func_145831_w();
        BlockPos origin = te.func_174877_v();
        LazyOptional capability = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        FluidTank teTank = (FluidTank)capability.orElse(null);
        FluidStack fluid = capability.map(ifh -> ifh.getFluidInTank(0)).orElse(FluidStack.EMPTY);
        block0: for (int yOffset = 0; yOffset < FluidTankTileEntity.getMaxHeight(); ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    BlockPos controllerPos;
                    BlockPos pos = origin.func_177982_a(xOffset, yOffset, zOffset);
                    Optional<FluidTankTileEntity> tank = cache.getOrCache(type, (IBlockReader)world, pos);
                    if (!tank.isPresent()) break block0;
                    FluidTankTileEntity controller = tank.get();
                    int otherWidth = controller.width;
                    if (otherWidth > width || !(controllerPos = controller.func_174877_v()).equals((Object)origin) && (controllerPos.func_177958_n() < origin.func_177958_n() || controllerPos.func_177952_p() < origin.func_177952_p() || controllerPos.func_177958_n() + otherWidth > origin.func_177958_n() + width || controllerPos.func_177952_p() + otherWidth > origin.func_177952_p() + width)) break block0;
                    FluidStack otherFluid = controller.getTankInventory().getFluid();
                    if (!fluid.isEmpty() && !otherFluid.isEmpty() && !fluid.isFluidEqual(otherFluid)) break block0;
                }
            }
            amount += width * width;
            ++height;
        }
        if (simulate) {
            return amount;
        }
        boolean opaque = false;
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    BlockPos pos = origin.func_177982_a(xOffset, yOffset, zOffset);
                    FluidTankTileEntity tank = FluidTankConnectivityHandler.tankAt(type, (IBlockReader)world, pos);
                    if (tank == te) continue;
                    opaque |= !tank.window;
                    FluidTank tankTank = tank.tankInventory;
                    FluidStack fluidInTank = tankTank.getFluid();
                    if (!fluidInTank.isEmpty()) {
                        if (teTank.isEmpty() && teTank instanceof CreativeFluidTankTileEntity.CreativeSmartFluidTank) {
                            ((CreativeFluidTankTileEntity.CreativeSmartFluidTank)teTank).setContainedFluid(fluidInTank);
                        }
                        teTank.fill(fluidInTank, IFluidHandler.FluidAction.EXECUTE);
                    }
                    tankTank.setFluid(FluidStack.EMPTY);
                    FluidTankConnectivityHandler.splitTankAndInvalidate(tank, cache, false);
                    tank.setController(origin);
                    tank.updateConnectivity = false;
                    cache.put(pos, te);
                    BlockState state = world.func_180495_p(pos);
                    if (!FluidTankBlock.isTank(state)) continue;
                    state = (BlockState)state.func_206870_a((Property)FluidTankBlock.BOTTOM, (Comparable)Boolean.valueOf(yOffset == 0));
                    state = (BlockState)state.func_206870_a((Property)FluidTankBlock.TOP, (Comparable)Boolean.valueOf(yOffset == height - 1));
                    world.func_180501_a(pos, state, 22);
                }
            }
        }
        te.setWindows(!opaque);
        return amount;
    }

    private static void splitTankAndInvalidate(FluidTankTileEntity te, @Nullable TankSearchCache cache, boolean tryReconnect) {
        if ((te = te.getControllerTE()) == null) {
            return;
        }
        int height = te.height;
        int width = te.width;
        if (width == 1 && height == 1) {
            return;
        }
        World world = te.func_145831_w();
        BlockPos origin = te.func_174877_v();
        ArrayList<FluidTankTileEntity> frontier = new ArrayList<FluidTankTileEntity>();
        FluidStack toDistribute = te.tankInventory.getFluid().copy();
        int maxCapacity = FluidTankTileEntity.getCapacityMultiplier();
        if (!toDistribute.isEmpty() && !te.func_145837_r()) {
            toDistribute.shrink(maxCapacity);
        }
        te.applyFluidTankSize(1);
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    BlockPos pos = origin.func_177982_a(xOffset, yOffset, zOffset);
                    FluidTankTileEntity tankAt = FluidTankConnectivityHandler.tankAt(te.func_200662_C(), (IBlockReader)world, pos);
                    if (tankAt == null || !tankAt.getController().equals((Object)origin)) continue;
                    FluidTankTileEntity controllerTE = tankAt.getControllerTE();
                    tankAt.window = controllerTE == null || controllerTE.window;
                    tankAt.removeController(true);
                    if (!toDistribute.isEmpty() && tankAt != te) {
                        FluidStack copy = toDistribute.copy();
                        FluidTank tankInventory = tankAt.tankInventory;
                        if (tankInventory.isEmpty() && tankInventory instanceof CreativeFluidTankTileEntity.CreativeSmartFluidTank) {
                            ((CreativeFluidTankTileEntity.CreativeSmartFluidTank)tankInventory).setContainedFluid(toDistribute);
                        } else {
                            int split = Math.min(maxCapacity, toDistribute.getAmount());
                            copy.setAmount(split);
                            toDistribute.shrink(split);
                            tankInventory.fill(copy, IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                    if (tryReconnect) {
                        frontier.add(tankAt);
                        tankAt.updateConnectivity = false;
                    }
                    if (cache == null) continue;
                    cache.put(pos, tankAt);
                }
            }
        }
        te.fluidCapability.invalidate();
        if (tryReconnect) {
            FluidTankConnectivityHandler.formTanks(te.func_200662_C(), (IBlockReader)world, cache == null ? new TankSearchCache() : cache, frontier);
        }
    }

    private static PriorityQueue<Pair<Integer, FluidTankTileEntity>> makeCreationQueue() {
        return new PriorityQueue<Pair<Integer, FluidTankTileEntity>>(new Comparator<Pair<Integer, FluidTankTileEntity>>(){

            @Override
            public int compare(Pair<Integer, FluidTankTileEntity> o1, Pair<Integer, FluidTankTileEntity> o2) {
                return (Integer)o2.getKey() - (Integer)o1.getKey();
            }
        });
    }

    @Nullable
    public static FluidTankTileEntity tankAt(TileEntityType<?> type, IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FluidTankTileEntity && te.func_200662_C() == type) {
            return (FluidTankTileEntity)te;
        }
        return null;
    }

    @Nullable
    public static FluidTankTileEntity anyTankAt(IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FluidTankTileEntity) {
            return (FluidTankTileEntity)te;
        }
        return null;
    }

    public static boolean isConnected(IBlockReader world, BlockPos tankPos, BlockPos otherTankPos) {
        TileEntity te1 = world.func_175625_s(tankPos);
        TileEntity te2 = world.func_175625_s(otherTankPos);
        if (!(te1 instanceof FluidTankTileEntity) || !(te2 instanceof FluidTankTileEntity)) {
            return false;
        }
        return ((FluidTankTileEntity)te1).getController().equals((Object)((FluidTankTileEntity)te2).getController());
    }

    private static class TankSearchCache {
        Map<BlockPos, Optional<FluidTankTileEntity>> controllerMap = new HashMap<BlockPos, Optional<FluidTankTileEntity>>();

        void put(BlockPos pos, FluidTankTileEntity target) {
            this.controllerMap.put(pos, Optional.of(target));
        }

        void putEmpty(BlockPos pos) {
            this.controllerMap.put(pos, Optional.empty());
        }

        boolean hasVisited(BlockPos pos) {
            return this.controllerMap.containsKey(pos);
        }

        Optional<FluidTankTileEntity> getOrCache(TileEntityType<?> type, IBlockReader world, BlockPos pos) {
            if (this.hasVisited(pos)) {
                return this.controllerMap.get(pos);
            }
            FluidTankTileEntity tankAt = FluidTankConnectivityHandler.tankAt(type, world, pos);
            if (tankAt == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            FluidTankTileEntity controller = tankAt.getControllerTE();
            if (controller == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            this.put(pos, controller);
            return Optional.of(controller);
        }
    }
}

