/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing.burner;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.particle.CubeParticleData;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.ForgeHooks;

public class BlazeBurnerTileEntity
extends SmartTileEntity {
    private static final int[][] heatParticleColors = new int[][]{{3871770, 4658202, 8010532, 8736038}, {2752771, 7609098, 12812870, 13417848}, {6490883, 9123075, 12354048, 13420617}, {1860472, 4692149, 5088960, 12241102}};
    public static final int maxHeatCapacity = 10000;
    int remainingBurnTime = 0;
    FuelType activeFuel = FuelType.NONE;
    LerpedFloat headAngle = LerpedFloat.angular();

    public BlazeBurnerTileEntity(TileEntityType<? extends BlazeBurnerTileEntity> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.tickRotation();
            this.spawnParticles(this.getHeatLevelFromBlock(), 1.0);
            return;
        }
        if (this.remainingBurnTime > 0) {
            --this.remainingBurnTime;
        }
        if (this.activeFuel == FuelType.NORMAL) {
            this.updateBlockState();
        }
        if (this.remainingBurnTime > 0) {
            return;
        }
        if (this.activeFuel == FuelType.SPECIAL) {
            this.activeFuel = FuelType.NORMAL;
            this.remainingBurnTime = 5000;
        } else {
            this.activeFuel = FuelType.NONE;
        }
        this.updateBlockState();
        this.notifyUpdate();
    }

    private void tickRotation() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        float target = 0.0f;
        if (player != null) {
            double x = player.func_226277_ct_();
            double z = player.func_226281_cx_();
            if (this.isVirtual()) {
                x = -4.0;
                z = -10.0;
            }
            double dx = x - ((double)this.func_174877_v().func_177958_n() + 0.5);
            double dz = z - ((double)this.func_174877_v().func_177952_p() + 0.5);
            target = AngleHelper.deg(-MathHelper.func_181159_b((double)dz, (double)dx)) - 90.0f;
        }
        target = this.headAngle.getValue() + AngleHelper.getShortestAngleDiff(this.headAngle.getValue(), target);
        this.headAngle.chase(target, 0.25, LerpedFloat.Chaser.exp(5.0));
        this.headAngle.tickChaser();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74768_a("fuelLevel", this.activeFuel.ordinal());
        compound.func_74768_a("burnTimeRemaining", this.remainingBurnTime);
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        this.activeFuel = FuelType.values()[compound.func_74762_e("fuelLevel")];
        this.remainingBurnTime = compound.func_74762_e("burnTimeRemaining");
        super.fromTag(state, compound, clientPacket);
    }

    boolean tryUpdateFuel(ItemStack itemStack, boolean forceOverflow, boolean simulate) {
        FuelType newFuel = FuelType.NONE;
        int newBurnTime = ForgeHooks.getBurnTime((ItemStack)itemStack);
        if (newBurnTime > 0) {
            newFuel = FuelType.NORMAL;
        }
        if (AllItems.BLAZE_CAKE.isIn(itemStack)) {
            newBurnTime = 1000;
            newFuel = FuelType.SPECIAL;
        }
        if (newFuel == FuelType.NONE) {
            return false;
        }
        if (newFuel.ordinal() < this.activeFuel.ordinal()) {
            return false;
        }
        if (this.activeFuel == FuelType.SPECIAL && this.remainingBurnTime > 20) {
            return false;
        }
        if (newFuel == this.activeFuel) {
            if (this.remainingBurnTime + newBurnTime > 10000 && !forceOverflow) {
                return false;
            }
            newBurnTime = MathHelper.func_76125_a((int)(this.remainingBurnTime + newBurnTime), (int)0, (int)10000);
        }
        if (simulate) {
            return true;
        }
        this.activeFuel = newFuel;
        this.remainingBurnTime = newBurnTime;
        if (this.field_145850_b.field_72995_K) {
            BlazeBurnerBlock.HeatLevel level = this.getHeatLevelFromFuelType(newFuel);
            for (int i = 0; i < 20; ++i) {
                this.spawnParticles(level, 1.0 + 0.25 * (double)(i / 4));
            }
            return true;
        }
        this.updateBlockState();
        return true;
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock() {
        return BlazeBurnerBlock.getHeatLevelOf(this.func_195044_w());
    }

    public void updateBlockState() {
        BlazeBurnerBlock.HeatLevel inTE;
        BlazeBurnerBlock.HeatLevel inBlockState = this.getHeatLevelFromBlock();
        if (inBlockState == (inTE = this.getHeatLevelFromFuelType(this.activeFuel))) {
            return;
        }
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)inTE)));
        this.notifyUpdate();
    }

    protected BlazeBurnerBlock.HeatLevel getHeatLevelFromFuelType(FuelType fuel) {
        BlazeBurnerBlock.HeatLevel level = BlazeBurnerBlock.HeatLevel.SMOULDERING;
        switch (this.activeFuel) {
            case SPECIAL: {
                level = BlazeBurnerBlock.HeatLevel.SEETHING;
                break;
            }
            case NORMAL: {
                boolean lowPercent = (double)this.remainingBurnTime / 10000.0 < 0.1;
                level = lowPercent ? BlazeBurnerBlock.HeatLevel.FADING : BlazeBurnerBlock.HeatLevel.KINDLED;
                break;
            }
        }
        return level;
    }

    private void spawnParticles(BlazeBurnerBlock.HeatLevel heatLevel, double burstMult) {
        if (this.field_145850_b == null) {
            return;
        }
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        Random r = this.field_145850_b.func_201674_k();
        switch (heatLevel) {
            case SMOULDERING: {
                if (r.nextDouble() > 0.25) {
                    return;
                }
                this.spawnParticle(heatLevel, 0.03f, 15, false, 0.015 * burstMult, 0.1 * burstMult);
                break;
            }
            case FADING: {
                if (r.nextDouble() > 0.5) {
                    return;
                }
                this.spawnParticle(heatLevel, 0.035f, 18, false, 0.03 * burstMult, 0.15 * burstMult);
                break;
            }
            case KINDLED: {
                this.spawnParticle(heatLevel, 0.04f, 35, true, 0.05 * burstMult, 0.2 * burstMult);
                break;
            }
            case SEETHING: {
                for (int i = 0; i < 2; ++i) {
                    if (r.nextDouble() > 0.6) {
                        return;
                    }
                    this.spawnParticle(heatLevel, 0.045f, 35, true, 0.06 * burstMult, 0.22 * burstMult);
                }
                break;
            }
        }
    }

    private void spawnParticle(BlazeBurnerBlock.HeatLevel heatLevel, float scale, int avgAge, boolean hot, double speed, double spread) {
        Random random = this.field_145850_b.func_201674_k();
        Vector3d color = BlazeBurnerTileEntity.randomColor(heatLevel);
        this.field_145850_b.func_195589_b((IParticleData)new CubeParticleData((float)color.field_72450_a, (float)color.field_72448_b, (float)color.field_72449_c, scale, avgAge, hot), (double)this.field_174879_c.func_177958_n() + 0.5 + (random.nextDouble() * 2.0 - 1.0) * spread, (double)this.field_174879_c.func_177956_o() + 0.6 + random.nextDouble() / 4.0, (double)this.field_174879_c.func_177952_p() + 0.5 + (random.nextDouble() * 2.0 - 1.0) * spread, 0.0, speed, 0.0);
    }

    private static Vector3d randomColor(BlazeBurnerBlock.HeatLevel heatLevel) {
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        return ColorHelper.getRGB(heatParticleColors[heatLevel.ordinal() - 1][(int)(Math.random() * 4.0)]);
    }

    public static enum FuelType {
        NONE,
        NORMAL,
        SPECIAL;

    }
}

