/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.tools;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.curiosities.tools.ExtendoGripModel;
import com.simibubi.create.content.curiosities.tools.ExtendoGripRenderHandler;
import com.simibubi.create.foundation.block.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.PartialItemModelRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.MatrixStacker;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class ExtendoGripItemRenderer
extends CustomRenderedItemModelRenderer<ExtendoGripModel> {
    private static final Vector3d rotationOffset = new Vector3d(0.0, 0.5, 0.5);
    private static final Vector3d cogRotationOffset = new Vector3d(0.0, 0.0625, 0.0);

    @Override
    protected void render(ItemStack stack, ExtendoGripModel model, PartialItemModelRenderer renderer, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        boolean rightHand;
        MatrixStacker stacker = MatrixStacker.of(ms);
        float animation = 0.25f;
        ItemCameraTransforms.TransformType perspective = model.getCurrentPerspective();
        boolean leftHand = perspective == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND;
        boolean bl = rightHand = perspective == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND;
        if (leftHand || rightHand) {
            animation = MathHelper.func_219799_g((float)AnimationTickHolder.getPartialTicks(), (float)ExtendoGripRenderHandler.lastMainHandAnimation, (float)ExtendoGripRenderHandler.mainHandAnimation);
        }
        animation = animation * animation * animation;
        float extensionAngle = MathHelper.func_219799_g((float)animation, (float)24.0f, (float)156.0f);
        float halfAngle = extensionAngle / 2.0f;
        float oppositeAngle = 180.0f - extensionAngle;
        renderer.renderSolid(model.getBakedModel(), light);
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, 0.0625, -0.4375);
        ms.func_227862_a_(1.0f, 1.0f, 1.0f + animation);
        ms.func_227860_a_();
        stacker.rotateX(-halfAngle).translate(rotationOffset);
        renderer.renderSolid(model.getPartial("thin_short"), light);
        stacker.translateBack(rotationOffset);
        ms.func_227861_a_(0.0, 0.34375, 0.0);
        stacker.rotateX(-oppositeAngle).translate(rotationOffset);
        renderer.renderSolid(model.getPartial("wide_long"), light);
        stacker.translateBack(rotationOffset);
        ms.func_227861_a_(0.0, 0.6875, 0.0);
        stacker.rotateX(oppositeAngle).translate(rotationOffset);
        ms.func_227861_a_(0.0, 0.03125, 0.0);
        renderer.renderSolid(model.getPartial("thin_short"), light);
        stacker.translateBack(rotationOffset);
        ms.func_227865_b_();
        ms.func_227860_a_();
        stacker.rotateX(-180.0f + halfAngle).translate(rotationOffset);
        renderer.renderSolid(model.getPartial("wide_short"), light);
        stacker.translateBack(rotationOffset);
        ms.func_227861_a_(0.0, 0.34375, 0.0);
        stacker.rotateX(oppositeAngle).translate(rotationOffset);
        renderer.renderSolid(model.getPartial("thin_long"), light);
        stacker.translateBack(rotationOffset);
        ms.func_227861_a_(0.0, 0.6875, 0.0);
        stacker.rotateX(-oppositeAngle).translate(rotationOffset);
        ms.func_227861_a_(0.0, 0.03125, 0.0);
        renderer.renderSolid(model.getPartial("wide_short"), light);
        stacker.translateBack(rotationOffset);
        ms.func_227861_a_(0.0, 0.34375, 0.0);
        stacker.rotateX(180.0f - halfAngle).rotateY(180.0);
        ms.func_227861_a_(0.0, 0.0, -0.25);
        ms.func_227862_a_(1.0f, 1.0f, 1.0f / (1.0f + animation));
        renderer.renderSolid(leftHand || rightHand ? ExtendoGripRenderHandler.pose.get() : AllBlockPartials.DEPLOYER_HAND_POINTING.get(), light);
        ms.func_227865_b_();
        ms.func_227865_b_();
        ms.func_227860_a_();
        float angle = AnimationTickHolder.getRenderTime() * -2.0f;
        if (leftHand || rightHand) {
            angle += 360.0f * animation;
        }
        stacker.translate(cogRotationOffset).rotateZ(angle %= 360.0f).translateBack(cogRotationOffset);
        renderer.renderSolid(model.getPartial("cog"), light);
        ms.func_227865_b_();
    }
}

