/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper;

import com.google.common.base.Predicates;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;

public enum PlacementPatterns {
    Solid(AllIcons.I_PATTERN_SOLID),
    Checkered(AllIcons.I_PATTERN_CHECKERED),
    InverseCheckered(AllIcons.I_PATTERN_CHECKERED_INVERSED),
    Chance25(AllIcons.I_PATTERN_CHANCE_25),
    Chance50(AllIcons.I_PATTERN_CHANCE_50),
    Chance75(AllIcons.I_PATTERN_CHANCE_75);

    public String translationKey = Lang.asId(this.name());
    public AllIcons icon;

    private PlacementPatterns(AllIcons icon) {
        this.icon = icon;
    }

    public static void applyPattern(List<BlockPos> blocksIn, ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        PlacementPatterns pattern = !tag.func_74764_b("Pattern") ? Solid : PlacementPatterns.valueOf(tag.func_74779_i("Pattern"));
        Random r = new Random();
        Object filter = Predicates.alwaysFalse();
        switch (pattern) {
            case Chance25: {
                filter = pos -> r.nextBoolean() || r.nextBoolean();
                break;
            }
            case Chance50: {
                filter = pos -> r.nextBoolean();
                break;
            }
            case Chance75: {
                filter = pos -> r.nextBoolean() && r.nextBoolean();
                break;
            }
            case Checkered: {
                filter = pos -> (pos.func_177958_n() + pos.func_177956_o() + pos.func_177952_p()) % 2 == 0;
                break;
            }
            case InverseCheckered: {
                filter = pos -> (pos.func_177958_n() + pos.func_177956_o() + pos.func_177952_p()) % 2 != 0;
                break;
            }
        }
        blocksIn.removeIf((Predicate<BlockPos>)filter);
    }
}

