/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.block.depot.EjectorBlock;
import com.simibubi.create.content.logistics.block.depot.EjectorTileEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class EjectorPlacementPacket
extends SimplePacketBase {
    private int h;
    private int v;
    private BlockPos pos;
    private Direction facing;

    public EjectorPlacementPacket(int h, int v, BlockPos pos, Direction facing) {
        this.h = h;
        this.v = v;
        this.pos = pos;
        this.facing = facing;
    }

    public EjectorPlacementPacket(PacketBuffer buffer) {
        this.h = buffer.readInt();
        this.v = buffer.readInt();
        this.pos = buffer.func_179259_c();
        this.facing = Direction.func_82600_a((int)buffer.func_150792_a());
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.h);
        buffer.writeInt(this.v);
        buffer.func_179255_a(this.pos);
        buffer.func_150787_b(this.facing.func_176745_a());
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            World world = player.field_70170_p;
            if (world == null || !world.func_195588_v(this.pos)) {
                return;
            }
            TileEntity tileEntity = world.func_175625_s(this.pos);
            BlockState state = world.func_180495_p(this.pos);
            if (tileEntity instanceof EjectorTileEntity) {
                ((EjectorTileEntity)tileEntity).setTarget(this.h, this.v);
            }
            if (AllBlocks.WEIGHTED_EJECTOR.has(state)) {
                world.func_175656_a(this.pos, (BlockState)state.func_206870_a(EjectorBlock.HORIZONTAL_FACING, (Comparable)this.facing));
            }
        });
        context.get().setPacketHandled(true);
    }
}

