/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.depot.DepotBehaviour;
import com.simibubi.create.content.logistics.block.depot.EjectorBlock;
import com.simibubi.create.content.logistics.block.depot.EjectorElytraPacket;
import com.simibubi.create.content.logistics.block.depot.EntityLauncher;
import com.simibubi.create.content.logistics.block.funnel.AbstractFunnelBlock;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.extensions.IForgeItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class EjectorTileEntity
extends KineticTileEntity {
    List<IntAttached<ItemStack>> launchedItems;
    ScrollValueBehaviour maxStackSize;
    DepotBehaviour depotBehaviour;
    EntityLauncher launcher = new EntityLauncher(1, 0);
    LerpedFloat lidProgress = LerpedFloat.linear().startWithValue(1.0);
    boolean powered = false;
    boolean launch;
    State state = State.RETRACTING;
    @Nullable
    Pair<Vector3d, BlockPos> earlyTarget;
    float earlyTargetTime;
    int scanCooldown;
    ItemStack trackedItem;

    public EjectorTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
        this.launchedItems = new ArrayList<IntAttached<ItemStack>>();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.depotBehaviour = new DepotBehaviour(this);
        behaviours.add(this.depotBehaviour);
        this.maxStackSize = new ScrollValueBehaviour((ITextComponent)Lang.translate("weighted_ejector.stack_size", new Object[0]), this, new EjectorSlot()).between(0, 64).withFormatter(i -> i == 0 ? "*" : String.valueOf(i)).onlyActiveWhen(() -> this.state == State.CHARGED).requiresWrench();
        behaviours.add(this.maxStackSize);
        this.depotBehaviour.maxStackSize = () -> this.maxStackSize.getValue();
        this.depotBehaviour.canAcceptItems = () -> this.state == State.CHARGED;
        this.depotBehaviour.canFunnelsPullFrom = side -> side != this.getFacing();
        this.depotBehaviour.enableMerging();
        this.depotBehaviour.addSubBehaviours(behaviours);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateSignal();
    }

    public void activate() {
        this.launch = true;
        this.nudgeEntities();
    }

    protected boolean cannotLaunch() {
        return this.state != State.CHARGED && (!this.field_145850_b.field_72995_K || this.state != State.LAUNCHING);
    }

    public void activateDeferred() {
        boolean doLogic;
        if (this.cannotLaunch()) {
            return;
        }
        Direction facing = this.getFacing();
        List entities = this.field_145850_b.func_217357_a(Entity.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(-0.0625, 0.0, -0.0625));
        boolean bl = doLogic = !this.field_145850_b.field_72995_K || this.isVirtual();
        if (doLogic) {
            this.launchItems();
        }
        for (Entity entity : entities) {
            PlayerEntity playerEntity;
            boolean isPlayerEntity = entity instanceof PlayerEntity;
            if (!entity.func_70089_S() || entity instanceof ItemEntity) continue;
            entity.field_70122_E = false;
            if (isPlayerEntity != this.field_145850_b.field_72995_K) continue;
            entity.func_70107_b((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)(this.field_174879_c.func_177956_o() + 1), (double)((float)this.field_174879_c.func_177952_p() + 0.5f));
            this.launcher.applyMotion(entity, facing);
            if (!isPlayerEntity || !((playerEntity = (PlayerEntity)entity).func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof ElytraItem)) continue;
            playerEntity.field_70177_z = facing.func_185119_l();
            playerEntity.field_70125_A = -35.0f;
            playerEntity.func_213317_d(playerEntity.func_213322_ci().func_186678_a(0.75));
            this.deployElytra(playerEntity);
            AllPackets.channel.sendToServer((Object)new EjectorElytraPacket(this.field_174879_c));
        }
        if (doLogic) {
            this.lidProgress.chase(1.0, 0.8f, LerpedFloat.Chaser.EXP);
            this.state = State.LAUNCHING;
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187877_gO, SoundCategory.BLOCKS, 0.35f, 1.0f);
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.1f, 1.4f);
            }
        }
    }

    public void deployElytra(PlayerEntity playerEntity) {
        EntityHack.setElytraFlying((Entity)playerEntity);
    }

    protected void launchItems() {
        ItemStack heldItemStack = this.depotBehaviour.getHeldItemStack();
        Direction funnelFacing = this.getFacing().func_176734_d();
        if (AbstractFunnelBlock.getFunnelFacing(this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a())) == funnelFacing) {
            ItemStack remainder;
            DirectBeltInputBehaviour directOutput = this.getBehaviour(DirectBeltInputBehaviour.TYPE);
            if (this.depotBehaviour.heldItem != null && (remainder = directOutput.tryExportingToBeltFunnel(heldItemStack, funnelFacing, false)) != null) {
                if (remainder.func_190926_b()) {
                    this.depotBehaviour.removeHeldItem();
                } else if (!remainder.func_77969_a(heldItemStack)) {
                    this.depotBehaviour.heldItem.stack = remainder;
                }
            }
            Iterator<TransportedItemStack> iterator = this.depotBehaviour.incoming.iterator();
            while (iterator.hasNext()) {
                TransportedItemStack transportedItemStack = iterator.next();
                ItemStack stack = transportedItemStack.stack;
                ItemStack remainder2 = directOutput.tryExportingToBeltFunnel(stack, funnelFacing, false);
                if (remainder2 == null) continue;
                if (remainder2.func_190926_b()) {
                    iterator.remove();
                    continue;
                }
                if (remainder2.func_77969_a(stack)) continue;
                transportedItemStack.stack = remainder2;
            }
            ItemStackHandler outputs = this.depotBehaviour.processingOutputBuffer;
            for (int i = 0; i < outputs.getSlots(); ++i) {
                ItemStack remainder3 = directOutput.tryExportingToBeltFunnel(outputs.getStackInSlot(i), funnelFacing, false);
                if (remainder3 == null) continue;
                outputs.setStackInSlot(i, remainder3);
            }
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.func_195044_w(), this.func_195044_w(), 0, 512);
        }
        if (this.depotBehaviour.heldItem != null) {
            this.addToLaunchedItems(heldItemStack);
            this.depotBehaviour.removeHeldItem();
        }
        for (TransportedItemStack transportedItemStack : this.depotBehaviour.incoming) {
            this.addToLaunchedItems(transportedItemStack.stack);
        }
        this.depotBehaviour.incoming.clear();
        ItemStackHandler outputs = this.depotBehaviour.processingOutputBuffer;
        for (int i = 0; i < outputs.getSlots(); ++i) {
            ItemStack extractItem = outputs.extractItem(i, 64, false);
            if (extractItem.func_190926_b()) continue;
            this.addToLaunchedItems(extractItem);
        }
    }

    protected boolean addToLaunchedItems(ItemStack stack) {
        if ((!this.field_145850_b.field_72995_K || this.isVirtual()) && this.trackedItem == null && this.scanCooldown == 0) {
            this.scanCooldown = (Integer)AllConfigs.SERVER.kinetics.ejectorScanInterval.get();
            this.trackedItem = stack;
        }
        return this.launchedItems.add(IntAttached.withZero(stack));
    }

    protected Direction getFacing() {
        BlockState blockState = this.func_195044_w();
        if (!AllBlocks.WEIGHTED_EJECTOR.has(blockState)) {
            return Direction.UP;
        }
        Direction facing = (Direction)blockState.func_177229_b(EjectorBlock.HORIZONTAL_FACING);
        return facing;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        boolean doLogic = !this.field_145850_b.field_72995_K || this.isVirtual();
        State prevState = this.state;
        float totalTime = Math.max(3.0f, (float)this.launcher.getTotalFlyingTicks());
        if (this.scanCooldown > 0) {
            --this.scanCooldown;
        }
        if (this.launch) {
            this.launch = false;
            this.activateDeferred();
        }
        Iterator<IntAttached<ItemStack>> iterator = this.launchedItems.iterator();
        while (iterator.hasNext()) {
            float maxTime;
            IntAttached<ItemStack> intAttached = iterator.next();
            boolean hit = false;
            if (intAttached.getSecond() == this.trackedItem) {
                hit = this.scanTrajectoryForObstacles((Integer)intAttached.getFirst());
            }
            float f = maxTime = this.earlyTarget != null ? Math.min(this.earlyTargetTime, totalTime) : totalTime;
            if (hit || intAttached.exceeds((int)maxTime)) {
                this.placeItemAtTarget(doLogic, maxTime, intAttached);
                iterator.remove();
            }
            intAttached.increment();
        }
        if (this.state == State.LAUNCHING) {
            this.lidProgress.chase(1.0, 0.8f, LerpedFloat.Chaser.EXP);
            this.lidProgress.tickChaser();
            if (this.lidProgress.getValue() > 0.9375f && doLogic) {
                this.state = State.RETRACTING;
                this.lidProgress.setValue(1.0);
            }
        }
        if (this.state == State.CHARGED) {
            this.lidProgress.setValue(0.0);
            this.lidProgress.updateChaseSpeed(0.0);
            if (doLogic) {
                this.ejectIfTriggered();
            }
        }
        if (this.state == State.RETRACTING) {
            if (this.lidProgress.getChaseTarget() == 1.0f && !this.lidProgress.settled()) {
                this.lidProgress.tickChaser();
            } else {
                this.lidProgress.updateChaseTarget(0.0f);
                this.lidProgress.updateChaseSpeed(0.0);
                if (this.lidProgress.getValue() == 0.0f && doLogic) {
                    this.state = State.CHARGED;
                    this.lidProgress.setValue(0.0);
                    this.sendData();
                }
                float value = MathHelper.func_76131_a((float)(this.lidProgress.getValue() - this.getWindUpSpeed()), (float)0.0f, (float)1.0f);
                this.lidProgress.setValue(value);
                int soundRate = (int)(1.0f / (this.getWindUpSpeed() * 5.0f)) + 1;
                float volume = 0.125f;
                float pitch = 1.5f - this.lidProgress.getValue();
                if ((int)this.field_145850_b.func_82737_E() % soundRate == 0 && doLogic) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187883_gR, SoundCategory.BLOCKS, volume, pitch);
                }
            }
        }
        if (this.state != prevState) {
            this.notifyUpdate();
        }
    }

    private boolean scanTrajectoryForObstacles(int time) {
        Vector3d target;
        if (time == 0) {
            return false;
        }
        Vector3d source = this.getLaunchedItemLocation(time);
        BlockRayTraceResult rayTraceBlocks = this.field_145850_b.func_217299_a(new RayTraceContext(source, target = this.getLaunchedItemLocation(time + 1), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
        if (rayTraceBlocks.func_216346_c() == RayTraceResult.Type.MISS) {
            if (this.earlyTarget != null && this.earlyTargetTime < (float)(time + 1)) {
                this.earlyTarget = null;
                this.earlyTargetTime = 0.0f;
            }
            return false;
        }
        Vector3d vec = rayTraceBlocks.func_216347_e();
        this.earlyTarget = Pair.of(vec.func_178787_e(Vector3d.func_237491_b_((Vector3i)rayTraceBlocks.func_216354_b().func_176730_m()).func_186678_a(0.25)), rayTraceBlocks.func_216350_a());
        this.earlyTargetTime = (float)((double)time + source.func_72438_d(vec) / source.func_72438_d(target));
        this.sendData();
        return true;
    }

    protected void nudgeEntities() {
        for (Entity entity : this.field_145850_b.func_217357_a(Entity.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(-0.0625, 0.0, -0.0625))) {
            if (entity instanceof PlayerEntity) continue;
            entity.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + 0.125, entity.func_226281_cx_());
        }
    }

    protected void ejectIfTriggered() {
        DirectBeltInputBehaviour targetOpenInv;
        if (this.powered) {
            return;
        }
        int presentStackSize = this.depotBehaviour.getPresentStackSize();
        if (presentStackSize == 0) {
            return;
        }
        if (presentStackSize < this.maxStackSize.getValue()) {
            return;
        }
        if (this.depotBehaviour.heldItem != null && this.depotBehaviour.heldItem.beltPosition < 0.49f) {
            return;
        }
        Direction funnelFacing = this.getFacing().func_176734_d();
        ItemStack held = this.depotBehaviour.getHeldItemStack();
        if (AbstractFunnelBlock.getFunnelFacing(this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a())) == funnelFacing) {
            ItemStack tryFunnel;
            DirectBeltInputBehaviour directOutput = this.getBehaviour(DirectBeltInputBehaviour.TYPE);
            if (!(this.depotBehaviour.heldItem == null || (tryFunnel = directOutput.tryExportingToBeltFunnel(held, funnelFacing, true)) != null && tryFunnel.func_190926_b())) {
                return;
            }
        }
        if ((targetOpenInv = this.getTargetOpenInv()) != null && this.depotBehaviour.heldItem != null && targetOpenInv.handleInsertion(held, Direction.UP, true).func_190916_E() == held.func_190916_E()) {
            return;
        }
        this.activate();
        this.notifyUpdate();
    }

    protected void placeItemAtTarget(boolean doLogic, float maxTime, IntAttached<ItemStack> intAttached) {
        DirectBeltInputBehaviour targetOpenInv;
        if (!doLogic) {
            return;
        }
        if (intAttached.getSecond() == this.trackedItem) {
            this.trackedItem = null;
        }
        if ((targetOpenInv = this.getTargetOpenInv()) != null) {
            ItemStack remainder = targetOpenInv.handleInsertion(intAttached.getValue(), Direction.UP, false);
            intAttached.setSecond(remainder);
        }
        if (intAttached.getValue().func_190926_b()) {
            return;
        }
        Vector3d ejectVec = this.earlyTarget != null ? this.earlyTarget.getFirst() : this.getLaunchedItemLocation(maxTime);
        Vector3d ejectMotionVec = this.getLaunchedItemMotion(maxTime);
        ItemEntity item = new ItemEntity(this.field_145850_b, ejectVec.field_72450_a, ejectVec.field_72448_b, ejectVec.field_72449_c, intAttached.getValue());
        item.func_213317_d(ejectMotionVec);
        item.func_174869_p();
        this.field_145850_b.func_217376_c((Entity)item);
    }

    public DirectBeltInputBehaviour getTargetOpenInv() {
        BlockPos targetPos = this.earlyTarget != null ? this.earlyTarget.getSecond() : this.field_174879_c.func_177981_b(this.launcher.getVerticalDistance()).func_177967_a(this.getFacing(), Math.max(1, this.launcher.getHorizontalDistance()));
        return TileEntityBehaviour.get((IBlockReader)this.field_145850_b, targetPos, DirectBeltInputBehaviour.TYPE);
    }

    public Vector3d getLaunchedItemLocation(float time) {
        return this.launcher.getGlobalPos(time, this.getFacing().func_176734_d(), this.field_174879_c);
    }

    public Vector3d getLaunchedItemMotion(float time) {
        return this.launcher.getGlobalVelocity(time, this.getFacing().func_176734_d(), this.field_174879_c).func_186678_a(0.5);
    }

    public void dropFlyingItems() {
        for (IntAttached<ItemStack> intAttached : this.launchedItems) {
            Vector3d ejectVec = this.getLaunchedItemLocation(((Integer)intAttached.getFirst()).intValue());
            Vector3d ejectMotionVec = this.getLaunchedItemMotion(((Integer)intAttached.getFirst()).intValue());
            ItemEntity item = new ItemEntity(this.field_145850_b, 0.0, 0.0, 0.0, intAttached.getValue());
            item.func_226288_n_(ejectVec.field_72450_a, ejectVec.field_72448_b, ejectVec.field_72449_c);
            item.func_213317_d(ejectMotionVec);
            item.func_174869_p();
            this.field_145850_b.func_217376_c((Entity)item);
        }
        this.launchedItems.clear();
    }

    public float getWindUpSpeed() {
        int hd = this.launcher.getHorizontalDistance();
        int vd = this.launcher.getVerticalDistance();
        float speedFactor = Math.abs(this.getSpeed()) / 256.0f;
        float distanceFactor = hd == 0 && vd == 0 ? 1.0f : 1.0f * MathHelper.func_76133_a((double)(Math.pow(hd, 2.0) + Math.pow(vd, 2.0)));
        return speedFactor / distanceFactor;
    }

    @Override
    protected void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.func_74768_a("HorizontalDistance", this.launcher.getHorizontalDistance());
        compound.func_74768_a("VerticalDistance", this.launcher.getVerticalDistance());
        compound.func_74757_a("Powered", this.powered);
        NBTHelper.writeEnum(compound, "State", this.state);
        compound.func_218657_a("Lid", (INBT)this.lidProgress.writeNBT());
        compound.func_218657_a("LaunchedItems", (INBT)NBTHelper.writeCompoundList(this.launchedItems, ia -> ia.serializeNBT(IForgeItemStack::serializeNBT)));
        if (this.earlyTarget != null) {
            compound.func_218657_a("EarlyTarget", (INBT)VecHelper.writeNBT(this.earlyTarget.getFirst()));
            compound.func_218657_a("EarlyTargetPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.earlyTarget.getSecond()));
            compound.func_74776_a("EarlyTargetTime", this.earlyTargetTime);
        }
    }

    @Override
    protected void fromTag(BlockState blockState, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(blockState, compound, clientPacket);
        int horizontalDistance = compound.func_74762_e("HorizontalDistance");
        int verticalDistance = compound.func_74762_e("VerticalDistance");
        if (this.launcher == null || this.launcher.getHorizontalDistance() != horizontalDistance || this.launcher.getVerticalDistance() != verticalDistance) {
            this.launcher.set(horizontalDistance, verticalDistance);
            this.launcher.clamp((Integer)AllConfigs.SERVER.kinetics.maxEjectorDistance.get());
        }
        this.powered = compound.func_74767_n("Powered");
        this.state = NBTHelper.readEnum(compound, "State", State.class);
        this.lidProgress.readNBT(compound.func_74775_l("Lid"), false);
        this.launchedItems = NBTHelper.readCompoundList(compound.func_150295_c("LaunchedItems", 10), nbt -> IntAttached.read(nbt, ItemStack::func_199557_a));
        this.earlyTarget = null;
        this.earlyTargetTime = 0.0f;
        if (compound.func_74764_b("EarlyTarget")) {
            this.earlyTarget = Pair.of(VecHelper.readNBT(compound.func_150295_c("EarlyTarget", 6)), NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("EarlyTargetPos")));
            this.earlyTargetTime = compound.func_74760_g("EarlyTargetTime");
        }
        if (compound.func_74764_b("ForceAngle")) {
            this.lidProgress.startWithValue(compound.func_74760_g("ForceAngle"));
        }
    }

    public void updateSignal() {
        boolean shoudPower = this.field_145850_b.func_175640_z(this.field_174879_c);
        if (shoudPower == this.powered) {
            return;
        }
        this.powered = shoudPower;
        this.sendData();
    }

    public void setTarget(int horizontalDistance, int verticalDistance) {
        this.launcher.set(Math.max(1, horizontalDistance), verticalDistance);
        this.sendData();
    }

    public BlockPos getTargetPosition() {
        BlockState blockState = this.func_195044_w();
        if (!AllBlocks.WEIGHTED_EJECTOR.has(blockState)) {
            return this.field_174879_c;
        }
        Direction facing = (Direction)blockState.func_177229_b(EjectorBlock.HORIZONTAL_FACING);
        return this.field_174879_c.func_177967_a(facing, this.launcher.getHorizontalDistance()).func_177981_b(this.launcher.getVerticalDistance());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.depotBehaviour.getItemCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean shouldRenderAsTE() {
        return true;
    }

    public float getLidProgress(float pt) {
        return this.lidProgress.getValue(pt);
    }

    public State getState() {
        return this.state;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * 16.0;
    }

    private static class EjectorSlot
    extends ValueBoxTransform.Sided {
        private EjectorSlot() {
        }

        @Override
        protected Vector3d getLocalOffset(BlockState state) {
            return new Vector3d(0.5, 0.8125, 0.5).func_178787_e(VecHelper.rotate(new Vector3d(0.0, 0.0, -0.3), this.angle(state), Direction.Axis.Y));
        }

        @Override
        protected void rotate(BlockState state, MatrixStack ms) {
            MatrixStacker.of(ms).rotateY(this.angle(state)).rotateX(90.0);
        }

        protected float angle(BlockState state) {
            float horizontalAngle = AllBlocks.WEIGHTED_EJECTOR.has(state) ? AngleHelper.horizontalAngle((Direction)state.func_177229_b(EjectorBlock.HORIZONTAL_FACING)) : 0.0f;
            return horizontalAngle;
        }

        @Override
        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction == Direction.UP;
        }

        @Override
        protected float getScale() {
            return 0.2f;
        }

        @Override
        protected Vector3d getSouthLocation() {
            return Vector3d.field_186680_a;
        }
    }

    private static abstract class EntityHack
    extends Entity {
        public EntityHack(EntityType<?> p_i48580_1_, World p_i48580_2_) {
            super(p_i48580_1_, p_i48580_2_);
        }

        public static void setElytraFlying(Entity e) {
            EntityDataManager data = e.func_184212_Q();
            data.func_187227_b(field_184240_ax, (Object)((byte)((Byte)data.func_187225_a(field_184240_ax) | 0x80)));
        }
    }

    public static enum State {
        CHARGED,
        LAUNCHING,
        RETRACTING;

    }
}

