/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.logistics.block.funnel.AbstractFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;

public class FunnelFilterSlotPositioning
extends ValueBoxTransform.Sided {
    @Override
    protected Vector3d getLocalOffset(BlockState state) {
        Direction side = this.getSide();
        float horizontalAngle = AngleHelper.horizontalAngle(side);
        Direction funnelFacing = FunnelBlock.getFunnelFacing(state);
        float stateAngle = AngleHelper.horizontalAngle(funnelFacing);
        if (state.func_177230_c() instanceof BeltFunnelBlock) {
            switch ((BeltFunnelBlock.Shape)((Object)state.func_177229_b(BeltFunnelBlock.SHAPE))) {
                case EXTENDED: {
                    return VecHelper.rotateCentered(VecHelper.voxelSpace(8.0, 15.5, 13.0), stateAngle, Direction.Axis.Y);
                }
                case PULLING: 
                case PUSHING: {
                    return VecHelper.rotateCentered(VecHelper.voxelSpace(8.0, 12.1, 8.7f), horizontalAngle, Direction.Axis.Y);
                }
            }
            return VecHelper.rotateCentered(VecHelper.voxelSpace(8.0, 13.0, 7.5), horizontalAngle, Direction.Axis.Y);
        }
        if (!funnelFacing.func_176740_k().func_176722_c()) {
            Vector3d southLocation = VecHelper.voxelSpace(8.0, funnelFacing == Direction.DOWN ? 14.0 : 2.0, 15.5);
            return VecHelper.rotateCentered(southLocation, horizontalAngle, Direction.Axis.Y);
        }
        return VecHelper.rotateCentered(VecHelper.voxelSpace(8.0, 12.1, 8.7f), horizontalAngle, Direction.Axis.Y);
    }

    @Override
    protected void rotate(BlockState state, MatrixStack ms) {
        Direction facing = FunnelBlock.getFunnelFacing(state);
        if (facing.func_176740_k().func_200128_b()) {
            super.rotate(state, ms);
            return;
        }
        boolean isBeltFunnel = state.func_177230_c() instanceof BeltFunnelBlock;
        if (isBeltFunnel && state.func_177229_b(BeltFunnelBlock.SHAPE) != BeltFunnelBlock.Shape.EXTENDED) {
            BeltFunnelBlock.Shape shape = (BeltFunnelBlock.Shape)((Object)state.func_177229_b(BeltFunnelBlock.SHAPE));
            super.rotate(state, ms);
            if (shape == BeltFunnelBlock.Shape.PULLING || shape == BeltFunnelBlock.Shape.PUSHING) {
                MatrixStacker.of(ms).rotateX(-22.5);
            }
            return;
        }
        if (state.func_177230_c() instanceof FunnelBlock) {
            super.rotate(state, ms);
            MatrixStacker.of(ms).rotateX(-22.5);
            return;
        }
        float yRot = AngleHelper.horizontalAngle(AbstractFunnelBlock.getFunnelFacing(state)) + (float)(facing == Direction.DOWN ? 180 : 0);
        MatrixStacker.of(ms).rotateY(yRot).rotateX(facing == Direction.DOWN ? -90.0 : 90.0);
    }

    @Override
    protected boolean isSideActive(BlockState state, Direction direction) {
        Direction facing = FunnelBlock.getFunnelFacing(state);
        if (facing == null) {
            return false;
        }
        if (facing.func_176740_k().func_200128_b()) {
            return direction.func_176740_k().func_176722_c();
        }
        if (state.func_177230_c() instanceof BeltFunnelBlock && state.func_177229_b(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.EXTENDED) {
            return direction == Direction.UP;
        }
        return direction == facing;
    }

    @Override
    protected Vector3d getSouthLocation() {
        return Vector3d.field_186680_a;
    }
}

