/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.mechanicalArm;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmBlock;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmTileEntity;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.backend.FastRenderDispatcher;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.MatrixStacker;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ArmRenderer
extends KineticTileEntityRenderer {
    public ArmRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public boolean isGlobalRenderer(KineticTileEntity te) {
        return true;
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float pt, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        boolean hasItem;
        super.renderSafe(te, pt, ms, buffer, light, overlay);
        ArmTileEntity arm = (ArmTileEntity)te;
        boolean usingFlywheel = FastRenderDispatcher.available(te.func_145831_w());
        ItemStack item = arm.heldItem;
        boolean bl = hasItem = !item.func_190926_b();
        if (usingFlywheel && !hasItem) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        boolean isBlockItem = hasItem && item.func_77973_b() instanceof BlockItem && itemRenderer.func_184393_a(item, (World)Minecraft.func_71410_x().field_71441_e, null).func_177556_c();
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228639_c_());
        BlockState blockState = te.func_195044_w();
        MatrixStack msLocal = new MatrixStack();
        MatrixStacker msr = MatrixStacker.of(msLocal);
        int color = 0xFFFFFF;
        float baseAngle = arm.baseAngle.get(pt);
        float lowerArmAngle = arm.lowerArmAngle.get(pt) - 135.0f;
        float upperArmAngle = arm.upperArmAngle.get(pt) - 90.0f;
        float headAngle = arm.headAngle.get(pt);
        boolean rave = arm.phase == ArmTileEntity.Phase.DANCING;
        float renderTick = AnimationTickHolder.getRenderTime((IWorld)te.func_145831_w()) + (float)(te.hashCode() % 64);
        if (rave) {
            baseAngle = renderTick * 10.0f % 360.0f;
            lowerArmAngle = MathHelper.func_219799_g((float)((MathHelper.func_76126_a((float)(renderTick / 4.0f)) + 1.0f) / 2.0f), (float)-45.0f, (float)15.0f);
            upperArmAngle = MathHelper.func_219799_g((float)((MathHelper.func_76126_a((float)(renderTick / 8.0f)) + 1.0f) / 4.0f), (float)-45.0f, (float)95.0f);
            headAngle = -lowerArmAngle;
            color = ColorHelper.rainbowColor(AnimationTickHolder.getTicks() * 100);
        }
        msr.centre();
        if (((Boolean)blockState.func_177229_b((Property)ArmBlock.CEILING)).booleanValue()) {
            msr.rotateX(180.0);
        }
        if (usingFlywheel) {
            this.doItemTransforms(msr, baseAngle, lowerArmAngle, upperArmAngle, headAngle);
        } else {
            this.renderArm(builder, ms, msLocal, msr, blockState, color, baseAngle, lowerArmAngle, upperArmAngle, headAngle, hasItem, isBlockItem, light);
        }
        if (hasItem) {
            ms.func_227860_a_();
            float itemScale = isBlockItem ? 0.5f : 0.625f;
            msr.rotateX(90.0);
            msLocal.func_227861_a_(0.0, -0.25, 0.0);
            msLocal.func_227862_a_(itemScale, itemScale, itemScale);
            ms.func_227866_c_().func_227870_a_().func_226595_a_(msLocal.func_227866_c_().func_227870_a_());
            itemRenderer.func_229110_a_(item, ItemCameraTransforms.TransformType.FIXED, light, overlay, ms, buffer);
            ms.func_227865_b_();
        }
    }

    private void renderArm(IVertexBuilder builder, MatrixStack ms, MatrixStack msLocal, MatrixStacker msr, BlockState blockState, int color, float baseAngle, float lowerArmAngle, float upperArmAngle, float headAngle, boolean hasItem, boolean isBlockItem, int light) {
        SuperByteBuffer base = AllBlockPartials.ARM_BASE.renderOn(blockState).light(light);
        SuperByteBuffer lowerBody = AllBlockPartials.ARM_LOWER_BODY.renderOn(blockState).light(light);
        SuperByteBuffer upperBody = AllBlockPartials.ARM_UPPER_BODY.renderOn(blockState).light(light);
        SuperByteBuffer head = AllBlockPartials.ARM_HEAD.renderOn(blockState).light(light);
        SuperByteBuffer claw = AllBlockPartials.ARM_CLAW_BASE.renderOn(blockState).light(light);
        SuperByteBuffer clawGrip = AllBlockPartials.ARM_CLAW_GRIP.renderOn(blockState);
        ArmRenderer.transformBase(msr, baseAngle);
        base.transform(msLocal).renderInto(ms, builder);
        ArmRenderer.transformLowerArm(msr, lowerArmAngle);
        lowerBody.color(color).transform(msLocal).renderInto(ms, builder);
        ArmRenderer.transformUpperArm(msr, upperArmAngle);
        upperBody.color(color).transform(msLocal).renderInto(ms, builder);
        ArmRenderer.transformHead(msr, headAngle);
        head.transform(msLocal).renderInto(ms, builder);
        ArmRenderer.transformClaw(msr);
        claw.transform(msLocal).renderInto(ms, builder);
        for (int flip : Iterate.positiveAndNegative) {
            msLocal.func_227860_a_();
            ArmRenderer.transformClawHalf(msr, hasItem, isBlockItem, flip);
            clawGrip.light(light).transform(msLocal).renderInto(ms, builder);
            msLocal.func_227865_b_();
        }
    }

    private void doItemTransforms(MatrixStacker msr, float baseAngle, float lowerArmAngle, float upperArmAngle, float headAngle) {
        ArmRenderer.transformBase(msr, baseAngle);
        ArmRenderer.transformLowerArm(msr, lowerArmAngle);
        ArmRenderer.transformUpperArm(msr, upperArmAngle);
        ArmRenderer.transformHead(msr, headAngle);
        ArmRenderer.transformClaw(msr);
    }

    public static void transformClawHalf(MatrixStacker msr, boolean hasItem, boolean isBlockItem, int flip) {
        msr.translate(0.0, (double)(flip * 3) / 16.0, -0.0625);
        msr.rotateX(flip * (hasItem ? (isBlockItem ? 0 : -35) : 0));
    }

    public static void transformClaw(MatrixStacker msr) {
        msr.translate(0.0, 0.0, -0.25);
    }

    public static void transformHead(MatrixStacker msr, float headAngle) {
        msr.translate(0.0, 0.6875, -0.6875);
        msr.rotateX(headAngle);
    }

    public static void transformUpperArm(MatrixStacker msr, float upperArmAngle) {
        msr.translate(0.0, 0.75, 0.75);
        msr.rotateX(upperArmAngle);
    }

    public static void transformLowerArm(MatrixStacker msr, float lowerArmAngle) {
        msr.translate(0.0, 0.0625, -0.125);
        msr.rotateX(lowerArmAngle);
        msr.translate(0.0, -0.0625, 0.0);
    }

    public static void transformBase(MatrixStacker msr, float baseAngle) {
        msr.translate(0.0, 0.25, 0.0);
        msr.rotateY(baseAngle);
    }

    @Override
    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        return AllBlockPartials.ARM_COG.renderOn(te.func_195044_w());
    }
}

