/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.mechanicalArm;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmAngleTarget;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmBlock;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widgets.InterpolatedAngle;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.INamedIconOptions;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.JukeboxBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ArmTileEntity
extends KineticTileEntity {
    List<ArmInteractionPoint> inputs = new ArrayList<ArmInteractionPoint>();
    List<ArmInteractionPoint> outputs = new ArrayList<ArmInteractionPoint>();
    ListNBT interactionPointTag = new ListNBT();
    float chasedPointProgress;
    int chasedPointIndex;
    ItemStack heldItem = ItemStack.field_190927_a;
    Phase phase = Phase.SEARCH_INPUTS;
    ArmAngleTarget previousTarget = ArmAngleTarget.NO_TARGET;
    InterpolatedAngle lowerArmAngle;
    InterpolatedAngle upperArmAngle;
    InterpolatedAngle baseAngle = new InterpolatedAngle();
    InterpolatedAngle headAngle;
    InterpolatedAngle clawAngle;
    float previousBaseAngle;
    boolean updateInteractionPoints;
    protected ScrollOptionBehaviour<SelectionMode> selectionMode;
    protected int lastInputIndex = -1;
    protected int lastOutputIndex = -1;
    protected boolean redstoneLocked;

    public ArmTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
        this.baseAngle.init(this.previousTarget.baseAngle);
        this.lowerArmAngle = new InterpolatedAngle();
        this.lowerArmAngle.init(this.previousTarget.lowerArmAngle);
        this.upperArmAngle = new InterpolatedAngle();
        this.upperArmAngle.init(this.previousTarget.upperArmAngle);
        this.headAngle = new InterpolatedAngle();
        this.headAngle.init(this.previousTarget.headAngle);
        this.clawAngle = new InterpolatedAngle();
        this.previousBaseAngle = this.previousTarget.baseAngle;
        this.updateInteractionPoints = true;
        this.redstoneLocked = false;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.selectionMode = new ScrollOptionBehaviour<SelectionMode>(SelectionMode.class, (ITextComponent)Lang.translate("logistics.when_multiple_outputs_available", new Object[0]), this, new SelectionModeValueBox());
        this.selectionMode.requiresWrench();
        behaviours.add(this.selectionMode);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.initInteractionPoints();
        boolean targetReached = this.tickMovementProgress();
        if (this.chasedPointProgress < 1.0f) {
            ArmInteractionPoint point;
            if (this.phase == Phase.MOVE_TO_INPUT && (point = this.getTargetedInteractionPoint()) != null) {
                point.keepAlive((IWorld)this.field_145850_b);
            }
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.phase == Phase.MOVE_TO_INPUT) {
            this.collectItem();
        } else if (this.phase == Phase.MOVE_TO_OUTPUT) {
            this.depositItem();
        } else if (this.phase == Phase.SEARCH_INPUTS || this.phase == Phase.DANCING) {
            this.searchForItem();
        }
        if (targetReached) {
            this.lazyTick();
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.chasedPointProgress < 0.5f) {
            return;
        }
        if (this.phase == Phase.SEARCH_INPUTS || this.phase == Phase.DANCING) {
            this.checkForMusic();
        }
        if (this.phase == Phase.SEARCH_OUTPUTS) {
            this.searchForDestination();
        }
    }

    private void checkForMusic() {
        boolean hasMusic = this.checkForMusicAmong(this.inputs) || this.checkForMusicAmong(this.outputs);
        if (hasMusic != (this.phase == Phase.DANCING)) {
            this.phase = hasMusic ? Phase.DANCING : Phase.SEARCH_INPUTS;
            this.func_70296_d();
            this.sendData();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB makeRenderBoundingBox() {
        return super.makeRenderBoundingBox().func_186662_g(3.0);
    }

    private boolean checkForMusicAmong(List<ArmInteractionPoint> list) {
        for (ArmInteractionPoint armInteractionPoint : list) {
            BlockState state;
            if (!(armInteractionPoint instanceof ArmInteractionPoint.Jukebox) || !(state = this.field_145850_b.func_180495_p(armInteractionPoint.pos)).func_235903_d_((Property)JukeboxBlock.field_176432_a).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean tickMovementProgress() {
        boolean targetReachedPreviously = this.chasedPointProgress >= 1.0f;
        this.chasedPointProgress += Math.min(256.0f, Math.abs(this.getSpeed())) / 1024.0f;
        if (this.chasedPointProgress > 1.0f) {
            this.chasedPointProgress = 1.0f;
        }
        if (!this.field_145850_b.field_72995_K) {
            return !targetReachedPreviously && this.chasedPointProgress >= 1.0f;
        }
        ArmInteractionPoint targetedInteractionPoint = this.getTargetedInteractionPoint();
        ArmAngleTarget previousTarget = this.previousTarget;
        ArmAngleTarget target = targetedInteractionPoint == null ? ArmAngleTarget.NO_TARGET : targetedInteractionPoint.getTargetAngles(this.field_174879_c, this.isOnCeiling());
        this.baseAngle.set(AngleHelper.angleLerp(this.chasedPointProgress, this.previousBaseAngle, target == ArmAngleTarget.NO_TARGET ? (double)this.previousBaseAngle : (double)target.baseAngle));
        if (this.chasedPointProgress < 0.5f) {
            target = ArmAngleTarget.NO_TARGET;
        } else {
            previousTarget = ArmAngleTarget.NO_TARGET;
        }
        float progress = this.chasedPointProgress == 1.0f ? 1.0f : this.chasedPointProgress % 0.5f * 2.0f;
        this.lowerArmAngle.set(MathHelper.func_219799_g((float)progress, (float)previousTarget.lowerArmAngle, (float)target.lowerArmAngle));
        this.upperArmAngle.set(MathHelper.func_219799_g((float)progress, (float)previousTarget.upperArmAngle, (float)target.upperArmAngle));
        this.headAngle.set(AngleHelper.angleLerp(progress, previousTarget.headAngle % 360.0f, target.headAngle % 360.0f));
        return false;
    }

    protected boolean isOnCeiling() {
        BlockState state = this.func_195044_w();
        return this.func_145830_o() && state.func_235903_d_((Property)ArmBlock.CEILING).orElse(false) != false;
    }

    @Nullable
    private ArmInteractionPoint getTargetedInteractionPoint() {
        if (this.chasedPointIndex == -1) {
            return null;
        }
        if (this.phase == Phase.MOVE_TO_INPUT && this.chasedPointIndex < this.inputs.size()) {
            return this.inputs.get(this.chasedPointIndex);
        }
        if (this.phase == Phase.MOVE_TO_OUTPUT && this.chasedPointIndex < this.outputs.size()) {
            return this.outputs.get(this.chasedPointIndex);
        }
        return null;
    }

    protected void searchForItem() {
        int scanRange;
        if (this.redstoneLocked) {
            return;
        }
        boolean foundInput = false;
        int startIndex = this.selectionMode.get() == SelectionMode.PREFER_FIRST ? 0 : this.lastInputIndex + 1;
        int n = scanRange = this.selectionMode.get() == SelectionMode.FORCED_ROUND_ROBIN ? this.lastInputIndex + 2 : this.inputs.size();
        if (scanRange > this.inputs.size()) {
            scanRange = this.inputs.size();
        }
        block0: for (int i = startIndex; i < scanRange; ++i) {
            ArmInteractionPoint armInteractionPoint = this.inputs.get(i);
            if (!armInteractionPoint.isStillValid((IBlockReader)this.field_145850_b)) continue;
            for (int j = 0; j < armInteractionPoint.getSlotCount(this.field_145850_b); ++j) {
                if (this.getDistributableAmount(armInteractionPoint, j) == 0) continue;
                this.selectIndex(true, i);
                foundInput = true;
                break block0;
            }
        }
        if (!foundInput && this.selectionMode.get() == SelectionMode.ROUND_ROBIN) {
            this.lastInputIndex = -1;
        }
        if (this.lastInputIndex == this.inputs.size() - 1) {
            this.lastInputIndex = -1;
        }
    }

    protected void searchForDestination() {
        int scanRange;
        ItemStack held = this.heldItem.func_77946_l();
        boolean foundOutput = false;
        int startIndex = this.selectionMode.get() == SelectionMode.PREFER_FIRST ? 0 : this.lastOutputIndex + 1;
        int n = scanRange = this.selectionMode.get() == SelectionMode.FORCED_ROUND_ROBIN ? this.lastOutputIndex + 2 : this.outputs.size();
        if (scanRange > this.outputs.size()) {
            scanRange = this.outputs.size();
        }
        for (int i = startIndex; i < scanRange; ++i) {
            ItemStack remainder;
            ArmInteractionPoint armInteractionPoint = this.outputs.get(i);
            if (!armInteractionPoint.isStillValid((IBlockReader)this.field_145850_b) || (remainder = armInteractionPoint.insert(this.field_145850_b, held, true)).equals(this.heldItem, false)) continue;
            this.selectIndex(false, i);
            foundOutput = true;
            break;
        }
        if (!foundOutput && this.selectionMode.get() == SelectionMode.ROUND_ROBIN) {
            this.lastOutputIndex = -1;
        }
        if (this.lastOutputIndex == this.outputs.size() - 1) {
            this.lastOutputIndex = -1;
        }
    }

    private void selectIndex(boolean input, int index) {
        this.phase = input ? Phase.MOVE_TO_INPUT : Phase.MOVE_TO_OUTPUT;
        this.chasedPointIndex = index;
        this.chasedPointProgress = 0.0f;
        if (input) {
            this.lastInputIndex = index;
        } else {
            this.lastOutputIndex = index;
        }
        this.sendData();
        this.func_70296_d();
    }

    protected int getDistributableAmount(ArmInteractionPoint armInteractionPoint, int i) {
        ItemStack stack = armInteractionPoint.extract(this.field_145850_b, i, true);
        ItemStack remainder = this.simulateInsertion(stack);
        return stack.func_190916_E() - remainder.func_190916_E();
    }

    protected void depositItem() {
        ArmInteractionPoint armInteractionPoint = this.getTargetedInteractionPoint();
        if (armInteractionPoint != null) {
            ItemStack remainder;
            ItemStack toInsert = this.heldItem.func_77946_l();
            this.heldItem = remainder = armInteractionPoint.insert(this.field_145850_b, toInsert, false);
        }
        this.phase = this.heldItem.func_190926_b() ? Phase.SEARCH_INPUTS : Phase.SEARCH_OUTPUTS;
        this.chasedPointProgress = 0.0f;
        this.chasedPointIndex = -1;
        this.sendData();
        this.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            AllTriggers.triggerForNearbyPlayers(AllTriggers.MECHANICAL_ARM, (IWorld)this.field_145850_b, this.field_174879_c, 10);
        }
    }

    protected void collectItem() {
        ArmInteractionPoint armInteractionPoint = this.getTargetedInteractionPoint();
        if (armInteractionPoint != null) {
            for (int i = 0; i < armInteractionPoint.getSlotCount(this.field_145850_b); ++i) {
                int amountExtracted = this.getDistributableAmount(armInteractionPoint, i);
                if (amountExtracted == 0) continue;
                this.heldItem = armInteractionPoint.extract(this.field_145850_b, i, amountExtracted, false);
                this.phase = Phase.SEARCH_OUTPUTS;
                this.chasedPointProgress = 0.0f;
                this.chasedPointIndex = -1;
                this.sendData();
                this.func_70296_d();
                return;
            }
        }
        this.phase = Phase.SEARCH_INPUTS;
        this.chasedPointProgress = 0.0f;
        this.chasedPointIndex = -1;
        this.sendData();
        this.func_70296_d();
    }

    private ItemStack simulateInsertion(ItemStack stack) {
        ArmInteractionPoint armInteractionPoint;
        Iterator<ArmInteractionPoint> iterator = this.outputs.iterator();
        while (iterator.hasNext() && !(stack = (armInteractionPoint = iterator.next()).insert(this.field_145850_b, stack, true)).func_190926_b()) {
        }
        return stack;
    }

    public void redstoneUpdate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean blockPowered = this.field_145850_b.func_175640_z(this.field_174879_c);
        if (blockPowered == this.redstoneLocked) {
            return;
        }
        this.redstoneLocked = blockPowered;
        this.sendData();
        if (!this.redstoneLocked) {
            this.searchForItem();
        }
    }

    protected void initInteractionPoints() {
        if (!this.updateInteractionPoints || this.interactionPointTag == null) {
            return;
        }
        if (!this.field_145850_b.isAreaLoaded(this.field_174879_c, ArmTileEntity.getRange() + 1)) {
            return;
        }
        this.inputs.clear();
        this.outputs.clear();
        boolean hasBlazeBurner = false;
        for (INBT inbt : this.interactionPointTag) {
            ArmInteractionPoint point = ArmInteractionPoint.deserialize((IBlockReader)this.field_145850_b, this.field_174879_c, (CompoundNBT)inbt);
            if (point == null) continue;
            if (point.mode == ArmInteractionPoint.Mode.DEPOSIT) {
                this.outputs.add(point);
            }
            if (point.mode == ArmInteractionPoint.Mode.TAKE) {
                this.inputs.add(point);
            }
            hasBlazeBurner |= point instanceof ArmInteractionPoint.BlazeBurner;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.outputs.size() >= 10) {
                AllTriggers.triggerForNearbyPlayers(AllTriggers.ARM_MANY_TARGETS, (IWorld)this.field_145850_b, this.field_174879_c, 5);
            }
            if (hasBlazeBurner) {
                AllTriggers.triggerForNearbyPlayers(AllTriggers.ARM_BLAZE_BURNER, (IWorld)this.field_145850_b, this.field_174879_c, 5);
            }
        }
        this.updateInteractionPoints = false;
        this.sendData();
        this.func_70296_d();
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (this.updateInteractionPoints) {
            compound.func_218657_a("InteractionPoints", (INBT)this.interactionPointTag);
        } else {
            ListNBT pointsNBT = new ListNBT();
            this.inputs.stream().map(aip -> aip.serialize(this.field_174879_c)).forEach(arg_0 -> pointsNBT.add(arg_0));
            this.outputs.stream().map(aip -> aip.serialize(this.field_174879_c)).forEach(arg_0 -> pointsNBT.add(arg_0));
            compound.func_218657_a("InteractionPoints", (INBT)pointsNBT);
        }
        NBTHelper.writeEnum(compound, "Phase", this.phase);
        compound.func_74757_a("Powered", this.redstoneLocked);
        compound.func_218657_a("HeldItem", (INBT)this.heldItem.serializeNBT());
        compound.func_74768_a("TargetPointIndex", this.chasedPointIndex);
        compound.func_74776_a("MovementProgress", this.chasedPointProgress);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        int previousIndex = this.chasedPointIndex;
        Phase previousPhase = this.phase;
        ListNBT interactionPointTagBefore = this.interactionPointTag;
        super.fromTag(state, compound, clientPacket);
        this.heldItem = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("HeldItem"));
        this.phase = NBTHelper.readEnum(compound, "Phase", Phase.class);
        this.chasedPointIndex = compound.func_74762_e("TargetPointIndex");
        this.chasedPointProgress = compound.func_74760_g("MovementProgress");
        this.interactionPointTag = compound.func_150295_c("InteractionPoints", 10);
        this.redstoneLocked = compound.func_74767_n("Powered");
        if (!clientPacket) {
            return;
        }
        boolean ceiling = this.isOnCeiling();
        if (interactionPointTagBefore == null || interactionPointTagBefore.size() != this.interactionPointTag.size()) {
            this.updateInteractionPoints = true;
        }
        if (previousIndex != this.chasedPointIndex || previousPhase != this.phase) {
            ArmInteractionPoint previousPoint = null;
            if (previousPhase == Phase.MOVE_TO_INPUT && previousIndex < this.inputs.size()) {
                previousPoint = this.inputs.get(previousIndex);
            }
            if (previousPhase == Phase.MOVE_TO_OUTPUT && previousIndex < this.outputs.size()) {
                previousPoint = this.outputs.get(previousIndex);
            }
            ArmAngleTarget armAngleTarget = this.previousTarget = previousPoint == null ? ArmAngleTarget.NO_TARGET : previousPoint.getTargetAngles(this.field_174879_c, ceiling);
            if (previousPoint != null) {
                this.previousBaseAngle = previousPoint.getTargetAngles((BlockPos)this.field_174879_c, (boolean)ceiling).baseAngle;
            }
        }
    }

    public static int getRange() {
        return (Integer)AllConfigs.SERVER.logistics.mechanicalArmRange.get();
    }

    @Override
    public boolean addToTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        if (super.addToTooltip(tooltip, isPlayerSneaking)) {
            return true;
        }
        if (isPlayerSneaking) {
            return false;
        }
        if (!this.inputs.isEmpty()) {
            return false;
        }
        if (!this.outputs.isEmpty()) {
            return false;
        }
        TooltipHelper.addHint(tooltip, "hint.mechanical_arm_no_targets", new Object[0]);
        return true;
    }

    @Override
    public boolean shouldRenderAsTE() {
        return true;
    }

    public static enum SelectionMode implements INamedIconOptions
    {
        ROUND_ROBIN(AllIcons.I_ARM_ROUND_ROBIN),
        FORCED_ROUND_ROBIN(AllIcons.I_ARM_FORCED_ROUND_ROBIN),
        PREFER_FIRST(AllIcons.I_ARM_PREFER_FIRST);

        private final String translationKey;
        private final AllIcons icon;

        private SelectionMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "mechanical_arm.selection_mode." + Lang.asId(this.name());
        }

        @Override
        public AllIcons getIcon() {
            return this.icon;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    private class SelectionModeValueBox
    extends CenteredSideValueBoxTransform {
        public SelectionModeValueBox() {
            super((BlockState blockState, Direction direction) -> direction != Direction.DOWN && direction != Direction.UP);
        }

        @Override
        protected Vector3d getLocalOffset(BlockState state) {
            int yPos = (Boolean)state.func_177229_b((Property)ArmBlock.CEILING) != false ? 13 : 3;
            Vector3d location = VecHelper.voxelSpace(8.0, yPos, 15.95);
            location = VecHelper.rotateCentered(location, AngleHelper.horizontalAngle(this.getSide()), Direction.Axis.Y);
            return location;
        }

        @Override
        protected float getScale() {
            return 0.3f;
        }
    }

    public static enum Phase {
        SEARCH_INPUTS,
        MOVE_TO_INPUT,
        SEARCH_OUTPUTS,
        MOVE_TO_OUTPUT,
        DANCING;

    }
}

