/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.logistics.block.redstone.AnalogLeverBlock;
import com.simibubi.create.content.logistics.block.redstone.AnalogLeverTileEntity;
import com.simibubi.create.foundation.render.backend.core.ModelData;
import com.simibubi.create.foundation.render.backend.instancing.IDynamicInstance;
import com.simibubi.create.foundation.render.backend.instancing.InstancedModel;
import com.simibubi.create.foundation.render.backend.instancing.InstancedTileRenderer;
import com.simibubi.create.foundation.render.backend.instancing.RenderMaterial;
import com.simibubi.create.foundation.render.backend.instancing.TileEntityInstance;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.MatrixStacker;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3i;

public class AnalogLeverInstance
extends TileEntityInstance<AnalogLeverTileEntity>
implements IDynamicInstance {
    protected final ModelData handle;
    protected final ModelData indicator;
    final float rX;
    final float rY;

    public AnalogLeverInstance(InstancedTileRenderer<?> modelManager, AnalogLeverTileEntity tile) {
        super(modelManager, tile);
        RenderMaterial<?, InstancedModel<ModelData>> mat = this.getTransformMaterial();
        this.handle = mat.getModel(AllBlockPartials.ANALOG_LEVER_HANDLE, this.blockState).createInstance();
        this.indicator = mat.getModel(AllBlockPartials.ANALOG_LEVER_INDICATOR, this.blockState).createInstance();
        AttachFace face = (AttachFace)this.blockState.func_177229_b((Property)AnalogLeverBlock.field_196366_M);
        this.rX = face == AttachFace.FLOOR ? 0.0f : (face == AttachFace.WALL ? 90.0f : 180.0f);
        this.rY = AngleHelper.horizontalAngle((Direction)this.blockState.func_177229_b((Property)AnalogLeverBlock.field_185512_D));
        this.animateLever();
    }

    @Override
    public void beginFrame() {
        if (!((AnalogLeverTileEntity)this.tile).clientState.settled()) {
            this.animateLever();
        }
    }

    protected void animateLever() {
        MatrixStack ms = new MatrixStack();
        MatrixStacker msr = MatrixStacker.of(ms);
        msr.translate((Vector3i)this.getInstancePosition());
        this.transform(msr);
        float state = ((AnalogLeverTileEntity)this.tile).clientState.get(AnimationTickHolder.getPartialTicks());
        int color = ColorHelper.mixColors(2884352, 0xCD0000, state / 15.0f);
        this.indicator.setTransform(ms).setColor(color);
        float angle = (float)((double)(state / 15.0f * 90.0f / 180.0f) * Math.PI);
        msr.translate(0.5, 0.0625, 0.5).rotate(Direction.EAST, angle).translate(-0.5, -0.0625, -0.5);
        this.handle.setTransform(ms);
    }

    @Override
    public void remove() {
        this.handle.delete();
        this.indicator.delete();
    }

    @Override
    public void updateLight() {
        this.relight(this.pos, this.handle, this.indicator);
    }

    private void transform(MatrixStacker msr) {
        msr.centre().rotate(Direction.UP, (float)((double)(this.rY / 180.0f) * Math.PI)).rotate(Direction.EAST, (float)((double)(this.rX / 180.0f) * Math.PI)).unCentre();
    }
}

