/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.simibubi.create.Create;
import com.simibubi.create.content.schematics.packet.SchematicUploadPacket;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientSchematicLoader {
    public static final int PACKET_DELAY = 10;
    private List<ITextComponent> availableSchematics = new ArrayList<ITextComponent>();
    private Map<String, InputStream> activeUploads = new HashMap<String, InputStream>();
    private int packetCycle;

    public ClientSchematicLoader() {
        this.refresh();
    }

    public void tick() {
        if (this.activeUploads.isEmpty()) {
            return;
        }
        if (this.packetCycle-- > 0) {
            return;
        }
        this.packetCycle = 10;
        for (String schematic : new HashSet<String>(this.activeUploads.keySet())) {
            this.continueUpload(schematic);
        }
    }

    public void startNewUpload(String schematic) {
        Path path = Paths.get("schematics", schematic);
        if (!Files.exists(path, new LinkOption[0])) {
            Create.logger.fatal("Missing Schematic file: " + path.toString());
            return;
        }
        try {
            long size = Files.size(path);
            if (!ClientSchematicLoader.validateSizeLimitation(size)) {
                return;
            }
            InputStream in = Files.newInputStream(path, StandardOpenOption.READ);
            this.activeUploads.put(schematic, in);
            AllPackets.channel.sendToServer((Object)SchematicUploadPacket.begin(schematic, size));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean validateSizeLimitation(long size) {
        if (Minecraft.func_71410_x().func_71356_B()) {
            return true;
        }
        Integer maxSize = (Integer)AllConfigs.SERVER.schematics.maxTotalSchematicSize.get();
        if (size > (long)(maxSize * 1000)) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                player.func_145747_a((ITextComponent)Lang.translate("schematics.uploadTooLarge", new Object[0]).func_240702_b_(" (" + size / 1000L + " KB)."), player.func_110124_au());
                player.func_145747_a((ITextComponent)Lang.translate("schematics.maxAllowedSize", new Object[0]).func_240702_b_(" " + maxSize + " KB"), player.func_110124_au());
            }
            return false;
        }
        return true;
    }

    private void continueUpload(String schematic) {
        if (this.activeUploads.containsKey(schematic)) {
            Integer maxPacketSize = (Integer)AllConfigs.SERVER.schematics.maxSchematicPacketSize.get();
            byte[] data = new byte[maxPacketSize.intValue()];
            try {
                int status = this.activeUploads.get(schematic).read(data);
                if (status != -1) {
                    if (status < maxPacketSize) {
                        data = Arrays.copyOf(data, status);
                    }
                    if (Minecraft.func_71410_x().field_71441_e != null) {
                        AllPackets.channel.sendToServer((Object)SchematicUploadPacket.write(schematic, data));
                    } else {
                        this.activeUploads.remove(schematic);
                        return;
                    }
                }
                if (status < maxPacketSize) {
                    this.finishUpload(schematic);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void finishUpload(String schematic) {
        if (this.activeUploads.containsKey(schematic)) {
            AllPackets.channel.sendToServer((Object)SchematicUploadPacket.finish(schematic));
            this.activeUploads.remove(schematic);
        }
    }

    public void refresh() {
        FilesHelper.createFolderIfMissing("schematics");
        this.availableSchematics.clear();
        try {
            Files.list(Paths.get("schematics/", new String[0])).filter(f -> !Files.isDirectory(f, new LinkOption[0]) && f.getFileName().toString().endsWith(".nbt")).forEach(path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    return;
                }
                this.availableSchematics.add((ITextComponent)new StringTextComponent(path.getFileName().toString()));
            });
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.availableSchematics.sort((aT, bT) -> {
            String a = aT.getString();
            String b = bT.getString();
            if (a.endsWith(".nbt")) {
                a = a.substring(0, a.length() - 4);
            }
            if (b.endsWith(".nbt")) {
                b = b.substring(0, b.length() - 4);
            }
            int aLength = a.length();
            int bLength = b.length();
            int minSize = Math.min(aLength, bLength);
            boolean asNumeric = false;
            int lastNumericCompare = 0;
            for (int i = 0; i < minSize; ++i) {
                boolean bNumber;
                char aChar = a.charAt(i);
                char bChar = b.charAt(i);
                boolean aNumber = aChar >= '0' && aChar <= '9';
                boolean bl = bNumber = bChar >= '0' && bChar <= '9';
                if (asNumeric) {
                    if (aNumber && bNumber) {
                        if (lastNumericCompare != 0) continue;
                        lastNumericCompare = aChar - bChar;
                        continue;
                    }
                    if (aNumber) {
                        return 1;
                    }
                    if (bNumber) {
                        return -1;
                    }
                    if (lastNumericCompare == 0) {
                        if (aChar != bChar) {
                            return aChar - bChar;
                        }
                        asNumeric = false;
                        continue;
                    }
                    return lastNumericCompare;
                }
                if (aNumber && bNumber) {
                    asNumeric = true;
                    if (lastNumericCompare != 0) continue;
                    lastNumericCompare = aChar - bChar;
                    continue;
                }
                if (aChar == bChar) continue;
                return aChar - bChar;
            }
            if (asNumeric) {
                if (aLength > bLength && a.charAt(bLength) >= '0' && a.charAt(bLength) <= '9') {
                    return 1;
                }
                if (bLength > aLength && b.charAt(aLength) >= '0' && b.charAt(aLength) <= '9') {
                    return -1;
                }
                if (lastNumericCompare == 0) {
                    return aLength - bLength;
                }
                return lastNumericCompare;
            }
            return aLength - bLength;
        });
    }

    public List<ITextComponent> getAvailableSchematics() {
        return this.availableSchematics;
    }

    public Path getPath(String name) {
        return Paths.get("schematics", name + ".nbt");
    }
}

