/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.block.BlockState;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.tileentity.CommandBlockLogic;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.mutable.MutableInt;

public class ReplaceInCommandBlocksCommand {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"replaceInCommandBlocks").requires(cs -> cs.func_197034_c(0))).then(Commands.func_197056_a((String)"begin", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"end", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"toReplace", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"replaceWith", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            ReplaceInCommandBlocksCommand.doReplace((CommandSource)ctx.getSource(), BlockPosArgument.func_197273_a((CommandContext)ctx, (String)"begin"), BlockPosArgument.func_197273_a((CommandContext)ctx, (String)"end"), StringArgumentType.getString((CommandContext)ctx, (String)"toReplace"), StringArgumentType.getString((CommandContext)ctx, (String)"replaceWith"));
            return 1;
        })))));
    }

    private static void doReplace(CommandSource source, BlockPos from, BlockPos to, String toReplace, String replaceWith) {
        ServerWorld world = source.func_197023_e();
        MutableInt blocks = new MutableInt(0);
        BlockPos.func_218281_b((BlockPos)from, (BlockPos)to).forEach(pos -> {
            BlockState blockState = world.func_180495_p(pos);
            if (!(blockState.func_177230_c() instanceof CommandBlockBlock)) {
                return;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (!(tileEntity instanceof CommandBlockTileEntity)) {
                return;
            }
            CommandBlockTileEntity cb = (CommandBlockTileEntity)tileEntity;
            CommandBlockLogic commandBlockLogic = cb.func_145993_a();
            String command = commandBlockLogic.func_145753_i();
            if (command.indexOf(toReplace) != -1) {
                blocks.increment();
            }
            commandBlockLogic.func_145752_a(command.replaceAll(toReplace, replaceWith));
            cb.func_70296_d();
            world.func_184138_a(pos, blockState, blockState, 2);
        });
        int intValue = blocks.intValue();
        if (intValue == 0) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Couldn't find \"" + toReplace + "\" anywhere."), true);
            return;
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Replaced occurrences in " + intValue + " blocks."), true);
    }
}

