/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config;

import com.simibubi.create.foundation.config.CStress;
import com.simibubi.create.foundation.config.ConfigBase;

public class CKinetics
extends ConfigBase {
    public ConfigBase.ConfigBool disableStress = this.b(false, "disableStress", Comments.disableStress);
    public ConfigBase.ConfigInt maxBeltLength = this.i(20, 5, "maxBeltLength", Comments.maxBeltLength);
    public ConfigBase.ConfigInt crushingDamage = this.i(4, 0, "crushingDamage", Comments.crushingDamage);
    public ConfigBase.ConfigInt maxMotorSpeed = this.i(256, 64, "maxMotorSpeed", Comments.rpm, Comments.maxMotorSpeed);
    public ConfigBase.ConfigInt waterWheelBaseSpeed = this.i(4, 1, "waterWheelBaseSpeed", Comments.rpm, Comments.waterWheelBaseSpeed);
    public ConfigBase.ConfigInt waterWheelFlowSpeed = this.i(4, 1, "waterWheelFlowSpeed", Comments.rpm, Comments.waterWheelFlowSpeed);
    public ConfigBase.ConfigInt furnaceEngineSpeed = this.i(16, 1, "furnaceEngineSpeed", Comments.rpm, Comments.furnaceEngineSpeed);
    public ConfigBase.ConfigInt maxRotationSpeed = this.i(256, 64, "maxRotationSpeed", Comments.rpm, Comments.maxRotationSpeed);
    public ConfigBase.ConfigEnum<DeployerAggroSetting> ignoreDeployerAttacks = this.e(DeployerAggroSetting.CREEPERS, "ignoreDeployerAttacks", Comments.ignoreDeployerAttacks);
    public ConfigBase.ConfigInt kineticValidationFrequency = this.i(60, 5, "kineticValidationFrequency", Comments.kineticValidationFrequency);
    public ConfigBase.ConfigFloat crankHungerMultiplier = this.f(0.01f, 0.0f, 1.0f, "crankHungerMultiplier", Comments.crankHungerMultiplier);
    public ConfigBase.ConfigInt minimumWindmillSails = this.i(8, 0, "minimumWindmillSails", Comments.minimumWindmillSails);
    public ConfigBase.ConfigInt maxEjectorDistance = this.i(32, 0, "maxEjectorDistance", Comments.maxEjectorDistance);
    public ConfigBase.ConfigInt ejectorScanInterval = this.i(120, 10, "ejectorScanInterval", Comments.ejectorScanInterval);
    public ConfigBase.ConfigGroup fan = this.group(1, "encasedFan", "Encased Fan");
    public ConfigBase.ConfigInt fanPushDistance = this.i(20, 5, "fanPushDistance", Comments.fanPushDistance);
    public ConfigBase.ConfigInt fanPullDistance = this.i(20, 5, "fanPullDistance", Comments.fanPullDistance);
    public ConfigBase.ConfigInt fanBlockCheckRate = this.i(30, 10, "fanBlockCheckRate", Comments.fanBlockCheckRate);
    public ConfigBase.ConfigInt fanRotationArgmax = this.i(256, 64, "fanRotationArgmax", Comments.rpm, Comments.fanRotationArgmax);
    public ConfigBase.ConfigInt generatingFanSpeed = this.i(4, 0, "generatingFanSpeed", Comments.rpm, Comments.generatingFanSpeed);
    public ConfigBase.ConfigInt inWorldProcessingTime = this.i(150, 0, "inWorldProcessingTime", Comments.inWorldProcessingTime);
    public ConfigBase.ConfigGroup contraptions = this.group(1, "contraptions", "Moving Contraptions");
    public ConfigBase.ConfigInt maxBlocksMoved = this.i(2048, 1, "maxBlocksMoved", Comments.maxBlocksMoved);
    public ConfigBase.ConfigInt maxChassisRange = this.i(16, 1, "maxChassisRange", Comments.maxChassisRange);
    public ConfigBase.ConfigInt maxPistonPoles = this.i(64, 1, "maxPistonPoles", Comments.maxPistonPoles);
    public ConfigBase.ConfigInt maxRopeLength = this.i(128, 1, "maxRopeLength", Comments.maxRopeLength);
    public ConfigBase.ConfigInt maxCartCouplingLength = this.i(32, 1, "maxCartCouplingLength", Comments.maxCartCouplingLength);
    public CStress stressValues = this.nested(1, CStress::new, Comments.stress);
    public ConfigBase.ConfigGroup state = this.group(1, "stats", Comments.stats);
    public ConfigBase.ConfigFloat mediumSpeed = this.f(30.0f, 0.0f, 4096.0f, "mediumSpeed", Comments.rpm, Comments.mediumSpeed);
    public ConfigBase.ConfigFloat fastSpeed = this.f(100.0f, 0.0f, 65535.0f, "fastSpeed", Comments.rpm, Comments.fastSpeed);
    public ConfigBase.ConfigFloat mediumStressImpact = this.f(4.0f, 0.0f, 4096.0f, "mediumStressImpact", Comments.su, Comments.mediumStressImpact);
    public ConfigBase.ConfigFloat highStressImpact = this.f(8.0f, 0.0f, 65535.0f, "highStressImpact", Comments.su, Comments.highStressImpact);
    public ConfigBase.ConfigFloat mediumCapacity = this.f(128.0f, 0.0f, 4096.0f, "mediumCapacity", Comments.su, Comments.mediumCapacity);
    public ConfigBase.ConfigFloat highCapacity = this.f(512.0f, 0.0f, 65535.0f, "highCapacity", Comments.su, Comments.highCapacity);

    @Override
    public String getName() {
        return "kinetics";
    }

    public static enum DeployerAggroSetting {
        ALL,
        CREEPERS,
        NONE;

    }

    private static class Comments {
        static String maxBeltLength = "Maximum length in blocks of mechanical belts.";
        static String crushingDamage = "Damage dealt by active Crushing Wheels.";
        static String maxMotorSpeed = "Maximum allowed speed of a configurable motor.";
        static String maxRotationSpeed = "Maximum allowed rotation speed for any Kinetic Tile.";
        static String fanPushDistance = "Maximum distance in blocks Fans can push entities.";
        static String fanPullDistance = "Maximum distance in blocks from where Fans can pull entities.";
        static String fanBlockCheckRate = "Game ticks between Fans checking for anything blocking their air flow.";
        static String fanRotationArgmax = "Rotation speed at which the maximum stats of fans are reached.";
        static String generatingFanSpeed = "Rotation speed generated by a vertical fan above fire.";
        static String inWorldProcessingTime = "Game ticks required for a Fan-based processing recipe to take effect.";
        static String crankHungerMultiplier = "multiplier used for calculating exhaustion from speed when a crank is turned.";
        static String maxBlocksMoved = "Maximum amount of blocks in a structure movable by Pistons, Bearings or other means.";
        static String maxChassisRange = "Maximum value of a chassis attachment range.";
        static String maxPistonPoles = "Maximum amount of extension poles behind a Mechanical Piston.";
        static String maxRopeLength = "Max length of rope available off a Rope Pulley.";
        static String maxCartCouplingLength = "Maximum allowed distance of two coupled minecarts.";
        static String stats = "Configure speed/capacity levels for requirements and indicators.";
        static String rpm = "[in Revolutions per Minute]";
        static String su = "[in Stress Units]";
        static String mediumSpeed = "Minimum speed of rotation to be considered 'medium'";
        static String fastSpeed = "Minimum speed of rotation to be considered 'fast'";
        static String mediumStressImpact = "Minimum stress impact to be considered 'medium'";
        static String highStressImpact = "Minimum stress impact to be considered 'high'";
        static String mediumCapacity = "Minimum added Capacity by sources to be considered 'medium'";
        static String highCapacity = "Minimum added Capacity by sources to be considered 'high'";
        static String stress = "Fine tune the kinetic stats of individual components";
        static String ignoreDeployerAttacks = "Select what mobs should ignore Deployers when attacked by them.";
        static String waterWheelBaseSpeed = "Added rotation speed by a water wheel when at least one flow is present.";
        static String waterWheelFlowSpeed = "Rotation speed gained by a water wheel for each side with running fluids. (halved if not against blades)";
        static String furnaceEngineSpeed = "Base rotation speed for the furnace engine generator";
        static String disableStress = "Disable the Stress mechanic altogether.";
        static String kineticValidationFrequency = "Game ticks between Kinetic Blocks checking whether their source is still valid.";
        static String minimumWindmillSails = "Amount of sail-type blocks required for a windmill to assemble successfully.";
        static String maxEjectorDistance = "Max Distance in blocks a Weighted Ejector can throw";
        static String ejectorScanInterval = "Time in ticks until the next item launched by an ejector scans blocks for potential collisions";

        private Comments() {
        }
    }
}

