/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.mixin;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionHandler;
import java.lang.ref.Reference;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import org.apache.logging.log4j.util.TriConsumer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityContraptionInteractionMixin
extends CapabilityProvider<Entity> {
    private final Entity self = (Entity)this;
    private AbstractContraptionEntity contraption;
    @Final
    @Shadow
    protected Random field_70146_Z;
    @Shadow
    private float field_70150_b;

    private EntityContraptionInteractionMixin(Class<Entity> baseClass) {
        super(baseClass);
    }

    @Shadow
    protected abstract float func_203009_ad();

    @Shadow
    protected abstract void func_180429_a(BlockPos var1, BlockState var2);

    private Set<AbstractContraptionEntity> getIntersectingContraptions() {
        Set<AbstractContraptionEntity> contraptions = ContraptionHandler.loadedContraptions.get((IWorld)this.self.field_70170_p).values().stream().map(Reference::get).filter(cEntity -> cEntity != null && cEntity.collidingEntities.containsKey(this.self)).collect(Collectors.toSet());
        contraptions.addAll(this.self.field_70170_p.func_217357_a(AbstractContraptionEntity.class, this.self.func_174813_aQ().func_186662_g(1.0)));
        return contraptions;
    }

    private void forCollision(Vector3d anchorPos, TriConsumer<Contraption, BlockState, BlockPos> action) {
        this.getIntersectingContraptions().forEach(cEntity -> {
            Vector3d localPos = ContraptionCollider.getWorldToLocalTranslation(anchorPos, cEntity);
            localPos = anchorPos.func_178787_e(localPos);
            BlockPos blockPos = new BlockPos(localPos);
            Contraption contraption = cEntity.getContraption();
            Template.BlockInfo info = contraption.getBlocks().get(blockPos);
            if (info != null) {
                BlockState blockstate = info.field_186243_b;
                action.accept((Object)contraption, (Object)blockstate, (Object)blockPos);
            }
        });
    }

    @Inject(at={@At(value="JUMP", opcode=154, ordinal=4)}, method={"move"})
    private void movementMixin(MoverType mover, Vector3d movement, CallbackInfo ci) {
        Vector3d worldPos = this.self.func_213303_ch().func_72441_c(0.0, -0.2, 0.0);
        AtomicBoolean stepped = new AtomicBoolean(false);
        this.forCollision(worldPos, (TriConsumer<Contraption, BlockState, BlockPos>)((TriConsumer)(contraption, blockstate, blockPos) -> {
            this.bindContraption((Contraption)contraption);
            this.func_180429_a((BlockPos)blockPos, (BlockState)blockstate);
            this.unbindContraption();
            stepped.set(true);
        }));
        if (stepped.get()) {
            this.field_70150_b = this.func_203009_ad();
        }
    }

    @Inject(method={"spawnSprintingParticles"}, at={@At(value="TAIL")})
    private void createRunningParticlesMixin(CallbackInfo ci) {
        Vector3d worldPos = this.self.func_213303_ch().func_72441_c(0.0, -0.2, 0.0);
        BlockPos pos = new BlockPos(worldPos);
        this.forCollision(worldPos, (TriConsumer<Contraption, BlockState, BlockPos>)((TriConsumer)(contraption, blockstate, blockpos) -> {
            if (!blockstate.addRunningEffects(this.self.field_70170_p, blockpos, this.self) && blockstate.func_185901_i() != BlockRenderType.INVISIBLE) {
                Vector3d vec3d = this.self.func_213322_ci();
                this.self.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(pos), this.self.func_226277_ct_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.self.func_213311_cf(), this.self.func_226278_cu_() + 0.1, this.self.func_226281_cx_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.self.func_213311_cf(), vec3d.field_72450_a * -4.0, 1.5, vec3d.field_72449_c * -4.0);
            }
        }));
    }

    @Inject(method={"playSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void playSoundShifted(SoundEvent event, float pitch, float volume, CallbackInfo ci) {
        if (this.contraption != null && (!this.self.func_174814_R() || this.self instanceof PlayerEntity)) {
            double x = this.self.func_226277_ct_();
            double y = this.self.func_226278_cu_();
            double z = this.self.func_226281_cx_();
            Vector3d worldPos = ContraptionCollider.getWorldToLocalTranslation(new Vector3d(x, y, z), this.contraption);
            worldPos = worldPos.func_72441_c(x, y, z);
            this.self.field_70170_p.func_184148_a(null, worldPos.field_72450_a + x, worldPos.field_72448_b + y, worldPos.field_72449_c + z, event, this.self.func_184176_by(), pitch, volume);
            ci.cancel();
        }
    }

    private void bindContraption(Contraption contraption) {
        this.bindContraption(contraption.entity);
    }

    private void bindContraption(AbstractContraptionEntity contraption) {
        this.contraption = contraption;
    }

    private void unbindContraption() {
        this.contraption = null;
    }
}

