/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.crafter.ConnectedInputHandler;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueItem;
import com.simibubi.create.content.contraptions.particle.RotationIndicatorParticleData;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.contraptions.relays.gauge.SpeedGaugeTileEntity;
import com.simibubi.create.content.logistics.block.funnel.FunnelTileEntity;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmTileEntity;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderInstruction;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.content.PonderPalette;
import com.simibubi.create.foundation.ponder.elements.AnimatedSceneElement;
import com.simibubi.create.foundation.ponder.elements.BeltItemElement;
import com.simibubi.create.foundation.ponder.elements.EntityElement;
import com.simibubi.create.foundation.ponder.elements.InputWindowElement;
import com.simibubi.create.foundation.ponder.elements.MinecartElement;
import com.simibubi.create.foundation.ponder.elements.ParrotElement;
import com.simibubi.create.foundation.ponder.elements.TextWindowElement;
import com.simibubi.create.foundation.ponder.elements.WorldSectionElement;
import com.simibubi.create.foundation.ponder.instructions.AnimateMinecartInstruction;
import com.simibubi.create.foundation.ponder.instructions.AnimateParrotInstruction;
import com.simibubi.create.foundation.ponder.instructions.AnimateTileEntityInstruction;
import com.simibubi.create.foundation.ponder.instructions.AnimateWorldSectionInstruction;
import com.simibubi.create.foundation.ponder.instructions.ChaseAABBInstruction;
import com.simibubi.create.foundation.ponder.instructions.CreateMinecartInstruction;
import com.simibubi.create.foundation.ponder.instructions.CreateParrotInstruction;
import com.simibubi.create.foundation.ponder.instructions.DelayInstruction;
import com.simibubi.create.foundation.ponder.instructions.DisplayWorldSectionInstruction;
import com.simibubi.create.foundation.ponder.instructions.EmitParticlesInstruction;
import com.simibubi.create.foundation.ponder.instructions.FadeOutOfSceneInstruction;
import com.simibubi.create.foundation.ponder.instructions.HighlightValueBoxInstruction;
import com.simibubi.create.foundation.ponder.instructions.KeyframeInstruction;
import com.simibubi.create.foundation.ponder.instructions.LineInstruction;
import com.simibubi.create.foundation.ponder.instructions.MarkAsFinishedInstruction;
import com.simibubi.create.foundation.ponder.instructions.MovePoiInstruction;
import com.simibubi.create.foundation.ponder.instructions.OutlineSelectionInstruction;
import com.simibubi.create.foundation.ponder.instructions.ReplaceBlocksInstruction;
import com.simibubi.create.foundation.ponder.instructions.RotateSceneInstruction;
import com.simibubi.create.foundation.ponder.instructions.ShowInputInstruction;
import com.simibubi.create.foundation.ponder.instructions.TextInstruction;
import com.simibubi.create.foundation.ponder.instructions.TileEntityDataInstruction;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class SceneBuilder {
    public final OverlayInstructions overlay;
    public final WorldInstructions world;
    public final DebugInstructions debug;
    public final EffectInstructions effects;
    public final SpecialInstructions special;
    private final PonderScene scene;

    public SceneBuilder(PonderScene ponderScene) {
        this.scene = ponderScene;
        this.overlay = new OverlayInstructions();
        this.special = new SpecialInstructions();
        this.world = new WorldInstructions();
        this.debug = new DebugInstructions();
        this.effects = new EffectInstructions();
    }

    public void title(String sceneId, String title) {
        this.scene.sceneId = sceneId;
        PonderLocalization.registerSpecific(sceneId, "header", title);
    }

    public void configureBasePlate(int xOffset, int zOffset, int basePlateSize) {
        this.scene.basePlateOffsetX = xOffset;
        this.scene.basePlateOffsetZ = zOffset;
        this.scene.basePlateSize = basePlateSize;
    }

    public void scaleSceneView(float factor) {
        this.scene.scaleFactor = factor;
    }

    public void setSceneOffsetY(float yOffset) {
        this.scene.yOffset = yOffset;
    }

    public void showBasePlate() {
        this.world.showSection(this.scene.getSceneBuildingUtil().select.cuboid(new BlockPos(this.scene.basePlateOffsetX, 0, this.scene.basePlateOffsetZ), new Vector3i(this.scene.basePlateSize - 1, 0, this.scene.basePlateSize - 1)), Direction.UP);
    }

    public void idle(int ticks) {
        this.addInstruction(new DelayInstruction(ticks));
    }

    public void idleSeconds(int seconds) {
        this.idle(seconds * 20);
    }

    public void markAsFinished() {
        this.addInstruction(new MarkAsFinishedInstruction());
    }

    public void rotateCameraY(float degrees) {
        this.addInstruction(new RotateSceneInstruction(0.0f, degrees, true));
    }

    public void addKeyframe() {
        this.addInstruction(KeyframeInstruction.IMMEDIATE);
    }

    public void addLazyKeyframe() {
        this.addInstruction(KeyframeInstruction.DELAYED);
    }

    private void addInstruction(PonderInstruction instruction) {
        this.scene.schedule.add(instruction);
    }

    private void addInstruction(Consumer<PonderScene> callback) {
        this.scene.schedule.add(PonderInstruction.simple(callback));
    }

    public class DebugInstructions {
        public void debugSchematic() {
            SceneBuilder.this.addInstruction(scene -> scene.addElement(new WorldSectionElement(scene.getSceneBuildingUtil().select.everywhere())));
        }

        public void addInstructionInstance(PonderInstruction instruction) {
            SceneBuilder.this.addInstruction(instruction);
        }

        public void enqueueCallback(Consumer<PonderScene> callback) {
            SceneBuilder.this.addInstruction(callback);
        }
    }

    public class WorldInstructions {
        public void incrementBlockBreakingProgress(BlockPos pos) {
            SceneBuilder.this.addInstruction(scene -> {
                PonderWorld world = scene.getWorld();
                int progress = world.getBlockBreakingProgressions().getOrDefault(pos, -1) + 1;
                if (progress == 9) {
                    world.addBlockDestroyEffects(pos, world.func_180495_p(pos));
                    world.func_175655_b(pos, false);
                    world.setBlockBreakingProgress(pos, 0);
                    scene.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
                } else {
                    world.setBlockBreakingProgress(pos, progress + 1);
                }
            });
        }

        public void showSection(Selection selection, Direction fadeInDirection) {
            SceneBuilder.this.addInstruction(new DisplayWorldSectionInstruction(15, fadeInDirection, selection, Optional.of(SceneBuilder.this.scene::getBaseWorldSection)));
        }

        public void showSectionAndMerge(Selection selection, Direction fadeInDirection, ElementLink<WorldSectionElement> link) {
            SceneBuilder.this.addInstruction(new DisplayWorldSectionInstruction(15, fadeInDirection, selection, Optional.of(() -> (WorldSectionElement)SceneBuilder.this.scene.resolve(link))));
        }

        public void glueBlockOnto(BlockPos position, Direction fadeInDirection, ElementLink<WorldSectionElement> link) {
            SceneBuilder.this.addInstruction(new DisplayWorldSectionInstruction(15, fadeInDirection, ((SceneBuilder)SceneBuilder.this).scene.getSceneBuildingUtil().select.position(position), Optional.of(() -> (WorldSectionElement)SceneBuilder.this.scene.resolve(link)), position));
        }

        public ElementLink<WorldSectionElement> showIndependentSection(Selection selection, Direction fadeInDirection) {
            DisplayWorldSectionInstruction instruction = new DisplayWorldSectionInstruction(15, fadeInDirection, selection, Optional.empty());
            SceneBuilder.this.addInstruction(instruction);
            return instruction.createLink(SceneBuilder.this.scene);
        }

        public ElementLink<WorldSectionElement> showIndependentSectionImmediately(Selection selection) {
            DisplayWorldSectionInstruction instruction = new DisplayWorldSectionInstruction(0, Direction.DOWN, selection, Optional.empty());
            SceneBuilder.this.addInstruction(instruction);
            return instruction.createLink(SceneBuilder.this.scene);
        }

        public void hideSection(Selection selection, Direction fadeOutDirection) {
            WorldSectionElement worldSectionElement = new WorldSectionElement(selection);
            ElementLink<WorldSectionElement> elementLink = new ElementLink<WorldSectionElement>(WorldSectionElement.class);
            SceneBuilder.this.addInstruction(scene -> {
                scene.getBaseWorldSection().erase(selection);
                scene.linkElement(worldSectionElement, elementLink);
                scene.addElement(worldSectionElement);
                worldSectionElement.queueRedraw();
            });
            this.hideIndependentSection(elementLink, fadeOutDirection);
        }

        public void hideIndependentSection(ElementLink<WorldSectionElement> link, Direction fadeOutDirection) {
            SceneBuilder.this.addInstruction(new FadeOutOfSceneInstruction<WorldSectionElement>(15, fadeOutDirection, link));
        }

        public void restoreBlocks(Selection selection) {
            SceneBuilder.this.addInstruction(scene -> scene.world.restoreBlocks(selection));
        }

        public ElementLink<WorldSectionElement> makeSectionIndependent(Selection selection) {
            WorldSectionElement worldSectionElement = new WorldSectionElement(selection);
            ElementLink<WorldSectionElement> elementLink = new ElementLink<WorldSectionElement>(WorldSectionElement.class);
            SceneBuilder.this.addInstruction(scene -> {
                scene.getBaseWorldSection().erase(selection);
                scene.linkElement(worldSectionElement, elementLink);
                scene.addElement(worldSectionElement);
                worldSectionElement.queueRedraw();
                worldSectionElement.resetAnimatedTransform();
                worldSectionElement.setVisible(true);
                worldSectionElement.forceApplyFade(1.0f);
            });
            return elementLink;
        }

        public void rotateSection(ElementLink<WorldSectionElement> link, double xRotation, double yRotation, double zRotation, int duration) {
            SceneBuilder.this.addInstruction(AnimateWorldSectionInstruction.rotate(link, new Vector3d(xRotation, yRotation, zRotation), duration));
        }

        public void configureCenterOfRotation(ElementLink<WorldSectionElement> link, Vector3d anchor) {
            SceneBuilder.this.addInstruction(scene -> ((WorldSectionElement)scene.resolve(link)).setCenterOfRotation(anchor));
        }

        public void configureStabilization(ElementLink<WorldSectionElement> link, Vector3d anchor) {
            SceneBuilder.this.addInstruction(scene -> ((WorldSectionElement)scene.resolve(link)).stabilizeRotation(anchor));
        }

        public void moveSection(ElementLink<WorldSectionElement> link, Vector3d offset, int duration) {
            SceneBuilder.this.addInstruction(AnimateWorldSectionInstruction.move(link, offset, duration));
        }

        public void rotateBearing(BlockPos pos, float angle, int duration) {
            SceneBuilder.this.addInstruction(AnimateTileEntityInstruction.bearing(pos, angle, duration));
        }

        public void movePulley(BlockPos pos, float distance, int duration) {
            SceneBuilder.this.addInstruction(AnimateTileEntityInstruction.pulley(pos, distance, duration));
        }

        public void moveDeployer(BlockPos pos, float distance, int duration) {
            SceneBuilder.this.addInstruction(AnimateTileEntityInstruction.deployer(pos, distance, duration));
        }

        public void setBlocks(Selection selection, BlockState state, boolean spawnParticles) {
            SceneBuilder.this.addInstruction(new ReplaceBlocksInstruction(selection, $ -> state, true, spawnParticles));
        }

        public void destroyBlock(BlockPos pos) {
            this.setBlock(pos, Blocks.field_150350_a.func_176223_P(), true);
        }

        public void setBlock(BlockPos pos, BlockState state, boolean spawnParticles) {
            this.setBlocks(((SceneBuilder)SceneBuilder.this).scene.getSceneBuildingUtil().select.position(pos), state, spawnParticles);
        }

        public void replaceBlocks(Selection selection, BlockState state, boolean spawnParticles) {
            this.modifyBlocks(selection, $ -> state, spawnParticles);
        }

        public void modifyBlock(BlockPos pos, UnaryOperator<BlockState> stateFunc, boolean spawnParticles) {
            this.modifyBlocks(((SceneBuilder)SceneBuilder.this).scene.getSceneBuildingUtil().select.position(pos), stateFunc, spawnParticles);
        }

        public void cycleBlockProperty(BlockPos pos, Property<?> property) {
            this.modifyBlocks(((SceneBuilder)SceneBuilder.this).scene.getSceneBuildingUtil().select.position(pos), s -> s.func_235901_b_(property) ? (BlockState)s.func_235896_a_(property) : s, false);
        }

        public void modifyBlocks(Selection selection, UnaryOperator<BlockState> stateFunc, boolean spawnParticles) {
            SceneBuilder.this.addInstruction(new ReplaceBlocksInstruction(selection, stateFunc, false, spawnParticles));
        }

        public void toggleRedstonePower(Selection selection) {
            this.modifyBlocks(selection, s -> {
                if (s.func_235901_b_((Property)BlockStateProperties.field_208136_ak)) {
                    s = (BlockState)s.func_206870_a((Property)BlockStateProperties.field_208136_ak, (Comparable)Integer.valueOf((Integer)s.func_177229_b((Property)BlockStateProperties.field_208136_ak) == 0 ? 15 : 0));
                }
                if (s.func_235901_b_((Property)BlockStateProperties.field_208194_u)) {
                    s = (BlockState)s.func_235896_a_((Property)BlockStateProperties.field_208194_u);
                }
                if (s.func_235901_b_((Property)RedstoneTorchBlock.field_196528_a)) {
                    s = (BlockState)s.func_235896_a_((Property)RedstoneTorchBlock.field_196528_a);
                }
                return s;
            }, false);
        }

        public <T extends Entity> void modifyEntities(Class<T> entityClass, Consumer<T> entityCallBack) {
            SceneBuilder.this.addInstruction(scene -> scene.forEachWorldEntity(entityClass, entityCallBack));
        }

        public <T extends Entity> void modifyEntitiesInside(Class<T> entityClass, Selection area, Consumer<T> entityCallBack) {
            SceneBuilder.this.addInstruction(scene -> scene.forEachWorldEntity(entityClass, e -> {
                if (area.test(e.func_233580_cy_())) {
                    entityCallBack.accept(e);
                }
            }));
        }

        public void modifyEntity(ElementLink<EntityElement> link, Consumer<Entity> entityCallBack) {
            SceneBuilder.this.addInstruction(scene -> {
                EntityElement resolve = (EntityElement)scene.resolve(link);
                if (resolve != null) {
                    resolve.ifPresent(entityCallBack::accept);
                }
            });
        }

        public ElementLink<EntityElement> createEntity(Function<World, Entity> factory) {
            ElementLink<EntityElement> link = new ElementLink<EntityElement>(EntityElement.class, UUID.randomUUID());
            SceneBuilder.this.addInstruction(scene -> {
                PonderWorld world = scene.getWorld();
                Entity entity = (Entity)factory.apply(world);
                EntityElement handle = new EntityElement(entity);
                scene.addElement(handle);
                scene.linkElement(handle, link);
                world.func_217376_c(entity);
            });
            return link;
        }

        public ElementLink<EntityElement> createItemEntity(Vector3d location, Vector3d motion, ItemStack stack) {
            return this.createEntity(world -> {
                ItemEntity itemEntity = new ItemEntity(world, location.field_72450_a, location.field_72448_b, location.field_72449_c, stack);
                itemEntity.func_213317_d(motion);
                return itemEntity;
            });
        }

        public ElementLink<EntityElement> createGlueEntity(BlockPos pos, Direction face) {
            SceneBuilder.this.effects.superGlue(pos, face, false);
            return this.createEntity(world -> new SuperGlueEntity((World)world, pos, face.func_176734_d()));
        }

        public void createItemOnBeltLike(BlockPos location, Direction insertionSide, ItemStack stack) {
            SceneBuilder.this.addInstruction(scene -> {
                PonderWorld world = scene.getWorld();
                TileEntity tileEntity = world.func_175625_s(location);
                if (!(tileEntity instanceof SmartTileEntity)) {
                    return;
                }
                SmartTileEntity beltTileEntity = (SmartTileEntity)tileEntity;
                DirectBeltInputBehaviour behaviour = beltTileEntity.getBehaviour(DirectBeltInputBehaviour.TYPE);
                if (behaviour == null) {
                    return;
                }
                behaviour.handleInsertion(stack, insertionSide.func_176734_d(), false);
            });
            this.flapFunnel(location.func_177984_a(), true);
        }

        public ElementLink<BeltItemElement> createItemOnBelt(BlockPos beltLocation, Direction insertionSide, ItemStack stack) {
            ElementLink<BeltItemElement> link = new ElementLink<BeltItemElement>(BeltItemElement.class);
            SceneBuilder.this.addInstruction(scene -> {
                PonderWorld world = scene.getWorld();
                TileEntity tileEntity = world.func_175625_s(beltLocation);
                if (!(tileEntity instanceof BeltTileEntity)) {
                    return;
                }
                BeltTileEntity beltTileEntity = (BeltTileEntity)tileEntity;
                DirectBeltInputBehaviour behaviour = beltTileEntity.getBehaviour(DirectBeltInputBehaviour.TYPE);
                behaviour.handleInsertion(stack, insertionSide.func_176734_d(), false);
                BeltTileEntity controllerTE = beltTileEntity.getControllerTE();
                if (controllerTE != null) {
                    controllerTE.func_73660_a();
                }
                TransportedItemStackHandlerBehaviour transporter = beltTileEntity.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
                transporter.handleProcessingOnAllItems(tis -> {
                    BeltItemElement tracker = new BeltItemElement((TransportedItemStack)tis);
                    scene.addElement(tracker);
                    scene.linkElement(tracker, link);
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                });
            });
            this.flapFunnel(beltLocation.func_177984_a(), true);
            return link;
        }

        public void removeItemsFromBelt(BlockPos beltLocation) {
            SceneBuilder.this.addInstruction(scene -> {
                PonderWorld world = scene.getWorld();
                TileEntity tileEntity = world.func_175625_s(beltLocation);
                if (!(tileEntity instanceof SmartTileEntity)) {
                    return;
                }
                SmartTileEntity beltTileEntity = (SmartTileEntity)tileEntity;
                TransportedItemStackHandlerBehaviour transporter = beltTileEntity.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
                if (transporter == null) {
                    return;
                }
                transporter.handleCenteredProcessingOnAllItems(0.52f, tis -> TransportedItemStackHandlerBehaviour.TransportedResult.removeItem());
            });
        }

        public void stallBeltItem(ElementLink<BeltItemElement> link, boolean stalled) {
            SceneBuilder.this.addInstruction(scene -> {
                BeltItemElement resolve = (BeltItemElement)scene.resolve(link);
                if (resolve != null) {
                    resolve.ifPresent(tis -> {
                        tis.locked = stalled;
                    });
                }
            });
        }

        public void changeBeltItemTo(ElementLink<BeltItemElement> link, ItemStack newStack) {
            SceneBuilder.this.addInstruction(scene -> {
                BeltItemElement resolve = (BeltItemElement)scene.resolve(link);
                if (resolve != null) {
                    resolve.ifPresent(tis -> {
                        tis.stack = newStack;
                    });
                }
            });
        }

        public void setKineticSpeed(Selection selection, float speed) {
            this.modifyKineticSpeed(selection, f -> Float.valueOf(speed));
        }

        public void multiplyKineticSpeed(Selection selection, float modifier) {
            this.modifyKineticSpeed(selection, f -> Float.valueOf(f.floatValue() * modifier));
        }

        public void modifyKineticSpeed(Selection selection, UnaryOperator<Float> speedFunc) {
            this.modifyTileNBT(selection, SpeedGaugeTileEntity.class, nbt -> {
                float newSpeed = ((Float)speedFunc.apply(Float.valueOf(nbt.func_74760_g("Speed")))).floatValue();
                nbt.func_74776_a("Value", SpeedGaugeTileEntity.getDialTarget(newSpeed));
            });
            this.modifyTileNBT(selection, KineticTileEntity.class, nbt -> nbt.func_74776_a("Speed", ((Float)speedFunc.apply(Float.valueOf(nbt.func_74760_g("Speed")))).floatValue()));
        }

        public void setFilterData(Selection selection, Class<? extends TileEntity> teType, ItemStack filter) {
            this.modifyTileNBT(selection, teType, nbt -> nbt.func_218657_a("Filter", (INBT)filter.serializeNBT()));
        }

        public void modifyTileNBT(Selection selection, Class<? extends TileEntity> teType, Consumer<CompoundNBT> consumer) {
            this.modifyTileNBT(selection, teType, consumer, false);
        }

        public <T extends TileEntity> void modifyTileEntity(BlockPos position, Class<T> teType, Consumer<T> consumer) {
            SceneBuilder.this.addInstruction(scene -> {
                TileEntity tileEntity = scene.world.func_175625_s(position);
                if (teType.isInstance(tileEntity)) {
                    consumer.accept(teType.cast(tileEntity));
                }
            });
        }

        public void modifyTileNBT(Selection selection, Class<? extends TileEntity> teType, Consumer<CompoundNBT> consumer, boolean reDrawBlocks) {
            SceneBuilder.this.addInstruction(new TileEntityDataInstruction(selection, teType, nbt -> {
                consumer.accept((CompoundNBT)nbt);
                return nbt;
            }, reDrawBlocks));
        }

        public void instructArm(BlockPos armLocation, ArmTileEntity.Phase phase, ItemStack heldItem, int targetedPoint) {
            this.modifyTileNBT(((SceneBuilder)SceneBuilder.this).scene.getSceneBuildingUtil().select.position(armLocation), ArmTileEntity.class, compound -> {
                NBTHelper.writeEnum(compound, "Phase", phase);
                compound.func_218657_a("HeldItem", (INBT)heldItem.serializeNBT());
                compound.func_74768_a("TargetPointIndex", targetedPoint);
                compound.func_74776_a("MovementProgress", 0.0f);
            });
        }

        public void flapFunnel(BlockPos position, boolean outward) {
            this.modifyTileEntity(position, FunnelTileEntity.class, funnel -> funnel.flap(!outward));
        }

        public void setCraftingResult(BlockPos crafter, ItemStack output) {
            this.modifyTileEntity(crafter, MechanicalCrafterTileEntity.class, mct -> mct.setScriptedResult(output));
        }

        public void connectCrafterInvs(BlockPos position1, BlockPos position2) {
            SceneBuilder.this.addInstruction(s -> {
                ConnectedInputHandler.toggleConnection(s.getWorld(), position1, position2);
                s.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
            });
        }
    }

    public class SpecialInstructions {
        public ElementLink<ParrotElement> birbOnTurntable(BlockPos pos) {
            return this.createBirb(VecHelper.getCenterOf((Vector3i)pos), () -> new ParrotElement.SpinOnComponentPose(pos));
        }

        public ElementLink<ParrotElement> birbOnSpinnyShaft(BlockPos pos) {
            return this.createBirb(VecHelper.getCenterOf((Vector3i)pos).func_72441_c(0.0, 0.5, 0.0), () -> new ParrotElement.SpinOnComponentPose(pos));
        }

        public ElementLink<ParrotElement> createBirb(Vector3d location, Supplier<? extends ParrotElement.ParrotPose> pose) {
            ElementLink<ParrotElement> link = new ElementLink<ParrotElement>(ParrotElement.class);
            ParrotElement parrot = ParrotElement.create(location, pose);
            SceneBuilder.this.addInstruction(new CreateParrotInstruction(10, Direction.DOWN, parrot));
            SceneBuilder.this.addInstruction(scene -> scene.linkElement(parrot, link));
            return link;
        }

        public void changeBirbPose(ElementLink<ParrotElement> birb, Supplier<? extends ParrotElement.ParrotPose> pose) {
            SceneBuilder.this.addInstruction(scene -> ((ParrotElement)scene.resolve(birb)).setPose((ParrotElement.ParrotPose)pose.get()));
        }

        public void movePointOfInterest(Vector3d location) {
            SceneBuilder.this.addInstruction(new MovePoiInstruction(location));
        }

        public void movePointOfInterest(BlockPos location) {
            this.movePointOfInterest(VecHelper.getCenterOf((Vector3i)location));
        }

        public void rotateParrot(ElementLink<ParrotElement> link, double xRotation, double yRotation, double zRotation, int duration) {
            SceneBuilder.this.addInstruction(AnimateParrotInstruction.rotate(link, new Vector3d(xRotation, yRotation, zRotation), duration));
        }

        public void moveParrot(ElementLink<ParrotElement> link, Vector3d offset, int duration) {
            SceneBuilder.this.addInstruction(AnimateParrotInstruction.move(link, offset, duration));
        }

        public ElementLink<MinecartElement> createCart(Vector3d location, float angle, MinecartElement.MinecartConstructor type) {
            ElementLink<MinecartElement> link = new ElementLink<MinecartElement>(MinecartElement.class);
            MinecartElement cart = new MinecartElement(location, angle, type);
            SceneBuilder.this.addInstruction(new CreateMinecartInstruction(10, Direction.DOWN, cart));
            SceneBuilder.this.addInstruction(scene -> scene.linkElement(cart, link));
            return link;
        }

        public void rotateCart(ElementLink<MinecartElement> link, float yRotation, int duration) {
            SceneBuilder.this.addInstruction(AnimateMinecartInstruction.rotate(link, yRotation, duration));
        }

        public void moveCart(ElementLink<MinecartElement> link, Vector3d offset, int duration) {
            SceneBuilder.this.addInstruction(AnimateMinecartInstruction.move(link, offset, duration));
        }

        public <T extends AnimatedSceneElement> void hideElement(ElementLink<T> link, Direction direction) {
            SceneBuilder.this.addInstruction(new FadeOutOfSceneInstruction<T>(15, direction, link));
        }
    }

    public class OverlayInstructions {
        public TextWindowElement.Builder showText(int duration) {
            TextWindowElement textWindowElement = new TextWindowElement();
            SceneBuilder.this.addInstruction(new TextInstruction(textWindowElement, duration));
            TextWindowElement textWindowElement2 = textWindowElement;
            textWindowElement2.getClass();
            return textWindowElement2.new TextWindowElement.Builder(SceneBuilder.this.scene);
        }

        public TextWindowElement.Builder showSelectionWithText(Selection selection, int duration) {
            TextWindowElement textWindowElement = new TextWindowElement();
            SceneBuilder.this.addInstruction(new TextInstruction(textWindowElement, duration, selection));
            TextWindowElement textWindowElement2 = textWindowElement;
            textWindowElement2.getClass();
            return textWindowElement2.new TextWindowElement.Builder(SceneBuilder.this.scene).pointAt(selection.getCenter());
        }

        public void showControls(InputWindowElement element, int duration) {
            SceneBuilder.this.addInstruction(new ShowInputInstruction(element.clone(), duration));
        }

        public void chaseBoundingBoxOutline(PonderPalette color, Object slot, AxisAlignedBB boundingBox, int duration) {
            SceneBuilder.this.addInstruction(new ChaseAABBInstruction(color, slot, boundingBox, duration));
        }

        public void showCenteredScrollInput(BlockPos pos, Direction side, int duration) {
            this.showScrollInput(((SceneBuilder)SceneBuilder.this).scene.getSceneBuildingUtil().vector.blockSurface(pos, side), side, duration);
        }

        public void showScrollInput(Vector3d location, Direction side, int duration) {
            Direction.Axis axis = side.func_176740_k();
            float s = 0.0625f;
            float q = 0.25f;
            Vector3d expands = new Vector3d(axis == Direction.Axis.X ? (double)s : (double)q, axis == Direction.Axis.Y ? (double)s : (double)q, axis == Direction.Axis.Z ? (double)s : (double)q);
            SceneBuilder.this.addInstruction(new HighlightValueBoxInstruction(location, expands, duration));
        }

        public void showRepeaterScrollInput(BlockPos pos, int duration) {
            float s = 0.0625f;
            float q = 0.16666667f;
            Vector3d expands = new Vector3d((double)q, (double)s, (double)q);
            SceneBuilder.this.addInstruction(new HighlightValueBoxInstruction(((SceneBuilder)SceneBuilder.this).scene.getSceneBuildingUtil().vector.blockSurface(pos, Direction.DOWN).func_72441_c(0.0, 0.1875, 0.0), expands, duration));
        }

        public void showFilterSlotInput(Vector3d location, int duration) {
            float s = 0.1f;
            Vector3d expands = new Vector3d((double)s, (double)s, (double)s);
            SceneBuilder.this.addInstruction(new HighlightValueBoxInstruction(location, expands, duration));
        }

        public void showLine(PonderPalette color, Vector3d start, Vector3d end, int duration) {
            SceneBuilder.this.addInstruction(new LineInstruction(color, start, end, duration));
        }

        public void showOutline(PonderPalette color, Object slot, Selection selection, int duration) {
            SceneBuilder.this.addInstruction(new OutlineSelectionInstruction(color, slot, selection, duration));
        }
    }

    public class EffectInstructions {
        public void emitParticles(Vector3d location, EmitParticlesInstruction.Emitter emitter, float amountPerCycle, int cycles) {
            SceneBuilder.this.addInstruction(new EmitParticlesInstruction(location, emitter, amountPerCycle, cycles));
        }

        public void superGlue(BlockPos pos, Direction side, boolean fullBlock) {
            SceneBuilder.this.addInstruction(scene -> SuperGlueItem.spawnParticles(scene.world, pos, side, fullBlock));
        }

        private void rotationIndicator(BlockPos pos, boolean direction) {
            SceneBuilder.this.addInstruction(scene -> {
                BlockState blockState = scene.world.func_180495_p(pos);
                TileEntity tileEntity = scene.world.func_175625_s(pos);
                if (!(blockState.func_177230_c() instanceof KineticBlock)) {
                    return;
                }
                if (!(tileEntity instanceof KineticTileEntity)) {
                    return;
                }
                KineticTileEntity kte = (KineticTileEntity)tileEntity;
                KineticBlock kb = (KineticBlock)blockState.func_177230_c();
                Direction.Axis rotationAxis = kb.getRotationAxis(blockState);
                float speed = kte.getTheoreticalSpeed();
                IRotate.SpeedLevel speedLevel = IRotate.SpeedLevel.of(speed);
                int color = direction ? (speed > 0.0f ? 15425035 : 1476519) : speedLevel.getColor();
                int particleSpeed = speedLevel.getParticleSpeed();
                particleSpeed = (int)((float)particleSpeed * Math.signum(speed));
                Vector3d location = VecHelper.getCenterOf((Vector3i)pos);
                RotationIndicatorParticleData particleData = new RotationIndicatorParticleData(color, particleSpeed, kb.getParticleInitialRadius(), kb.getParticleTargetRadius(), 20, rotationAxis.name().charAt(0));
                for (int i = 0; i < 20; ++i) {
                    scene.world.func_195594_a(particleData, location.field_72450_a, location.field_72448_b, location.field_72449_c, 0.0, 0.0, 0.0);
                }
            });
        }

        public void rotationSpeedIndicator(BlockPos pos) {
            this.rotationIndicator(pos, false);
        }

        public void rotationDirectionIndicator(BlockPos pos) {
            this.rotationIndicator(pos, true);
        }

        public void indicateRedstone(BlockPos pos) {
            this.createRedstoneParticles(pos, 0xFF0000, 10);
        }

        public void indicateSuccess(BlockPos pos) {
            this.createRedstoneParticles(pos, 8454058, 10);
        }

        public void createRedstoneParticles(BlockPos pos, int color, int amount) {
            Vector3d rgb = ColorHelper.getRGB(color);
            SceneBuilder.this.addInstruction(new EmitParticlesInstruction(VecHelper.getCenterOf((Vector3i)pos), EmitParticlesInstruction.Emitter.withinBlockSpace(new RedstoneParticleData((float)rgb.field_72450_a, (float)rgb.field_72448_b, (float)rgb.field_72449_c, 1.0f), Vector3d.field_186680_a), amount, 2));
        }
    }
}

