/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.content.PonderChapter;
import com.simibubi.create.foundation.ponder.content.PonderTag;
import com.simibubi.create.repack.registrate.util.entry.ItemProviderEntry;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class PonderTagRegistry {
    private final Multimap<ResourceLocation, PonderTag> tags = LinkedHashMultimap.create();
    private final Multimap<PonderChapter, PonderTag> chapterTags = LinkedHashMultimap.create();

    public Set<PonderTag> getTags(ResourceLocation item) {
        return ImmutableSet.copyOf((Collection)this.tags.get((Object)item));
    }

    public Set<PonderTag> getTags(PonderChapter chapter) {
        return ImmutableSet.copyOf((Collection)this.chapterTags.get((Object)chapter));
    }

    public Set<ResourceLocation> getItems(PonderTag tag) {
        return (Set)this.tags.entries().stream().filter(e -> e.getValue() == tag).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
    }

    public Set<PonderChapter> getChapters(PonderTag tag) {
        return (Set)this.chapterTags.entries().stream().filter(e -> e.getValue() == tag).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
    }

    public void add(PonderTag tag, ResourceLocation item) {
        this.tags.put((Object)item, (Object)tag);
    }

    public void add(PonderTag tag, PonderChapter chapter) {
        this.chapterTags.put((Object)chapter, (Object)tag);
    }

    public ItemBuilder forItems(ResourceLocation ... items) {
        return new ItemBuilder(items);
    }

    public TagBuilder forTag(PonderTag tag) {
        return new TagBuilder(tag);
    }

    public static class TagBuilder {
        private final PonderTag tag;

        private TagBuilder(PonderTag tag) {
            this.tag = tag;
        }

        public TagBuilder add(ResourceLocation item) {
            PonderRegistry.tags.add(this.tag, item);
            return this;
        }

        public TagBuilder add(IItemProvider item) {
            return this.add(item.func_199767_j().getRegistryName());
        }

        public TagBuilder add(ItemProviderEntry<?> entry) {
            return this.add((IItemProvider)entry.get());
        }
    }

    public static class ItemBuilder {
        private final Collection<ResourceLocation> items;

        private ItemBuilder(ResourceLocation ... items) {
            this.items = Arrays.asList(items);
        }

        public ItemBuilder add(PonderTag tag) {
            this.items.forEach(i -> PonderRegistry.tags.add(tag, (ResourceLocation)i));
            return this;
        }
    }
}

