/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.ponder.NavigatableSimiScreen;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.ponder.content.PonderChapter;
import com.simibubi.create.foundation.ponder.content.PonderTag;
import com.simibubi.create.foundation.ponder.ui.ChapterLabel;
import com.simibubi.create.foundation.ponder.ui.LayoutHelper;
import com.simibubi.create.foundation.ponder.ui.PonderButton;
import com.simibubi.create.foundation.utility.FontHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.client.MainWindow;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class PonderTagScreen
extends NavigatableSimiScreen {
    public static final String ASSOCIATED = "ponder.associated";
    private final PonderTag tag;
    protected final List<Item> items;
    private final double itemXmult = 0.5;
    protected Rectangle2d itemArea;
    protected final List<PonderChapter> chapters;
    private final double chapterXmult = 0.5;
    private final double chapterYmult = 0.75;
    protected Rectangle2d chapterArea;
    private final double mainYmult = 0.15;
    private ItemStack hoveredItem = ItemStack.field_190927_a;

    public PonderTagScreen(PonderTag tag) {
        this.tag = tag;
        this.items = new ArrayList<Item>();
        this.chapters = new ArrayList<PonderChapter>();
    }

    @Override
    protected void func_231160_c_() {
        this.widgets.clear();
        super.func_231160_c_();
        this.items.clear();
        PonderRegistry.tags.getItems(this.tag).stream().map(key -> {
            Block b;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(key);
            if (item == null && (b = (Block)ForgeRegistries.BLOCKS.getValue(key)) != null) {
                item = b.func_199767_j();
            }
            return item;
        }).filter(Objects::nonNull).forEach(this.items::add);
        if (!this.tag.getMainItem().func_190926_b()) {
            this.items.remove(this.tag.getMainItem().func_77973_b());
        }
        int rowCount = MathHelper.func_76125_a((int)((int)Math.ceil((double)this.items.size() / 11.0)), (int)1, (int)3);
        LayoutHelper layout = LayoutHelper.centeredHorizontal(this.items.size(), rowCount, 28, 28, 8);
        this.itemArea = layout.getArea();
        int itemCenterX = (int)((double)this.field_230708_k_ * 0.5);
        int itemCenterY = this.getItemsY();
        for (Item i : this.items) {
            boolean canClick = PonderRegistry.all.containsKey(i.getRegistryName());
            PonderButton button = new PonderButton(itemCenterX + layout.getX() + 4, itemCenterY + layout.getY() + 4, (mouseX, mouseY) -> {
                if (!canClick) {
                    return;
                }
                this.centerScalingOn((int)mouseX, (int)mouseY);
                ScreenOpener.transitionTo(PonderUI.of(new ItemStack((IItemProvider)i), this.tag));
            }).showing(new ItemStack((IItemProvider)i));
            if (!canClick) {
                if (i.getRegistryName().func_110624_b().equals("create")) {
                    button.customColors(1889027328, 1885938688);
                } else {
                    button.customColors(0x505000FF, 1345323127);
                }
            }
            button.fade(1.0f);
            this.widgets.add(button);
            layout.next();
        }
        if (!this.tag.getMainItem().func_190926_b()) {
            ResourceLocation registryName = this.tag.getMainItem().func_77973_b().getRegistryName();
            boolean canClick = PonderRegistry.all.containsKey(registryName);
            PonderButton button = new PonderButton(itemCenterX - layout.getTotalWidth() / 2 - 42, itemCenterY - 10, (mouseX, mouseY) -> {
                if (!canClick) {
                    return;
                }
                this.centerScalingOn((int)mouseX, (int)mouseY);
                ScreenOpener.transitionTo(PonderUI.of(this.tag.getMainItem(), this.tag));
            }).showing(this.tag.getMainItem());
            if (!canClick) {
                if (registryName.func_110624_b().equals("create")) {
                    button.customColors(1889027328, 1885938688);
                } else {
                    button.customColors(0x505000FF, 1345323127);
                }
            }
            button.fade(1.0f);
            this.widgets.add(button);
        }
        this.chapters.clear();
        this.chapters.addAll(PonderRegistry.tags.getChapters(this.tag));
        rowCount = MathHelper.func_76125_a((int)((int)Math.ceil((float)this.chapters.size() / 3.0f)), (int)1, (int)3);
        layout = LayoutHelper.centeredHorizontal(this.chapters.size(), rowCount, 200, 38, 16);
        this.chapterArea = layout.getArea();
        int chapterCenterX = (int)((double)this.field_230708_k_ * 0.5);
        int chapterCenterY = (int)((double)this.field_230709_l_ * 0.75);
        for (PonderChapter chapter : this.chapters) {
            ChapterLabel label = new ChapterLabel(chapter, chapterCenterX + layout.getX(), chapterCenterY + layout.getY(), (mouseX, mouseY) -> {
                this.centerScalingOn((int)mouseX, (int)mouseY);
                ScreenOpener.transitionTo(PonderUI.of(chapter));
            });
            this.widgets.add(label);
            layout.next();
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        ++PonderUI.ponderTicks;
        this.hoveredItem = ItemStack.field_190927_a;
        MainWindow w = this.field_230706_i_.func_228018_at_();
        double mouseX = this.field_230706_i_.field_71417_B.func_198024_e() * (double)w.func_198107_o() / (double)w.func_198105_m();
        double mouseY = this.field_230706_i_.field_71417_B.func_198026_f() * (double)w.func_198087_p() / (double)w.func_198083_n();
        for (Widget widget : this.widgets) {
            if (widget == this.backTrack || !(widget instanceof PonderButton) || !widget.func_231047_b_(mouseX, mouseY)) continue;
            this.hoveredItem = ((PonderButton)widget).getItem();
        }
    }

    @Override
    protected void renderWindow(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.renderItems(ms, mouseX, mouseY, partialTicks);
        this.renderChapters(ms, mouseX, mouseY, partialTicks);
        ms.func_227860_a_();
        ms.func_227861_a_((double)(this.field_230708_k_ / 2 - 120), (double)this.field_230709_l_ * 0.15 - 40.0, 0.0);
        ms.func_227860_a_();
        int x = 59;
        int y = 31;
        String title = this.tag.getTitle();
        int streakHeight = 35;
        UIRenderHelper.streak(ms, 0.0f, x - 4, y - 12 + streakHeight / 2, streakHeight, 240, 0x101010);
        PonderUI.renderBox(ms, 21, 21, 30, 30, false);
        this.field_230712_o_.func_243248_b(ms, (ITextComponent)Lang.translate("ponder.pondering", new Object[0]), (float)x, (float)(y - 6), -6052957);
        ms.func_227861_a_((double)(x += 0), (double)(y += 8), 0.0);
        ms.func_227861_a_(0.0, 0.0, 5.0);
        this.field_230712_o_.func_238421_b_(ms, title, 0.0f, 0.0f, 0xEEEEEE);
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227861_a_(23.0, 23.0, 10.0);
        ms.func_227862_a_(1.66f, 1.66f, 1.66f);
        this.tag.draw(ms, (AbstractGui)this, 0, 0);
        ms.func_227865_b_();
        ms.func_227865_b_();
        ms.func_227860_a_();
        int w = (int)((double)this.field_230708_k_ * 0.45);
        x = (this.field_230708_k_ - w) / 2;
        y = this.getItemsY() - 10 + Math.max(this.itemArea.func_199317_d(), 48);
        String desc = this.tag.getDescription();
        int h = this.field_230712_o_.func_78267_b(desc, w);
        PonderUI.renderBox(ms, x - 3, y - 3, w + 6, h + 6, false);
        ms.func_227861_a_(0.0, 0.0, 100.0);
        FontHelper.drawSplitString(ms, this.field_230712_o_, desc, x, y, w, 0xEEEEEE);
        ms.func_227865_b_();
    }

    protected void renderItems(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        if (this.items.isEmpty()) {
            return;
        }
        int x = (int)((double)this.field_230708_k_ * 0.5);
        int y = this.getItemsY();
        String relatedTitle = Lang.translate(ASSOCIATED, new Object[0]).getString();
        int stringWidth = this.field_230712_o_.func_78256_a(relatedTitle);
        ms.func_227860_a_();
        ms.func_227861_a_((double)x, (double)y, 0.0);
        PonderUI.renderBox(ms, (this.sWidth - stringWidth) / 2 - 5, this.itemArea.func_199319_b() - 21, stringWidth + 10, 10, false);
        ms.func_227861_a_(0.0, 0.0, 200.0);
        PonderTagScreen.func_238471_a_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (String)relatedTitle, (int)(this.sWidth / 2), (int)(this.itemArea.func_199319_b() - 20), (int)0xEEEEEE);
        ms.func_227861_a_(0.0, 0.0, -200.0);
        UIRenderHelper.streak(ms, 0.0f, 0, 0, this.itemArea.func_199317_d() + 10, this.itemArea.func_199316_c() / 2 + 75, 0x101010);
        UIRenderHelper.streak(ms, 180.0f, 0, 0, this.itemArea.func_199317_d() + 10, this.itemArea.func_199316_c() / 2 + 75, 0x101010);
        ms.func_227865_b_();
    }

    public int getItemsY() {
        return (int)(0.15 * (double)this.field_230709_l_ + 85.0);
    }

    protected void renderChapters(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        if (this.chapters.isEmpty()) {
            return;
        }
        int chapterX = (int)((double)this.field_230708_k_ * 0.5);
        int chapterY = (int)((double)this.field_230709_l_ * 0.75);
        ms.func_227860_a_();
        ms.func_227861_a_((double)chapterX, (double)chapterY, 0.0);
        UIRenderHelper.streak(ms, 0.0f, this.chapterArea.func_199318_a() - 10, this.chapterArea.func_199319_b() - 20, 20, 220, 0x101010);
        this.field_230712_o_.func_238421_b_(ms, "More Topics to Ponder about", (float)(this.chapterArea.func_199318_a() - 5), (float)(this.chapterArea.func_199319_b() - 25), -2232577);
        ms.func_227865_b_();
    }

    @Override
    protected void renderWindowForeground(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        ms.func_227860_a_();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        ms.func_227861_a_(0.0, 0.0, 200.0);
        if (!this.hoveredItem.func_190926_b()) {
            this.func_230457_a_(ms, this.hoveredItem, mouseX, mouseY);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.enableRescaleNormal();
        ms.func_227865_b_();
    }

    @Override
    protected String getBreadcrumbTitle() {
        return this.tag.getTitle();
    }

    public ItemStack getHoveredTooltipItem() {
        return this.hoveredItem;
    }

    @Override
    public boolean func_231044_a_(double x, double y, int button) {
        MutableBoolean handled = new MutableBoolean(false);
        this.widgets.forEach(w -> {
            if (handled.booleanValue()) {
                return;
            }
            if (!w.func_231047_b_(x, y)) {
                return;
            }
            if (w instanceof PonderButton) {
                PonderButton mtdButton = (PonderButton)((Object)w);
                mtdButton.runCallback(x, y);
                handled.setTrue();
                return;
            }
        });
        if (handled.booleanValue()) {
            return true;
        }
        return super.func_231044_a_(x, y, button);
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        if (other instanceof PonderTagScreen) {
            return this.tag == ((PonderTagScreen)other).tag;
        }
        return super.isEquivalentTo(other);
    }

    @Override
    public boolean func_231177_au__() {
        return true;
    }

    public PonderTag getTag() {
        return this.tag;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.hoveredItem = ItemStack.field_190927_a;
    }
}

