/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.content.contraptions.components.millstone.MillstoneTileEntity;
import com.simibubi.create.content.contraptions.components.mixer.MechanicalMixerTileEntity;
import com.simibubi.create.content.contraptions.components.press.MechanicalPressTileEntity;
import com.simibubi.create.content.contraptions.processing.BasinBlock;
import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.content.PonderPalette;
import com.simibubi.create.foundation.ponder.elements.BeltItemElement;
import com.simibubi.create.foundation.ponder.elements.EntityElement;
import com.simibubi.create.foundation.ponder.elements.InputWindowElement;
import com.simibubi.create.foundation.ponder.elements.WorldSectionElement;
import com.simibubi.create.foundation.ponder.instructions.EmitParticlesInstruction;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class ProcessingScenes {
    public static void millstone(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("millstone", "Processing Items in the Millstone");
        scene.configureBasePlate(0, 0, 5);
        Selection belt = util.select.fromTo(1, 1, 5, 0, 1, 2).add(util.select.position(1, 2, 2));
        Selection beltCog = util.select.position(2, 0, 5);
        scene.world.showSection(util.select.layer(0).substract(beltCog), Direction.UP);
        BlockPos millstone = util.grid.at(2, 2, 2);
        Selection millstoneSelect = util.select.position(2, 2, 2);
        Selection cogs = util.select.fromTo(3, 1, 2, 3, 2, 2);
        scene.world.setKineticSpeed(millstoneSelect, 0.0f);
        scene.idle(5);
        scene.world.showSection(util.select.position(4, 1, 3), Direction.DOWN);
        scene.world.showSection(util.select.position(2, 1, 2), Direction.DOWN);
        scene.idle(10);
        scene.world.showSection(util.select.position(millstone), Direction.DOWN);
        scene.idle(10);
        Vector3d millstoneTop = util.vector.topOf(millstone);
        scene.overlay.showText(60).attachKeyFrame().text("Millstones process items by grinding them").pointAt(millstoneTop).placeNearTarget();
        scene.idle(70);
        scene.world.showSection(cogs, Direction.DOWN);
        scene.idle(10);
        scene.world.setKineticSpeed(millstoneSelect, 32.0f);
        scene.effects.indicateSuccess(millstone);
        scene.idle(10);
        scene.overlay.showText(60).attachKeyFrame().colored(PonderPalette.GREEN).text("They can be powered from the side using cogwheels").pointAt(util.vector.topOf(millstone.func_177974_f())).placeNearTarget();
        scene.idle(70);
        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_151015_O);
        Vector3d entitySpawn = util.vector.topOf(millstone.func_177981_b(3));
        ElementLink<EntityElement> entity1 = scene.world.createItemEntity(entitySpawn, util.vector.of(0.0, 0.2, 0.0), itemStack);
        scene.idle(18);
        scene.world.modifyEntity(entity1, Entity::func_70106_y);
        scene.world.modifyTileEntity(millstone, MillstoneTileEntity.class, ms -> ms.inputInv.setStackInSlot(0, itemStack));
        scene.idle(10);
        scene.overlay.showControls(new InputWindowElement(millstoneTop, Pointing.DOWN).withItem(itemStack), 30);
        scene.idle(7);
        scene.overlay.showText(40).attachKeyFrame().text("Throw or Insert items at the top").pointAt(millstoneTop).placeNearTarget();
        scene.idle(60);
        scene.world.modifyTileEntity(millstone, MillstoneTileEntity.class, ms -> ms.inputInv.setStackInSlot(0, ItemStack.field_190927_a));
        scene.overlay.showText(50).text("After some time, the result can be obtained via Right-click").pointAt(util.vector.blockSurface(millstone, Direction.WEST)).placeNearTarget();
        scene.idle(60);
        ItemStack flour = AllItems.WHEAT_FLOUR.asStack();
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(millstone, Direction.NORTH), Pointing.RIGHT).rightClick().withItem(flour), 40);
        scene.idle(50);
        scene.addKeyframe();
        scene.world.showSection(beltCog, Direction.UP);
        scene.world.showSection(belt, Direction.EAST);
        scene.idle(15);
        BlockPos beltPos = util.grid.at(1, 1, 2);
        scene.world.createItemOnBelt(beltPos, Direction.EAST, flour);
        scene.idle(15);
        scene.world.createItemOnBelt(beltPos, Direction.EAST, new ItemStack((IItemProvider)Items.field_151014_N));
        scene.idle(20);
        scene.overlay.showText(50).text("The outputs can also be extracted by automation").pointAt(util.vector.blockSurface(millstone, Direction.WEST).func_72441_c(-0.5, 0.4, 0.0)).placeNearTarget();
        scene.idle(60);
    }

    public static void crushingWheels(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("crushing_wheels", "Processing Items with Crushing Wheels");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.9f);
        Selection wheels = util.select.fromTo(3, 2, 2, 1, 2, 2);
        Selection kinetics = util.select.fromTo(0, 1, 5, 4, 1, 3);
        Selection kinetics2 = util.select.fromTo(0, 2, 5, 4, 2, 3);
        Selection beltCog = util.select.position(5, 0, 1);
        scene.world.setKineticSpeed(wheels, 0.0f);
        scene.world.setBlock(util.grid.at(2, 3, 2), Blocks.field_150350_a.func_176223_P(), false);
        scene.world.showSection(util.select.layer(0).substract(beltCog), Direction.UP);
        scene.idle(5);
        Selection belt = util.select.fromTo(4, 1, 2, 4, 4, 2).add(util.select.fromTo(4, 3, 3, 4, 4, 3)).add(util.select.position(3, 3, 2)).add(util.select.position(2, 3, 2));
        Selection bottomBelt = util.select.fromTo(5, 1, 0, 2, 1, 0).add(util.select.fromTo(2, 1, 2, 2, 1, 1));
        BlockPos center = util.grid.at(2, 2, 2);
        Selection wWheel = util.select.position(center.func_177976_e());
        Selection eWheel = util.select.position(center.func_177974_f());
        scene.world.showSection(wWheel, Direction.SOUTH);
        scene.idle(3);
        scene.world.showSection(eWheel, Direction.SOUTH);
        scene.idle(10);
        Vector3d centerTop = util.vector.topOf(center);
        scene.overlay.showText(60).attachKeyFrame().text("A pair of Crushing Wheels can grind items very effectively").pointAt(centerTop).placeNearTarget();
        scene.idle(70);
        scene.world.showSection(kinetics, Direction.DOWN);
        scene.idle(3);
        scene.world.showSection(kinetics2, Direction.DOWN);
        scene.world.setKineticSpeed(wWheel, -16.0f);
        scene.world.setKineticSpeed(eWheel, 16.0f);
        scene.idle(5);
        scene.effects.rotationDirectionIndicator(center.func_177976_e());
        scene.effects.rotationDirectionIndicator(center.func_177974_f());
        scene.idle(10);
        scene.overlay.showText(60).attachKeyFrame().text("Their Rotational Input has to make them spin into each other").pointAt(util.vector.blockSurface(center.func_177976_e(), Direction.NORTH)).placeNearTarget();
        scene.idle(40);
        scene.effects.rotationDirectionIndicator(center.func_177976_e());
        scene.effects.rotationDirectionIndicator(center.func_177974_f());
        scene.idle(30);
        ItemStack input = new ItemStack((IItemProvider)Items.field_221551_D);
        ItemStack output = AllItems.CRUSHED_GOLD.asStack();
        Vector3d entitySpawn = util.vector.topOf(center.func_177981_b(2));
        ElementLink<EntityElement> entity1 = scene.world.createItemEntity(entitySpawn, util.vector.of(0.0, 0.2, 0.0), input);
        scene.idle(18);
        scene.world.modifyEntity(entity1, Entity::func_70106_y);
        EmitParticlesInstruction.Emitter blockSpace = EmitParticlesInstruction.Emitter.withinBlockSpace(new ItemParticleData(ParticleTypes.field_197591_B, input), util.vector.of(0.0, 0.0, 0.0));
        scene.effects.emitParticles(util.vector.centerOf(center).func_72441_c(0.0, -0.2, 0.0), blockSpace, 3.0f, 40);
        scene.idle(10);
        scene.overlay.showControls(new InputWindowElement(centerTop, Pointing.DOWN).withItem(input), 30);
        scene.idle(7);
        scene.overlay.showText(50).attachKeyFrame().text("Items thrown or inserted into the top will get processed").pointAt(centerTop).placeNearTarget();
        scene.idle(60);
        scene.world.createItemEntity(centerTop.func_72441_c(0.0, -1.4, 0.0), util.vector.of(0.0, 0.0, 0.0), output);
        scene.idle(10);
        scene.world.createItemEntity(centerTop.func_72441_c(0.0, -1.4, 0.0), util.vector.of(0.0, 0.0, 0.0), output);
        scene.overlay.showControls(new InputWindowElement(centerTop.func_72441_c(0.0, -2.0, 0.0), Pointing.UP).withItem(output), 30);
        scene.idle(40);
        scene.world.restoreBlocks(util.select.position(2, 3, 2));
        scene.world.showSection(belt, Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(beltCog, Direction.UP);
        scene.idle(5);
        scene.world.modifyEntities(ItemEntity.class, Entity::func_70106_y);
        scene.world.showSection(bottomBelt, Direction.SOUTH);
        scene.idle(5);
        scene.overlay.showText(50).attachKeyFrame().text("Items can be inserted and picked up through automated means as well").pointAt(centerTop.func_72441_c(0.0, 0.5, 0.0)).placeNearTarget();
        scene.idle(40);
        for (int i = 0; i < 5; ++i) {
            if (i < 4) {
                scene.world.createItemOnBelt(util.grid.at(4, 4, 2), Direction.EAST, input);
            }
            scene.idle(15);
            if (i < 3) {
                scene.world.createItemOnBelt(util.grid.at(4, 4, 2), Direction.EAST, input);
            }
            scene.idle(15);
            if (i > 0) {
                scene.world.createItemOnBelt(center.func_177977_b(), Direction.UP, output);
                scene.idle(15);
                scene.world.createItemOnBelt(center.func_177977_b(), Direction.UP, output);
            }
            scene.world.removeItemsFromBelt(util.grid.at(3, 3, 2));
            if (i < 4) {
                scene.effects.emitParticles(util.vector.centerOf(center).func_72441_c(0.0, -0.2, 0.0), blockSpace, 3.0f, 28);
            }
            if (i != 0) continue;
            scene.markAsFinished();
        }
    }

    public static void pressing(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("mechanical_press", "Processing Items with the Mechanical Press");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(5);
        ElementLink<WorldSectionElement> depot = scene.world.showIndependentSection(util.select.position(2, 1, 1), Direction.DOWN);
        scene.world.moveSection(depot, util.vector.of(0.0, 0.0, 1.0), 0);
        scene.idle(10);
        Selection pressS = util.select.position(2, 3, 2);
        BlockPos pressPos = util.grid.at(2, 3, 2);
        BlockPos depotPos = util.grid.at(2, 1, 1);
        scene.world.setKineticSpeed(pressS, 0.0f);
        scene.world.showSection(pressS, Direction.DOWN);
        scene.idle(10);
        scene.world.showSection(util.select.fromTo(2, 1, 3, 2, 1, 5), Direction.NORTH);
        scene.idle(3);
        scene.world.showSection(util.select.position(2, 2, 3), Direction.SOUTH);
        scene.idle(3);
        scene.world.showSection(util.select.position(2, 3, 3), Direction.NORTH);
        scene.world.setKineticSpeed(pressS, -32.0f);
        scene.effects.indicateSuccess(pressPos);
        scene.idle(10);
        Vector3d pressSide = util.vector.blockSurface(pressPos, Direction.WEST);
        scene.overlay.showText(60).pointAt(pressSide).placeNearTarget().attachKeyFrame().text("The Mechanical Press can process items provided beneath it");
        scene.idle(70);
        scene.overlay.showText(60).pointAt(pressSide.func_178786_a(0.0, 2.0, 0.0)).placeNearTarget().text("The Input items can be dropped or placed on a Depot under the Press");
        scene.idle(50);
        ItemStack copper = AllItems.COPPER_INGOT.asStack();
        scene.world.createItemOnBeltLike(depotPos, Direction.NORTH, copper);
        Vector3d depotCenter = util.vector.centerOf(depotPos.func_177968_d());
        scene.overlay.showControls(new InputWindowElement(depotCenter, Pointing.UP).withItem(copper), 30);
        scene.idle(10);
        Class<MechanicalPressTileEntity> type = MechanicalPressTileEntity.class;
        scene.world.modifyTileEntity(pressPos, type, pte -> pte.start(MechanicalPressTileEntity.Mode.BELT));
        scene.idle(30);
        scene.world.modifyTileEntity(pressPos, type, pte -> pte.makePressingParticleEffect(depotCenter.func_72441_c(0.0, 0.5, 0.0), copper));
        scene.world.removeItemsFromBelt(depotPos);
        ItemStack sheet = AllItems.COPPER_SHEET.asStack();
        scene.world.createItemOnBeltLike(depotPos, Direction.UP, sheet);
        scene.idle(10);
        scene.overlay.showControls(new InputWindowElement(depotCenter, Pointing.UP).withItem(sheet), 50);
        scene.idle(60);
        scene.world.hideIndependentSection(depot, Direction.NORTH);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 3, 0, 2, 3), Direction.DOWN);
        scene.idle(10);
        scene.world.showSection(util.select.fromTo(4, 1, 2, 0, 2, 2), Direction.SOUTH);
        scene.idle(20);
        BlockPos beltPos = util.grid.at(0, 1, 2);
        scene.overlay.showText(40).pointAt(util.vector.blockSurface(beltPos, Direction.WEST)).placeNearTarget().attachKeyFrame().text("When items are provided on a belt...");
        scene.idle(30);
        ElementLink<BeltItemElement> ingot = scene.world.createItemOnBelt(beltPos, Direction.SOUTH, copper);
        scene.idle(15);
        ElementLink<BeltItemElement> ingot2 = scene.world.createItemOnBelt(beltPos, Direction.SOUTH, copper);
        scene.idle(15);
        scene.world.stallBeltItem(ingot, true);
        scene.world.modifyTileEntity(pressPos, type, pte -> pte.start(MechanicalPressTileEntity.Mode.BELT));
        scene.overlay.showText(50).pointAt(pressSide).placeNearTarget().attachKeyFrame().text("The Press will hold and process them automatically");
        scene.idle(30);
        scene.world.modifyTileEntity(pressPos, type, pte -> pte.makePressingParticleEffect(depotCenter.func_72441_c(0.0, 0.5, 0.0), copper));
        scene.world.removeItemsFromBelt(pressPos.func_177979_c(2));
        ingot = scene.world.createItemOnBelt(pressPos.func_177979_c(2), Direction.UP, sheet);
        scene.world.stallBeltItem(ingot, true);
        scene.idle(15);
        scene.world.stallBeltItem(ingot, false);
        scene.idle(15);
        scene.world.stallBeltItem(ingot2, true);
        scene.world.modifyTileEntity(pressPos, type, pte -> pte.start(MechanicalPressTileEntity.Mode.BELT));
        scene.idle(30);
        scene.world.modifyTileEntity(pressPos, type, pte -> pte.makePressingParticleEffect(depotCenter.func_72441_c(0.0, 0.5, 0.0), copper));
        scene.world.removeItemsFromBelt(pressPos.func_177979_c(2));
        ingot2 = scene.world.createItemOnBelt(pressPos.func_177979_c(2), Direction.UP, sheet);
        scene.world.stallBeltItem(ingot2, true);
        scene.idle(15);
        scene.world.stallBeltItem(ingot2, false);
    }

    public static void mixing(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("mechanical_mixer", "Processing Items with the Mechanical Mixer");
        scene.configureBasePlate(0, 0, 5);
        scene.world.setBlock(util.grid.at(1, 1, 2), AllBlocks.ANDESITE_CASING.getDefaultState(), false);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(1, 4, 3, 1, 1, 5), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.position(1, 1, 2), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.position(1, 2, 2), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.position(1, 4, 2), Direction.SOUTH);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(3, 1, 1, 1, 1, 1), Direction.SOUTH);
        scene.world.showSection(util.select.fromTo(3, 1, 5, 3, 1, 2), Direction.SOUTH);
        scene.idle(20);
        BlockPos basin = util.grid.at(1, 2, 2);
        BlockPos pressPos = util.grid.at(1, 4, 2);
        Vector3d basinSide = util.vector.blockSurface(basin, Direction.WEST);
        ItemStack blue = new ItemStack((IItemProvider)Items.field_222083_lx);
        ItemStack red = new ItemStack((IItemProvider)Items.field_222078_li);
        ItemStack purple = new ItemStack((IItemProvider)Items.field_196126_bm);
        scene.overlay.showText(60).pointAt(basinSide).placeNearTarget().attachKeyFrame().text("With a Mixer and Basin, some Crafting Recipes can be automated");
        scene.idle(40);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(basin), Pointing.LEFT).withItem(blue), 30);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(basin), Pointing.RIGHT).withItem(red), 30);
        scene.idle(30);
        Class<MechanicalMixerTileEntity> type = MechanicalMixerTileEntity.class;
        scene.world.modifyTileEntity(pressPos, type, pte -> pte.startProcessingBasin());
        scene.world.createItemOnBeltLike(basin, Direction.UP, red);
        scene.world.createItemOnBeltLike(basin, Direction.UP, blue);
        scene.idle(80);
        scene.world.modifyTileNBT(util.select.position(basin), BasinTileEntity.class, nbt -> nbt.func_218657_a("VisualizedItems", (INBT)NBTHelper.writeCompoundList(ImmutableList.of(IntAttached.with(1, purple)), ia -> ((ItemStack)ia.getValue()).serializeNBT())));
        scene.idle(4);
        scene.world.createItemOnBelt(util.grid.at(1, 1, 1), Direction.UP, purple);
        scene.idle(30);
        scene.overlay.showText(80).pointAt(basinSide).placeNearTarget().attachKeyFrame().text("Available recipes include any Shapeless Crafting Recipe, plus a couple extra ones");
        scene.idle(80);
        scene.rotateCameraY(-30.0f);
        scene.idle(10);
        scene.world.setBlock(util.grid.at(1, 1, 2), (BlockState)AllBlocks.BLAZE_BURNER.getDefaultState().func_206870_a(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)BlazeBurnerBlock.HeatLevel.KINDLED)), true);
        scene.idle(10);
        scene.overlay.showText(80).pointAt(basinSide.func_178786_a(0.0, 1.0, 0.0)).placeNearTarget().text("Some of those recipes may require the heat of a Blaze Burner");
        scene.idle(40);
        scene.rotateCameraY(30.0f);
        scene.idle(60);
        Vector3d filterPos = util.vector.of(1.0, 2.75, 2.5);
        scene.overlay.showFilterSlotInput(filterPos, 100);
        scene.overlay.showText(120).pointAt(filterPos).placeNearTarget().attachKeyFrame().text("The filter slot can be used in case two recipes are conflicting.");
        scene.idle(60);
    }

    public static void compacting(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("mechanical_press_compacting", "Compacting items with the Mechanical Press");
        scene.configureBasePlate(0, 0, 5);
        scene.world.setBlock(util.grid.at(1, 1, 2), AllBlocks.ANDESITE_CASING.getDefaultState(), false);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(1, 4, 3, 1, 1, 5), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.position(1, 1, 2), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.position(1, 2, 2), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.position(1, 4, 2), Direction.SOUTH);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(3, 1, 1, 1, 1, 1), Direction.SOUTH);
        scene.world.showSection(util.select.fromTo(3, 1, 5, 3, 1, 2), Direction.SOUTH);
        scene.idle(20);
        BlockPos basin = util.grid.at(1, 2, 2);
        BlockPos pressPos = util.grid.at(1, 4, 2);
        Vector3d basinSide = util.vector.blockSurface(basin, Direction.WEST);
        ItemStack copper = AllItems.COPPER_INGOT.asStack();
        ItemStack copperBlock = AllBlocks.COPPER_BLOCK.asStack();
        scene.overlay.showText(60).pointAt(basinSide).placeNearTarget().attachKeyFrame().text("Pressing items held in a Basin will cause them to be Compacted");
        scene.idle(40);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(basin), Pointing.DOWN).withItem(copper), 30);
        scene.idle(30);
        Class<MechanicalPressTileEntity> type = MechanicalPressTileEntity.class;
        scene.world.modifyTileEntity(pressPos, type, pte -> pte.start(MechanicalPressTileEntity.Mode.BASIN));
        scene.idle(30);
        scene.world.modifyTileEntity(pressPos, type, pte -> pte.makeCompactingParticleEffect(util.vector.centerOf(basin), copper));
        scene.world.modifyTileNBT(util.select.position(basin), BasinTileEntity.class, nbt -> nbt.func_218657_a("VisualizedItems", (INBT)NBTHelper.writeCompoundList(ImmutableList.of(IntAttached.with(1, copperBlock)), ia -> ((ItemStack)ia.getValue()).serializeNBT())));
        scene.idle(4);
        scene.world.createItemOnBelt(util.grid.at(1, 1, 1), Direction.UP, copperBlock);
        scene.idle(30);
        scene.overlay.showText(80).pointAt(basinSide).placeNearTarget().attachKeyFrame().text("Compacting includes any filled 2x2 or 3x3 Crafting Recipe, plus a couple extra ones");
        scene.idle(30);
        ItemStack log = new ItemStack((IItemProvider)Items.field_221554_G);
        ItemStack bark = new ItemStack((IItemProvider)Items.field_221572_Y);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(basin), Pointing.DOWN).withItem(log), 30);
        scene.idle(30);
        scene.world.modifyTileEntity(pressPos, type, pte -> pte.start(MechanicalPressTileEntity.Mode.BASIN));
        scene.idle(30);
        scene.world.modifyTileEntity(pressPos, type, pte -> pte.makeCompactingParticleEffect(util.vector.centerOf(basin), log));
        scene.world.modifyTileNBT(util.select.position(basin), BasinTileEntity.class, nbt -> nbt.func_218657_a("VisualizedItems", (INBT)NBTHelper.writeCompoundList(ImmutableList.of(IntAttached.with(1, bark)), ia -> ((ItemStack)ia.getValue()).serializeNBT())));
        scene.idle(4);
        scene.world.createItemOnBelt(util.grid.at(1, 1, 1), Direction.UP, bark);
        scene.idle(30);
        scene.rotateCameraY(-30.0f);
        scene.idle(10);
        scene.world.setBlock(util.grid.at(1, 1, 2), (BlockState)AllBlocks.BLAZE_BURNER.getDefaultState().func_206870_a(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)BlazeBurnerBlock.HeatLevel.KINDLED)), true);
        scene.idle(10);
        scene.overlay.showText(80).pointAt(basinSide.func_178786_a(0.0, 1.0, 0.0)).placeNearTarget().text("Some of those recipes may require the heat of a Blaze Burner");
        scene.idle(40);
        scene.rotateCameraY(30.0f);
        scene.idle(60);
        Vector3d filterPos = util.vector.of(1.0, 2.75, 2.5);
        scene.overlay.showFilterSlotInput(filterPos, 100);
        scene.overlay.showText(120).pointAt(filterPos).placeNearTarget().attachKeyFrame().text("The filter slot can be used in case two recipes are conflicting.");
        scene.idle(60);
    }

    public static void emptyBlazeBurner(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("empty_blaze_burner", "Using Empty Blaze Burners");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(10);
        BlockPos center = util.grid.at(2, 0, 2);
        scene.world.createEntity(w -> {
            BlazeEntity blazeEntity = (BlazeEntity)EntityType.field_200792_f.func_200721_a(w);
            Vector3d v = util.vector.topOf(center);
            blazeEntity.func_226288_n_(v.field_72450_a, v.field_72448_b, v.field_72449_c);
            blazeEntity.field_70177_z = 180.0f;
            blazeEntity.field_70126_B = 180.0f;
            return blazeEntity;
        });
        scene.idle(20);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(center.func_177981_b(2)), Pointing.DOWN).rightClick().withItem(AllItems.EMPTY_BLAZE_BURNER.asStack()), 40);
        scene.idle(10);
        scene.overlay.showText(60).text("Right-click a Blaze with the empty burner to capture it").attachKeyFrame().pointAt(util.vector.blockSurface(center.func_177981_b(2), Direction.WEST)).placeNearTarget();
        scene.idle(50);
        scene.world.modifyEntities(BlazeEntity.class, Entity::func_70106_y);
        scene.idle(20);
        scene.world.showSection(util.select.position(2, 1, 2), Direction.DOWN);
        scene.idle(20);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(center.func_177984_a()), Pointing.DOWN).rightClick().withItem(AllItems.EMPTY_BLAZE_BURNER.asStack()), 40);
        scene.idle(10);
        scene.overlay.showText(60).text("Alternatively, Blazes can be collected from their Spawners directly").attachKeyFrame().pointAt(util.vector.blockSurface(center.func_177984_a(), Direction.WEST)).placeNearTarget();
        scene.idle(50);
        scene.world.hideSection(util.select.position(2, 1, 2), Direction.UP);
        scene.idle(20);
        scene.world.showSection(util.select.position(1, 1, 2), Direction.DOWN);
        scene.idle(20);
        scene.world.modifyBlock(util.grid.at(1, 1, 2), s -> (BlockState)s.func_206870_a(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)BlazeBurnerBlock.HeatLevel.KINDLED)), false);
        scene.overlay.showText(70).text("You now have an ideal heat source for various machines").attachKeyFrame().pointAt(util.vector.blockSurface(center.func_177976_e().func_177984_a(), Direction.WEST)).placeNearTarget();
        scene.idle(80);
        scene.world.showSection(util.select.position(3, 1, 2), Direction.DOWN);
        scene.idle(20);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(center.func_177974_f().func_177984_a()), Pointing.DOWN).rightClick().withItem(new ItemStack((IItemProvider)Items.field_151033_d)), 40);
        scene.idle(7);
        scene.world.setBlock(util.grid.at(3, 1, 2), AllBlocks.LIT_BLAZE_BURNER.getDefaultState(), true);
        scene.idle(10);
        scene.overlay.showText(70).text("For Aesthetic purposes, Empty Blaze Burners can also be lit using Flint and Steel").attachKeyFrame().pointAt(util.vector.blockSurface(center.func_177974_f().func_177984_a(), Direction.UP)).placeNearTarget();
        scene.idle(80);
        scene.overlay.showText(60).colored(PonderPalette.RED).text("However, these are not suitable for industrial heating").pointAt(util.vector.blockSurface(center.func_177974_f().func_177984_a(), Direction.UP)).placeNearTarget();
        scene.idle(70);
    }

    public static void blazeBurner(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("blaze_burner", "Feeding Blaze Burners");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(10);
        BlockPos burner = util.grid.at(2, 1, 2);
        scene.world.showSection(util.select.position(burner), Direction.DOWN);
        scene.idle(10);
        scene.world.showSection(util.select.position(burner.func_177984_a()), Direction.DOWN);
        scene.idle(10);
        scene.overlay.showText(70).attachKeyFrame().text("Blaze Burners can provide Heat to Items processed in a Basin").pointAt(util.vector.blockSurface(burner, Direction.WEST)).placeNearTarget();
        scene.idle(80);
        scene.world.hideSection(util.select.position(burner.func_177984_a()), Direction.UP);
        scene.idle(20);
        scene.world.setBlock(burner.func_177984_a(), Blocks.field_150350_a.func_176223_P(), false);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(burner), Pointing.DOWN).rightClick().withItem(new ItemStack((IItemProvider)Items.field_221586_n)), 15);
        scene.idle(7);
        scene.world.modifyBlock(burner, s -> (BlockState)s.func_206870_a(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)BlazeBurnerBlock.HeatLevel.FADING)), false);
        scene.idle(15);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(burner), Pointing.DOWN).rightClick().withItem(new ItemStack((IItemProvider)Items.field_221586_n)), 15);
        scene.idle(7);
        scene.world.modifyBlock(burner, s -> (BlockState)s.func_206870_a(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)BlazeBurnerBlock.HeatLevel.KINDLED)), false);
        scene.idle(20);
        scene.overlay.showText(70).attachKeyFrame().text("For this, the Blaze has to be fed with flammable items").pointAt(util.vector.blockSurface(burner, Direction.WEST)).placeNearTarget();
        scene.idle(80);
        scene.idle(20);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(burner), Pointing.DOWN).rightClick().withItem(AllItems.BLAZE_CAKE.asStack()), 30);
        scene.idle(7);
        scene.world.modifyBlock(burner, s -> (BlockState)s.func_206870_a(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)BlazeBurnerBlock.HeatLevel.SEETHING)), false);
        scene.idle(20);
        scene.overlay.showText(80).attachKeyFrame().colored(PonderPalette.MEDIUM).text("With a Blaze Cake, the Burner can reach an even stronger level of heat").pointAt(util.vector.blockSurface(burner, Direction.WEST)).placeNearTarget();
        scene.idle(90);
        Class<DeployerTileEntity> teType = DeployerTileEntity.class;
        scene.world.modifyTileNBT(util.select.position(4, 1, 2), teType, nbt -> nbt.func_218657_a("HeldItem", (INBT)AllItems.BLAZE_CAKE.asStack().serializeNBT()));
        scene.world.showSection(util.select.fromTo(3, 0, 5, 2, 0, 5), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(4, 1, 2, 4, 1, 5), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(2, 1, 4, 2, 1, 5), Direction.DOWN);
        scene.idle(10);
        scene.overlay.showText(80).attachKeyFrame().text("The feeding process can be automated using Deployers or Mechanical Arms").pointAt(util.vector.blockSurface(burner.func_177965_g(2), Direction.UP));
        scene.idle(90);
    }

    public static void basin(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("basin", "Processing Items in the Basin");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.position(1, 1, 2), Direction.DOWN);
        scene.idle(10);
        BlockPos basinPos = util.grid.at(1, 2, 2);
        scene.world.modifyBlock(basinPos, s -> (BlockState)s.func_206870_a((Property)BasinBlock.FACING, (Comparable)Direction.DOWN), false);
        scene.world.showSection(util.select.position(basinPos), Direction.DOWN);
        scene.idle(10);
        Vector3d basinSide = util.vector.blockSurface(basinPos, Direction.WEST);
        scene.overlay.showText(80).attachKeyFrame().text("A Basin can hold Items and Fluids for Processing").pointAt(basinSide).placeNearTarget();
        scene.idle(10);
        ItemStack stack = new ItemStack((IItemProvider)Items.field_151118_aC);
        for (int i = 0; i < 4; ++i) {
            scene.world.createItemEntity(util.vector.centerOf(basinPos.func_177981_b(3)), util.vector.of(0.0, 0.0, 0.0), stack);
            scene.idle(10);
        }
        scene.idle(10);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(basinPos), Pointing.DOWN).withItem(stack), 30);
        scene.idle(30);
        for (Direction d : Iterate.horizontalDirections) {
            scene.overlay.showOutline(PonderPalette.GREEN, new Object(), util.select.position(basinPos.func_177977_b().func_177972_a(d)), 60);
            scene.idle(4);
        }
        scene.overlay.showText(80).attachKeyFrame().colored(PonderPalette.GREEN).text("After a processing step, basins try to output below to the side of them").pointAt(basinSide).placeNearTarget();
        scene.idle(90);
        ElementLink<WorldSectionElement> depot = scene.world.showIndependentSection(util.select.position(3, 1, 1), Direction.EAST);
        scene.world.moveSection(depot, util.vector.of(-2.0, 0.0, 0.0), 0);
        scene.idle(10);
        scene.world.modifyBlock(basinPos, s -> (BlockState)s.func_206870_a((Property)BasinBlock.FACING, (Comparable)Direction.NORTH), false);
        scene.idle(10);
        scene.overlay.showText(80).attachKeyFrame().colored(PonderPalette.GREEN).text("When a valid component is present, the Basin will show an output faucet").pointAt(basinSide.func_72441_c(0.15, 0.0, -0.5)).placeNearTarget();
        scene.idle(90);
        scene.world.hideIndependentSection(depot, Direction.EAST);
        scene.idle(15);
        depot = scene.world.showIndependentSection(util.select.position(0, 1, 1), Direction.EAST);
        scene.world.moveSection(depot, util.vector.of(1.0, 0.0, 0.0), 0);
        scene.idle(20);
        scene.world.hideIndependentSection(depot, Direction.EAST);
        scene.overlay.showText(80).text("A number of options are applicable here").pointAt(util.vector.centerOf(util.grid.at(1, 1, 1))).placeNearTarget();
        scene.idle(15);
        depot = scene.world.showIndependentSection(util.select.position(1, 1, 0), Direction.EAST);
        scene.world.moveSection(depot, util.vector.of(0.0, 0.0, 1.0), 0);
        scene.idle(20);
        scene.world.hideIndependentSection(depot, Direction.EAST);
        scene.idle(15);
        depot = scene.world.showIndependentSection(util.select.position(1, 1, 1), Direction.EAST);
        scene.idle(20);
        scene.world.hideIndependentSection(depot, Direction.EAST);
        scene.idle(15);
        depot = scene.world.showIndependentSection(util.select.fromTo(3, 1, 0, 2, 1, 0), Direction.EAST);
        scene.world.moveSection(depot, util.vector.of(-2.0, 0.0, 1.0), 0);
        scene.idle(20);
        scene.world.hideIndependentSection(depot, Direction.EAST);
        scene.idle(15);
        depot = scene.world.showIndependentSection(util.select.position(2, 1, 1), Direction.EAST);
        scene.world.moveSection(depot, util.vector.of(-1.0, 0.0, 0.0), 0);
        scene.idle(25);
        BlockPos pressPos = util.grid.at(1, 4, 2);
        scene.world.showSection(util.select.position(pressPos), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(1, 4, 3, 1, 1, 5), Direction.NORTH);
        scene.idle(10);
        Class<MechanicalPressTileEntity> type = MechanicalPressTileEntity.class;
        scene.world.modifyTileEntity(pressPos, type, pte -> pte.start(MechanicalPressTileEntity.Mode.BASIN));
        scene.idle(30);
        scene.world.modifyTileEntity(pressPos, type, pte -> pte.makeCompactingParticleEffect(util.vector.centerOf(basinPos), stack));
        scene.world.modifyTileNBT(util.select.position(basinPos), BasinTileEntity.class, nbt -> nbt.func_218657_a("VisualizedItems", (INBT)NBTHelper.writeCompoundList(ImmutableList.of(IntAttached.with(1, new ItemStack((IItemProvider)Blocks.field_196584_bK))), ia -> ((ItemStack)ia.getValue()).serializeNBT())));
        scene.idle(4);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(basinPos.func_177977_b().func_177978_c()), Pointing.RIGHT).withItem(new ItemStack((IItemProvider)Items.field_221647_bL)), 30);
        scene.overlay.showText(60).attachKeyFrame().colored(PonderPalette.GREEN).text("Outputs will be caught by the inventory below").pointAt(basinSide.func_72441_c(0.0, -1.0, -1.0)).placeNearTarget();
        scene.idle(70);
        scene.world.hideIndependentSection(depot, Direction.NORTH);
        scene.idle(10);
        scene.world.modifyBlock(basinPos, s -> (BlockState)s.func_206870_a((Property)BasinBlock.FACING, (Comparable)Direction.DOWN), false);
        scene.idle(20);
        scene.overlay.showText(80).attachKeyFrame().text("Without output faucet, the Basin will retain items created in its processing").pointAt(basinSide).placeNearTarget();
        scene.idle(50);
        ItemStack nugget = AllItems.COPPER_NUGGET.asStack();
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(basinPos), Pointing.RIGHT).withItem(nugget), 30);
        scene.idle(30);
        scene.world.modifyTileEntity(pressPos, type, pte -> pte.start(MechanicalPressTileEntity.Mode.BASIN));
        scene.idle(30);
        scene.world.modifyTileEntity(pressPos, type, pte -> pte.makeCompactingParticleEffect(util.vector.centerOf(basinPos), nugget));
        ItemStack ingot = AllItems.COPPER_INGOT.asStack();
        scene.idle(30);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(basinPos), Pointing.RIGHT).withItem(ingot), 30);
        scene.idle(30);
        scene.world.modifyTileEntity(pressPos, type, pte -> pte.start(MechanicalPressTileEntity.Mode.BASIN));
        scene.idle(30);
        scene.world.modifyTileEntity(pressPos, type, pte -> pte.makeCompactingParticleEffect(util.vector.centerOf(basinPos), ingot));
        ItemStack block = AllBlocks.COPPER_BLOCK.asStack();
        scene.idle(30);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(basinPos), Pointing.RIGHT).withItem(block), 30);
        scene.overlay.showText(70).attachKeyFrame().colored(PonderPalette.GREEN).text("This can be useful if outputs should be re-used as ingredients").pointAt(basinSide).placeNearTarget();
        scene.idle(80);
        scene.world.showSection(util.select.fromTo(2, 2, 5, 4, 1, 2), Direction.DOWN);
        scene.rotateCameraY(70.0f);
        scene.world.createItemOnBelt(util.grid.at(2, 1, 2), Direction.WEST, block);
        scene.idle(40);
        scene.overlay.showText(70).text("Desired outputs will then have to be extracted from the basin").pointAt(util.vector.topOf(util.grid.at(3, 1, 2)).func_178786_a(0.0, 0.1875, 0.0)).placeNearTarget();
        scene.idle(80);
        Vector3d filter = util.vector.of(2.5, 2.85, 2.5);
        scene.overlay.showFilterSlotInput(filter, 80);
        scene.overlay.showText(70).text("A Filter might be necessary to avoid pulling out un-processed items").pointAt(filter).placeNearTarget();
        scene.idle(40);
        scene.markAsFinished();
    }
}

