/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.mojang.datafixers.util.Pair;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.minecraft.client.renderer.BufferBuilder;

public class TemplateBuffer {
    protected ByteBuffer template;
    protected int formatSize;
    protected int vertexCount;

    public TemplateBuffer(BufferBuilder buf) {
        Pair state = buf.func_227832_f_();
        ByteBuffer rendered = (ByteBuffer)state.getSecond();
        rendered.order(ByteOrder.nativeOrder());
        this.formatSize = buf.getVertexFormat().func_177338_f();
        this.vertexCount = ((BufferBuilder.DrawState)state.getFirst()).func_227839_b_();
        int size = this.vertexCount * this.formatSize;
        this.template = ByteBuffer.allocate(size);
        this.template.order(rendered.order());
        ((Buffer)this.template).limit(rendered.limit());
        this.template.put(rendered);
        ((Buffer)this.template).rewind();
    }

    public boolean isEmpty() {
        return this.template.limit() == 0;
    }

    protected int vertexCount(ByteBuffer buffer) {
        return buffer.limit() / this.formatSize;
    }

    protected int getBufferPosition(int vertexIndex) {
        return vertexIndex * this.formatSize;
    }

    protected float getX(ByteBuffer buffer, int index) {
        return buffer.getFloat(this.getBufferPosition(index));
    }

    protected float getY(ByteBuffer buffer, int index) {
        return buffer.getFloat(this.getBufferPosition(index) + 4);
    }

    protected float getZ(ByteBuffer buffer, int index) {
        return buffer.getFloat(this.getBufferPosition(index) + 8);
    }

    protected byte getR(ByteBuffer buffer, int index) {
        return buffer.get(this.getBufferPosition(index) + 12);
    }

    protected byte getG(ByteBuffer buffer, int index) {
        return buffer.get(this.getBufferPosition(index) + 13);
    }

    protected byte getB(ByteBuffer buffer, int index) {
        return buffer.get(this.getBufferPosition(index) + 14);
    }

    protected byte getA(ByteBuffer buffer, int index) {
        return buffer.get(this.getBufferPosition(index) + 15);
    }

    protected float getU(ByteBuffer buffer, int index) {
        return buffer.getFloat(this.getBufferPosition(index) + 16);
    }

    protected float getV(ByteBuffer buffer, int index) {
        return buffer.getFloat(this.getBufferPosition(index) + 20);
    }

    protected int getLight(ByteBuffer buffer, int index) {
        return buffer.getInt(this.getBufferPosition(index) + 24);
    }

    protected byte getNX(ByteBuffer buffer, int index) {
        return buffer.get(this.getBufferPosition(index) + 28);
    }

    protected byte getNY(ByteBuffer buffer, int index) {
        return buffer.get(this.getBufferPosition(index) + 29);
    }

    protected byte getNZ(ByteBuffer buffer, int index) {
        return buffer.get(this.getBufferPosition(index) + 30);
    }
}

